/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.krad.web.bind;

import java.beans.PropertyEditorSupport;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import org.kuali.rice.core.api.util.type.KualiDecimal;
import org.kuali.rice.core.api.util.type.KualiPercent;
import org.kuali.rice.core.web.format.FormatException;

public class UifPercentageEditor
extends PropertyEditorSupport
implements Serializable {
    private static final long serialVersionUID = -3562156375311932094L;
    public static final int PERCENTAGE_SCALE = 2;
    public static final String PERCENTAGE_FORMAT = "#,##0.00";

    @Override
    public String getAsText() {
        String stringValue;
        Object value = this.getValue();
        if (value == null) {
            return "";
        }
        try {
            if (value instanceof KualiDecimal) {
                value = ((KualiDecimal)this.getValue()).bigDecimalValue();
            }
            BigDecimal bigDecValue = (BigDecimal)value;
            bigDecValue = bigDecValue.setScale(2, 4);
            stringValue = NumberFormat.getInstance().format(bigDecValue.doubleValue());
        }
        catch (IllegalArgumentException iae) {
            throw new FormatException("formatting", "error.percentage", this.getValue().toString(), (Throwable)iae);
        }
        return stringValue + " percent";
    }

    @Override
    public void setAsText(String text) throws IllegalArgumentException {
        try {
            DecimalFormat formatter = new DecimalFormat(PERCENTAGE_FORMAT);
            Number parsedNumber = formatter.parse(text.trim());
            this.setValue(new KualiPercent(parsedNumber.doubleValue()));
        }
        catch (NumberFormatException | ParseException e) {
            throw new FormatException("parsing", "error.percentage", text, (Throwable)e);
        }
    }
}

