/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.krad.web.bind;

import java.util.Map;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.kfs.krad.service.KRADServiceLocatorWeb;
import org.kuali.kfs.krad.uif.UifConstants;
import org.kuali.kfs.krad.uif.service.ViewService;
import org.kuali.kfs.krad.uif.view.View;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.krad.util.KRADUtils;
import org.kuali.kfs.krad.web.bind.UifBeanPropertyBindingResult;
import org.kuali.kfs.krad.web.bind.UifBindingErrorProcessor;
import org.kuali.kfs.krad.web.form.UifFormBase;
import org.springframework.core.convert.ConversionService;
import org.springframework.util.Assert;
import org.springframework.validation.AbstractPropertyBindingResult;
import org.springframework.validation.BindingErrorProcessor;
import org.springframework.web.bind.ServletRequestDataBinder;

public class UifServletRequestDataBinder
extends ServletRequestDataBinder {
    private static final Logger LOG = LogManager.getLogger(UifServletRequestDataBinder.class);
    private UifBeanPropertyBindingResult bindingResult;
    private ConversionService conversionService;

    public UifServletRequestDataBinder(Object target) {
        super(target);
        this.setBindingErrorProcessor((BindingErrorProcessor)new UifBindingErrorProcessor());
    }

    public UifServletRequestDataBinder(Object target, String name) {
        super(target, name);
        this.setBindingErrorProcessor((BindingErrorProcessor)new UifBindingErrorProcessor());
    }

    public void initBeanPropertyAccess() {
        Assert.state((this.bindingResult == null ? 1 : 0) != 0, (String)"DataBinder is already initialized - call initBeanPropertyAccess before other configuration methods");
        this.bindingResult = new UifBeanPropertyBindingResult(this.getTarget(), this.getObjectName(), this.isAutoGrowNestedPaths(), this.getAutoGrowCollectionLimit());
        if (this.conversionService != null) {
            this.bindingResult.initConversion(this.conversionService);
        }
    }

    protected AbstractPropertyBindingResult getInternalBindingResult() {
        if (this.bindingResult == null) {
            this.initBeanPropertyAccess();
        }
        return this.bindingResult;
    }

    public void initDirectFieldAccess() {
        LOG.error("Direct Field access is not allowed in UifServletRequestDataBinder.");
        throw new RuntimeException("Direct Field access is not allowed in Kuali");
    }

    public void bind(ServletRequest request) {
        super.bind(request);
        UifFormBase form = (UifFormBase)this.getTarget();
        Boolean skipViewInit = KRADUtils.getRequestParameterAsBoolean(request, "skipViewInit");
        if (skipViewInit == null || !skipViewInit.booleanValue()) {
            View view = null;
            String viewId = request.getParameter("viewId");
            if (viewId != null) {
                view = this.getViewService().getViewById(viewId);
            } else {
                UifConstants.ViewType viewType;
                String viewTypeName = request.getParameter("viewTypeName");
                UifConstants.ViewType viewType2 = viewType = StringUtils.isBlank((CharSequence)viewTypeName) ? form.getViewTypeName() : UifConstants.ViewType.valueOf(viewTypeName);
                if (viewType != null) {
                    Map<String, String> parameterMap = KRADUtils.translateRequestParameterMap(request.getParameterMap());
                    view = this.getViewService().getViewByType(viewType, parameterMap);
                }
                if (view == null && (view = this.getViewFromPreviousModel(form)) != null) {
                    LOG.warn("Obtained viewId from cached form, this may not be safe!");
                }
            }
            if (view != null) {
                form.setViewId(view.getId());
                form.setView(view);
            } else {
                form.setViewId(null);
                form.setView(null);
            }
        }
        form.postBind((HttpServletRequest)request);
        GlobalVariables.getUifFormManager().addForm(form);
    }

    protected View getViewFromPreviousModel(UifFormBase form) {
        if (form.getViewId() != null) {
            return this.getViewService().getViewById(form.getViewId());
        }
        return null;
    }

    public ViewService getViewService() {
        return KRADServiceLocatorWeb.getViewService();
    }
}

