/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.krad.web.controller;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.kfs.krad.UserSessionUtils;
import org.kuali.kfs.krad.bo.AdHocRouteRecipient;
import org.kuali.kfs.krad.bo.Attachment;
import org.kuali.kfs.krad.bo.DocumentHeader;
import org.kuali.kfs.krad.bo.Note;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.krad.document.DocumentAuthorizer;
import org.kuali.kfs.krad.exception.DocumentAuthorizationException;
import org.kuali.kfs.krad.exception.UnknownDocumentIdException;
import org.kuali.kfs.krad.exception.ValidationException;
import org.kuali.kfs.krad.maintenance.MaintenanceDocument;
import org.kuali.kfs.krad.rules.rule.event.AddNoteEvent;
import org.kuali.kfs.krad.service.AttachmentService;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.krad.service.DataDictionaryService;
import org.kuali.kfs.krad.service.DocumentDictionaryService;
import org.kuali.kfs.krad.service.DocumentService;
import org.kuali.kfs.krad.service.KRADServiceLocator;
import org.kuali.kfs.krad.service.KRADServiceLocatorWeb;
import org.kuali.kfs.krad.service.NoteService;
import org.kuali.kfs.krad.uif.UifConstants;
import org.kuali.kfs.krad.uif.container.CollectionGroup;
import org.kuali.kfs.krad.uif.util.ObjectPropertyUtils;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.krad.util.NoteType;
import org.kuali.kfs.krad.web.controller.UifControllerBase;
import org.kuali.kfs.krad.web.form.DocumentFormBase;
import org.kuali.kfs.krad.web.form.UifFormBase;
import org.kuali.rice.core.api.config.property.ConfigurationService;
import org.kuali.rice.core.api.exception.RiceRuntimeException;
import org.kuali.rice.kew.api.WorkflowDocument;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.kuali.rice.kim.api.identity.Person;
import org.springframework.util.FileCopyUtils;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.ServletRequestBindingException;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.servlet.ModelAndView;

public abstract class DocumentControllerBase
extends UifControllerBase {
    private static final Logger LOG = LogManager.getLogger(DocumentControllerBase.class);
    protected static final String[] DOCUMENT_LOAD_COMMANDS = new String[]{"displayActionListView", "displayDocSearchView", "displaySuperUserView", "displayHelpDeskActionListView"};
    private BusinessObjectService businessObjectService;
    private DataDictionaryService dataDictionaryService;
    private DocumentService documentService;
    private DocumentDictionaryService documentDictionaryService;
    private AttachmentService attachmentService;
    private NoteService noteService;

    @Override
    protected abstract DocumentFormBase createInitialForm(HttpServletRequest var1);

    @RequestMapping(params={"methodToCall=docHandler"})
    public ModelAndView docHandler(@ModelAttribute(value="KualiForm") DocumentFormBase form, BindingResult result, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String command = form.getCommand();
        if (ArrayUtils.contains((Object[])DOCUMENT_LOAD_COMMANDS, (Object)command) && form.getDocId() != null) {
            this.loadDocument(form);
        } else if ("initiate".equals(command)) {
            this.createDocument(form);
        } else {
            LOG.error("docHandler called with invalid parameters");
            throw new IllegalArgumentException("docHandler called with invalid parameters");
        }
        return this.getUIFModelAndView(form);
    }

    protected void loadDocument(DocumentFormBase form) throws WorkflowException {
        String docId = form.getDocId();
        LOG.debug("Loading document" + docId);
        Document doc = this.getDocumentService().getByDocumentHeaderId(docId);
        if (doc == null) {
            throw new UnknownDocumentIdException("Document no longer exists. It may have been cancelled before being saved.");
        }
        WorkflowDocument workflowDocument = doc.getDocumentHeader().getWorkflowDocument();
        if (!this.getDocumentDictionaryService().getDocumentAuthorizer(doc).canOpen(doc, GlobalVariables.getUserSession().getPerson())) {
            throw this.buildAuthorizationException("open", doc);
        }
        if (workflowDocument != doc.getDocumentHeader().getWorkflowDocument()) {
            LOG.warn("Workflow document changed via canOpen check");
            doc.getDocumentHeader().setWorkflowDocument(workflowDocument);
        }
        form.setDocument(doc);
        WorkflowDocument workflowDoc = doc.getDocumentHeader().getWorkflowDocument();
        form.setDocTypeName(workflowDoc.getDocumentTypeName());
        UserSessionUtils.addWorkflowDocument(GlobalVariables.getUserSession(), workflowDoc);
    }

    protected void createDocument(DocumentFormBase form) throws WorkflowException {
        LOG.debug("Creating new document instance for doc type: " + form.getDocTypeName());
        Document doc = this.getDocumentService().getNewDocument(form.getDocTypeName());
        form.setDocument(doc);
        form.setDocTypeName(doc.getDocumentHeader().getWorkflowDocument().getDocumentTypeName());
    }

    @RequestMapping(params={"methodToCall=reload"})
    public ModelAndView reload(@ModelAttribute(value="KualiForm") DocumentFormBase form, BindingResult result, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Document document = form.getDocument();
        form.setDocId(document.getDocumentNumber());
        form.setCommand(DOCUMENT_LOAD_COMMANDS[1]);
        GlobalVariables.getMessageMap().putInfo("GlobalMessages", "message.document.reloaded", new String[0]);
        return this.docHandler(form, result, request, response);
    }

    @Override
    @RequestMapping(params={"methodToCall=cancel"})
    public ModelAndView cancel(@ModelAttribute(value="KualiForm") UifFormBase form, BindingResult result, HttpServletRequest request, HttpServletResponse response) {
        DocumentFormBase documentForm = (DocumentFormBase)form;
        this.performWorkflowAction(documentForm, UifConstants.WorkflowAction.CANCEL, false);
        return this.returnToPrevious(form);
    }

    @RequestMapping(params={"methodToCall=save"})
    public ModelAndView save(@ModelAttribute(value="KualiForm") DocumentFormBase form, BindingResult result, HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.performWorkflowAction(form, UifConstants.WorkflowAction.SAVE, true);
        return this.getUIFModelAndView(form);
    }

    @RequestMapping(params={"methodToCall=complete"})
    public ModelAndView complete(@ModelAttribute(value="KualiForm") DocumentFormBase form, BindingResult result, HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.performWorkflowAction(form, UifConstants.WorkflowAction.COMPLETE, true);
        return this.getUIFModelAndView(form);
    }

    @RequestMapping(params={"methodToCall=route"})
    public ModelAndView route(@ModelAttribute(value="KualiForm") DocumentFormBase form, BindingResult result, HttpServletRequest request, HttpServletResponse response) {
        this.performWorkflowAction(form, UifConstants.WorkflowAction.ROUTE, true);
        return this.getUIFModelAndView(form);
    }

    @RequestMapping(params={"methodToCall=blanketApprove"})
    public ModelAndView blanketApprove(@ModelAttribute(value="KualiForm") DocumentFormBase form, BindingResult result, HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.performWorkflowAction(form, UifConstants.WorkflowAction.BLANKETAPPROVE, true);
        return this.returnToPrevious(form);
    }

    @RequestMapping(params={"methodToCall=approve"})
    public ModelAndView approve(@ModelAttribute(value="KualiForm") DocumentFormBase form, BindingResult result, HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.performWorkflowAction(form, UifConstants.WorkflowAction.APPROVE, true);
        return this.returnToPrevious(form);
    }

    @RequestMapping(params={"methodToCall=disapprove"})
    public ModelAndView disapprove(@ModelAttribute(value="KualiForm") DocumentFormBase form, BindingResult result, HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.performWorkflowAction(form, UifConstants.WorkflowAction.DISAPPROVE, true);
        return this.returnToPrevious(form);
    }

    @RequestMapping(params={"methodToCall=fyi"})
    public ModelAndView fyi(@ModelAttribute(value="KualiForm") DocumentFormBase form, BindingResult result, HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.performWorkflowAction(form, UifConstants.WorkflowAction.FYI, false);
        return this.returnToPrevious(form);
    }

    @RequestMapping(params={"methodToCall=acknowledge"})
    public ModelAndView acknowledge(@ModelAttribute(value="KualiForm") DocumentFormBase form, BindingResult result, HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.performWorkflowAction(form, UifConstants.WorkflowAction.ACKNOWLEDGE, false);
        return this.returnToPrevious(form);
    }

    protected void performWorkflowAction(DocumentFormBase form, UifConstants.WorkflowAction action, boolean checkSensitiveData) {
        Document document = form.getDocument();
        LOG.debug("Performing workflow action " + action.name() + "for document: " + document.getDocumentNumber());
        try {
            String successMessageKey = null;
            switch (action) {
                case SAVE: {
                    this.getDocumentService().saveDocument(document);
                    successMessageKey = "message.saved";
                    break;
                }
                case ROUTE: {
                    this.getDocumentService().routeDocument(document, form.getAnnotation(), this.combineAdHocRecipients(form));
                    successMessageKey = "message.route.successful";
                    break;
                }
                case BLANKETAPPROVE: {
                    this.getDocumentService().blanketApproveDocument(document, form.getAnnotation(), this.combineAdHocRecipients(form));
                    successMessageKey = "message.route.approved";
                    break;
                }
                case APPROVE: {
                    this.getDocumentService().approveDocument(document, form.getAnnotation(), this.combineAdHocRecipients(form));
                    successMessageKey = "message.route.approved";
                    break;
                }
                case DISAPPROVE: {
                    String disapprovalNoteText = "";
                    this.getDocumentService().disapproveDocument(document, disapprovalNoteText);
                    successMessageKey = "message.route.disapproved";
                    break;
                }
                case FYI: {
                    this.getDocumentService().clearDocumentFyi(document, this.combineAdHocRecipients(form));
                    successMessageKey = "message.route.fyied";
                    break;
                }
                case ACKNOWLEDGE: {
                    this.getDocumentService().acknowledgeDocument(document, form.getAnnotation(), this.combineAdHocRecipients(form));
                    successMessageKey = "message.route.acknowledged";
                    break;
                }
                case CANCEL: {
                    if (!this.getDocumentService().documentExists(document.getDocumentNumber())) break;
                    this.getDocumentService().cancelDocument(document, form.getAnnotation());
                    successMessageKey = "message.cancelled";
                    break;
                }
                case COMPLETE: {
                    if (!this.getDocumentService().documentExists(document.getDocumentNumber())) break;
                    this.getDocumentService().completeDocument(document, form.getAnnotation(), this.combineAdHocRecipients(form));
                    successMessageKey = "message.route.successful";
                    break;
                }
            }
            if (successMessageKey != null) {
                GlobalVariables.getMessageMap().putInfo("GlobalMessages", successMessageKey, new String[0]);
            }
        }
        catch (ValidationException e) {
            if (GlobalVariables.getMessageMap().hasNoErrors()) {
                throw new RiceRuntimeException("Validation Exception with no error message.", (Throwable)((Object)e));
            }
        }
        catch (Exception e) {
            throw new RiceRuntimeException("Exception trying to invoke action " + action.name() + "for document: " + document.getDocumentNumber(), (Throwable)e);
        }
        form.setAnnotation("");
    }

    @RequestMapping(params={"methodToCall=supervisorFunctions"})
    public ModelAndView supervisorFunctions(@ModelAttribute(value="KualiForm") DocumentFormBase form, BindingResult result, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String workflowSuperUserUrl = this.getConfigurationService().getPropertyValueAsString("workflow.url") + "/" + "SuperUser.do";
        Properties props = new Properties();
        props.put("methodToCall", "displaySuperUserDocument");
        props.put("documentId", form.getDocument().getDocumentNumber());
        return this.performRedirect(form, workflowSuperUserUrl, props);
    }

    @RequestMapping(method={RequestMethod.POST}, params={"methodToCall=insertNote"})
    public ModelAndView insertNote(@ModelAttribute(value="KualiForm") UifFormBase uifForm, BindingResult result, HttpServletRequest request, HttpServletResponse response) {
        Person kualiUser;
        String selectedCollectionPath = uifForm.getActionParamaterValue("selectedCollectionPath");
        CollectionGroup collectionGroup = uifForm.getPostedView().getViewIndex().getCollectionGroupByPath(selectedCollectionPath);
        String addLinePath = collectionGroup.getAddLineBindingInfo().getBindingPath();
        Object addLine = ObjectPropertyUtils.getPropertyValue(uifForm, addLinePath);
        Note newNote = (Note)addLine;
        newNote.setNotePostedTimestampToCurrent();
        Document document = ((DocumentFormBase)uifForm).getDocument();
        newNote.setRemoteObjectIdentifier(document.getNoteTarget().getObjectId());
        String attachmentTypeCode = null;
        MultipartFile attachmentFile = uifForm.getAttachmentFile();
        Attachment attachment = null;
        if (attachmentFile != null && !StringUtils.isBlank((CharSequence)attachmentFile.getOriginalFilename())) {
            if (attachmentFile.getSize() == 0L) {
                GlobalVariables.getMessageMap().putError(String.format("%s.%s", "newNote", "attachmentFile"), "error.uploadFile.empty", attachmentFile.getOriginalFilename());
            } else {
                DocumentAuthorizer documentAuthorizer;
                if (newNote.getAttachment() != null) {
                    attachmentTypeCode = newNote.getAttachment().getAttachmentTypeCode();
                }
                if (!(documentAuthorizer = this.getDocumentDictionaryService().getDocumentAuthorizer(document)).canAddNoteAttachment(document, attachmentTypeCode, GlobalVariables.getUserSession().getPerson())) {
                    throw this.buildAuthorizationException("annotate", document);
                }
                try {
                    String attachmentType = null;
                    Attachment newAttachment = newNote.getAttachment();
                    if (newAttachment != null) {
                        attachmentType = newAttachment.getAttachmentTypeCode();
                    }
                    attachment = this.getAttachmentService().createAttachment(document.getNoteTarget(), attachmentFile.getOriginalFilename(), attachmentFile.getContentType(), (int)attachmentFile.getSize(), attachmentFile.getInputStream(), attachmentType);
                }
                catch (IOException e) {
                    throw new RiceRuntimeException("Unable to store attachment", (Throwable)e);
                }
            }
        }
        if ((kualiUser = GlobalVariables.getUserSession().getPerson()) == null) {
            throw new IllegalStateException("Current UserSession has a null Person.");
        }
        newNote.setAuthorUniversalIdentifier(kualiUser.getPrincipalId());
        boolean rulePassed = KRADServiceLocatorWeb.getKualiRuleService().applyRules(new AddNoteEvent(document, newNote));
        if (rulePassed) {
            newNote.refresh();
            DocumentHeader documentHeader = document.getDocumentHeader();
            if (attachment != null) {
                newNote.addAttachment(attachment);
            }
            if (!(documentHeader.getWorkflowDocument().isInitiated() || !StringUtils.isNotEmpty((CharSequence)document.getNoteTarget().getObjectId()) || document instanceof MaintenanceDocument && NoteType.BUSINESS_OBJECT.getCode().equals(newNote.getNoteTypeCode()))) {
                this.getNoteService().save(newNote);
            }
        }
        return this.addLine(uifForm, result, request, response);
    }

    @RequestMapping(method={RequestMethod.POST}, params={"methodToCall=deleteNote"})
    public ModelAndView deleteNote(@ModelAttribute(value="KualiForm") UifFormBase uifForm, BindingResult result, HttpServletRequest request, HttpServletResponse response) {
        String selectedLineIndex = uifForm.getActionParamaterValue("selectedLineIndex");
        Document document = ((DocumentFormBase)uifForm).getDocument();
        Note note = document.getNote(Integer.parseInt(selectedLineIndex));
        Attachment attachment = note.getAttachment();
        String attachmentTypeCode = null;
        if (attachment != null) {
            attachmentTypeCode = attachment.getAttachmentTypeCode();
        }
        Person user = GlobalVariables.getUserSession().getPerson();
        String authorUniversalIdentifier = note.getAuthorUniversalIdentifier();
        if (!this.getDocumentDictionaryService().getDocumentAuthorizer(document).canDeleteNoteAttachment(document, attachmentTypeCode, authorUniversalIdentifier, user)) {
            throw this.buildAuthorizationException("annotate", document);
        }
        if (attachment != null && attachment.isComplete()) {
            if (note.getNoteIdentifier() != null) {
                attachment.refreshNonUpdateableReferences();
            }
            this.getAttachmentService().deleteAttachmentContents(attachment);
        }
        if (!document.getDocumentHeader().getWorkflowDocument().isInitiated()) {
            this.getNoteService().deleteNote(note);
        }
        return this.deleteLine(uifForm, result, request, response);
    }

    @RequestMapping(method={RequestMethod.POST}, params={"methodToCall=downloadAttachment"})
    public ModelAndView downloadAttachment(@ModelAttribute(value="KualiForm") UifFormBase uifForm, BindingResult result, HttpServletRequest request, HttpServletResponse response) throws ServletRequestBindingException, FileNotFoundException, IOException {
        String selectedLineIndex = uifForm.getActionParamaterValue("selectedLineIndex");
        Note note = ((DocumentFormBase)uifForm).getDocument().getNote(Integer.parseInt(selectedLineIndex));
        Attachment attachment = note.getAttachment();
        InputStream is = this.getAttachmentService().retrieveAttachmentContents(attachment);
        response.setContentType(attachment.getAttachmentMimeTypeCode());
        response.setContentLength(attachment.getAttachmentFileSize().intValue());
        response.setHeader("Expires", "0");
        response.setHeader("Cache-Control", "must-revalidate, post-check=0, pre-check=0");
        response.setHeader("Pragma", "public");
        response.setHeader("Content-Disposition", "attachment; filename=\"" + attachment.getAttachmentFileName() + "\"");
        FileCopyUtils.copy((InputStream)is, (OutputStream)response.getOutputStream());
        return null;
    }

    @RequestMapping(method={RequestMethod.POST}, params={"methodToCall=cancelAttachment"})
    public ModelAndView cancelAttachment(@ModelAttribute(value="KualiForm") UifFormBase uifForm, BindingResult result, HttpServletRequest request, HttpServletResponse response) {
        uifForm.setAttachmentFile(null);
        return this.getUIFModelAndView(uifForm);
    }

    protected String checkAndWarnAboutSensitiveData(DocumentFormBase form, HttpServletRequest request, HttpServletResponse response, String fieldName, String fieldValue, String caller, String context) throws Exception {
        return null;
    }

    protected List<AdHocRouteRecipient> combineAdHocRecipients(DocumentFormBase form) {
        Document document = form.getDocument();
        ArrayList<AdHocRouteRecipient> adHocRecipients = new ArrayList<AdHocRouteRecipient>();
        adHocRecipients.addAll(document.getAdHocRoutePersons());
        adHocRecipients.addAll(document.getAdHocRouteWorkgroups());
        return adHocRecipients;
    }

    protected DocumentAuthorizationException buildAuthorizationException(String action, Document document) {
        return new DocumentAuthorizationException(GlobalVariables.getUserSession().getPerson().getPrincipalName(), action, document.getDocumentNumber());
    }

    public BusinessObjectService getBusinessObjectService() {
        if (this.businessObjectService == null) {
            this.businessObjectService = KRADServiceLocator.getBusinessObjectService();
        }
        return this.businessObjectService;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    public DataDictionaryService getDataDictionaryService() {
        if (this.dataDictionaryService == null) {
            this.dataDictionaryService = KRADServiceLocatorWeb.getDataDictionaryService();
        }
        return this.dataDictionaryService;
    }

    public void setDataDictionaryService(DataDictionaryService dataDictionaryService) {
        this.dataDictionaryService = dataDictionaryService;
    }

    public DocumentService getDocumentService() {
        if (this.documentService == null) {
            this.documentService = KRADServiceLocatorWeb.getDocumentService();
        }
        return this.documentService;
    }

    public void setDocumentService(DocumentService documentService) {
        this.documentService = documentService;
    }

    public DocumentDictionaryService getDocumentDictionaryService() {
        if (this.documentDictionaryService == null) {
            this.documentDictionaryService = KRADServiceLocatorWeb.getDocumentDictionaryService();
        }
        return this.documentDictionaryService;
    }

    public void setDocumentDictionaryService(DocumentDictionaryService documentDictionaryService) {
        this.documentDictionaryService = documentDictionaryService;
    }

    public AttachmentService getAttachmentService() {
        if (this.attachmentService == null) {
            this.attachmentService = KRADServiceLocator.getAttachmentService();
        }
        return this.attachmentService;
    }

    public NoteService getNoteService() {
        if (this.noteService == null) {
            this.noteService = KRADServiceLocator.getNoteService();
        }
        return this.noteService;
    }

    public ConfigurationService getConfigurationService() {
        return KRADServiceLocator.getKualiConfigurationService();
    }
}

