/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.krad.workflow;

import java.util.ArrayList;
import java.util.Map;
import javax.xml.namespace.NamespaceContext;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import javax.xml.xpath.XPathFunctionResolver;
import org.apache.commons.lang3.StringUtils;
import org.kuali.kfs.kns.util.FieldUtils;
import org.kuali.kfs.kns.web.ui.Field;
import org.kuali.kfs.kns.web.ui.Row;
import org.kuali.kfs.krad.service.KRADServiceLocatorWeb;
import org.kuali.rice.kew.engine.RouteContext;
import org.kuali.rice.kew.rule.xmlrouting.WorkflowFunctionResolver;
import org.kuali.rice.kew.rule.xmlrouting.WorkflowNamespaceContext;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public final class WorkflowUtils {
    private static final String XPATH_ROUTE_CONTEXT_KEY = "_xpathKey";
    public static final String XSTREAM_SAFE_PREFIX = "wf:xstreamsafe('";
    public static final String XSTREAM_SAFE_SUFFIX = "')";
    public static final String XSTREAM_MATCH_ANYWHERE_PREFIX = "//";
    public static final String XSTREAM_MATCH_RELATIVE_PREFIX = "./";

    private WorkflowUtils() {
        throw new UnsupportedOperationException("do not call");
    }

    public static XPath getXPath(Document document) {
        XPath xpath = WorkflowUtils.getXPath(RouteContext.getCurrentRouteContext());
        xpath.setNamespaceContext((NamespaceContext)new WorkflowNamespaceContext());
        WorkflowFunctionResolver resolver = new WorkflowFunctionResolver();
        resolver.setXpath(xpath);
        resolver.setRootNode((Node)document);
        xpath.setXPathFunctionResolver((XPathFunctionResolver)resolver);
        return xpath;
    }

    public static XPath getXPath(RouteContext routeContext) {
        if (routeContext == null) {
            return XPathFactory.newInstance().newXPath();
        }
        if (!routeContext.getParameters().containsKey(XPATH_ROUTE_CONTEXT_KEY)) {
            routeContext.getParameters().put(XPATH_ROUTE_CONTEXT_KEY, XPathFactory.newInstance().newXPath());
        }
        return (XPath)routeContext.getParameters().get(XPATH_ROUTE_CONTEXT_KEY);
    }

    public static String xstreamSafeEval(XPath xpath, String xpathExpression, Object item) {
        String evalResult;
        String xstreamSafeXPath = WorkflowUtils.xstreamSafeXPath(xpathExpression);
        try {
            evalResult = xpath.evaluate(xstreamSafeXPath, item);
        }
        catch (XPathExpressionException e) {
            throw new RuntimeException("XPathExpressionException occurred on xpath: " + xstreamSafeXPath, e);
        }
        return evalResult;
    }

    public static String xstreamSafeXPath(String xpathExpression) {
        return XSTREAM_SAFE_PREFIX + xpathExpression + XSTREAM_SAFE_SUFFIX;
    }

    public static String getBusinessObjectAttributeLabel(Class businessObjectClass, String attributeName) {
        return KRADServiceLocatorWeb.getDataDictionaryService().getAttributeLabel(businessObjectClass, attributeName);
    }

    public static Row buildTextRow(Class propertyClass, String boPropertyName, String workflowPropertyKey) {
        if (propertyClass == null) {
            throw new IllegalArgumentException("Method parameter 'propertyClass' was passed a NULL value.");
        }
        if (StringUtils.isBlank((CharSequence)boPropertyName)) {
            throw new IllegalArgumentException("Method parameter 'boPropertyName' was passed a NULL or blank value.");
        }
        if (StringUtils.isBlank((CharSequence)workflowPropertyKey)) {
            throw new IllegalArgumentException("Method parameter 'workflowPropertyKey' was passed a NULL or blank value.");
        }
        ArrayList<Field> fields = new ArrayList<Field>();
        Field field = FieldUtils.getPropertyField(propertyClass, boPropertyName, false);
        fields.add(field);
        return new Row(fields);
    }

    public static Row buildTextRowWithLookup(Class propertyClass, String boPropertyName, String workflowPropertyKey) {
        return WorkflowUtils.buildTextRowWithLookup(propertyClass, boPropertyName, workflowPropertyKey, null);
    }

    public static Row buildTextRowWithLookup(Class propertyClass, String boPropertyName, String workflowPropertyKey, Map fieldConversionsByBoPropertyName) {
        if (propertyClass == null) {
            throw new IllegalArgumentException("Method parameter 'propertyClass' was passed a NULL value.");
        }
        if (StringUtils.isBlank((CharSequence)boPropertyName)) {
            throw new IllegalArgumentException("Method parameter 'boPropertyName' was passed a NULL or blank value.");
        }
        if (StringUtils.isBlank((CharSequence)workflowPropertyKey)) {
            throw new IllegalArgumentException("Method parameter 'workflowPropertyKey' was passed a NULL or blank value.");
        }
        Field field = FieldUtils.getPropertyField(propertyClass, boPropertyName, false);
        ArrayList<Field> fields = new ArrayList<Field>();
        fields.add(field);
        return new Row(fields);
    }

    public static Row buildDropdownRow(Class propertyClass, String boPropertyName, String workflowPropertyKey, Map<String, String> optionMap, boolean addBlankRow) {
        if (propertyClass == null) {
            throw new IllegalArgumentException("Method parameter 'propertyClass' was passed a NULL value.");
        }
        if (StringUtils.isBlank((CharSequence)boPropertyName)) {
            throw new IllegalArgumentException("Method parameter 'boPropertyName' was passed a NULL or blank value.");
        }
        if (StringUtils.isBlank((CharSequence)workflowPropertyKey)) {
            throw new IllegalArgumentException("Method parameter 'workflowPropertyKey' was passed a NULL or blank value.");
        }
        if (optionMap == null) {
            throw new IllegalArgumentException("Method parameter 'optionMap' was passed a NULL value.");
        }
        ArrayList<Field> fields = new ArrayList<Field>();
        Field field = FieldUtils.getPropertyField(propertyClass, boPropertyName, false);
        fields.add(field);
        return new Row(fields);
    }
}

