/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.kns.lookup;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.apache.commons.codec.binary.Base64;
import org.kuali.kfs.kns.lookup.LookupResultsService;
import org.kuali.kfs.kns.lookup.LookupResultsSupportStrategyService;
import org.kuali.kfs.kns.lookup.LookupUtils;
import org.kuali.kfs.kns.web.ui.ResultRow;
import org.kuali.kfs.krad.bo.LookupResults;
import org.kuali.kfs.krad.bo.MultipleValueLookupMetadata;
import org.kuali.kfs.krad.bo.SelectedObjectIds;
import org.kuali.kfs.krad.dao.PersistedLookupMetadataDao;
import org.kuali.kfs.krad.exception.AuthorizationException;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.rice.core.api.CoreApiServiceLocator;
import org.kuali.rice.krad.bo.BusinessObject;
import org.springframework.transaction.annotation.Transactional;

@Transactional
public class LookupResultsServiceImpl
implements LookupResultsService {
    private BusinessObjectService businessObjectService;
    private PersistedLookupMetadataDao persistedLookupMetadataDao;
    private LookupResultsSupportStrategyService persistableBusinessObjectSupportStrategy;
    private LookupResultsSupportStrategyService dataDictionarySupportStrategy;

    @Override
    public void persistResultsTable(String lookupResultsSequenceNumber, List<ResultRow> resultTable, String personId) throws Exception {
        String resultTableString = new String(Base64.encodeBase64((byte[])ObjectUtils.toByteArray(resultTable)));
        Timestamp now = CoreApiServiceLocator.getDateTimeService().getCurrentTimestamp();
        LookupResults lookupResults = this.retrieveLookupResults(lookupResultsSequenceNumber);
        if (lookupResults == null) {
            lookupResults = new LookupResults();
            lookupResults.setLookupResultsSequenceNumber(lookupResultsSequenceNumber);
        }
        lookupResults.setLookupResultsSequenceNumber(lookupResultsSequenceNumber);
        lookupResults.setLookupPersonId(personId);
        lookupResults.setSerializedLookupResults(resultTableString);
        lookupResults.setLookupDate(now);
        this.businessObjectService.save(lookupResults);
    }

    @Override
    public void persistSelectedObjectIds(String lookupResultsSequenceNumber, Set<String> selectedObjectIds, String personId) throws Exception {
        SelectedObjectIds selectedObjectIdsBO = this.retrieveSelectedObjectIds(lookupResultsSequenceNumber);
        if (selectedObjectIdsBO == null) {
            selectedObjectIdsBO = new SelectedObjectIds();
            selectedObjectIdsBO.setLookupResultsSequenceNumber(lookupResultsSequenceNumber);
        }
        selectedObjectIdsBO.setLookupResultsSequenceNumber(lookupResultsSequenceNumber);
        selectedObjectIdsBO.setLookupPersonId(personId);
        selectedObjectIdsBO.setSelectedObjectIds(LookupUtils.convertSetOfObjectIdsToString(selectedObjectIds));
        selectedObjectIdsBO.setLookupDate(CoreApiServiceLocator.getDateTimeService().getCurrentTimestamp());
        this.businessObjectService.save(selectedObjectIdsBO);
    }

    protected LookupResults retrieveLookupResults(String lookupResultsSequenceNumber) throws Exception {
        HashMap<String, String> queryCriteria = new HashMap<String, String>();
        queryCriteria.put("lookupResultsSequenceNumber", lookupResultsSequenceNumber);
        return this.businessObjectService.findByPrimaryKey(LookupResults.class, queryCriteria);
    }

    protected SelectedObjectIds retrieveSelectedObjectIds(String lookupResultsSequenceNumber) throws Exception {
        HashMap<String, String> queryCriteria = new HashMap<String, String>();
        queryCriteria.put("lookupResultsSequenceNumber", lookupResultsSequenceNumber);
        return this.businessObjectService.findByPrimaryKey(SelectedObjectIds.class, queryCriteria);
    }

    @Override
    public boolean isAuthorizedToAccessLookupResults(String lookupResultsSequenceNumber, String personId) {
        try {
            LookupResults lookupResults = this.retrieveLookupResults(lookupResultsSequenceNumber);
            return this.isAuthorizedToAccessLookupResults(lookupResults, personId);
        }
        catch (Exception e) {
            return false;
        }
    }

    protected boolean isAuthorizedToAccessLookupResults(LookupResults lookupResults, String personId) {
        return this.isAuthorizedToAccessMultipleValueLookupMetadata(lookupResults, personId);
    }

    @Override
    public boolean isAuthorizedToAccessSelectedObjectIds(String lookupResultsSequenceNumber, String personId) {
        try {
            SelectedObjectIds selectedObjectIds = this.retrieveSelectedObjectIds(lookupResultsSequenceNumber);
            return this.isAuthorizedToAccessSelectedObjectIds(selectedObjectIds, personId);
        }
        catch (Exception e) {
            return false;
        }
    }

    protected boolean isAuthorizedToAccessSelectedObjectIds(SelectedObjectIds selectedObjectIds, String personId) {
        return this.isAuthorizedToAccessMultipleValueLookupMetadata(selectedObjectIds, personId);
    }

    @Override
    public List<ResultRow> retrieveResultsTable(String lookupResultsSequenceNumber, String personId) throws Exception {
        LookupResults lookupResults = this.retrieveLookupResults(lookupResultsSequenceNumber);
        if (!this.isAuthorizedToAccessLookupResults(lookupResults, personId)) {
            throw new AuthorizationException(personId, "retrieve lookup results", "lookup sequence number " + lookupResultsSequenceNumber);
        }
        return (List)ObjectUtils.fromByteArray(Base64.decodeBase64((byte[])lookupResults.getSerializedLookupResults().getBytes()));
    }

    @Override
    public <T extends BusinessObject> Collection<T> retrieveSelectedResultBOs(String lookupResultsSequenceNumber, Class<T> boClass, String personId) throws Exception {
        LookupResultsSupportStrategyService supportService = this.getQualifingSupportStrategy(boClass);
        if (supportService == null) {
            throw new RuntimeException("BusinessObject class " + boClass.getName() + " cannot be used within a multiple value lookup; it either needs to be a PersistableBusinessObject or have both its primary keys and a lookupable defined in its data dictionary entry");
        }
        SelectedObjectIds selectedObjectIds = this.retrieveSelectedObjectIds(lookupResultsSequenceNumber);
        if (!this.isAuthorizedToAccessSelectedObjectIds(selectedObjectIds, personId)) {
            throw new AuthorizationException(personId, "retrieve lookup results", "lookup sequence number " + lookupResultsSequenceNumber);
        }
        Set<String> setOfSelectedObjIds = LookupUtils.convertStringOfObjectIdsToSet(selectedObjectIds.getSelectedObjectIds());
        if (setOfSelectedObjIds.isEmpty()) {
            return new ArrayList();
        }
        return supportService.retrieveSelectedResultBOs(boClass, setOfSelectedObjIds);
    }

    protected LookupResultsSupportStrategyService getQualifingSupportStrategy(Class boClass) {
        if (this.getPersistableBusinessObjectSupportStrategy().qualifiesForStrategy(boClass)) {
            return this.getPersistableBusinessObjectSupportStrategy();
        }
        if (this.getDataDictionarySupportStrategy().qualifiesForStrategy(boClass)) {
            return this.getDataDictionarySupportStrategy();
        }
        return null;
    }

    @Override
    public void clearPersistedLookupResults(String lookupResultsSequenceNumber) throws Exception {
        LookupResults lookupResults = this.retrieveLookupResults(lookupResultsSequenceNumber);
        if (lookupResults != null) {
            this.businessObjectService.delete(lookupResults);
        }
    }

    @Override
    public void clearPersistedSelectedObjectIds(String lookupResultsSequenceNumber) throws Exception {
        SelectedObjectIds selectedObjectIds = this.retrieveSelectedObjectIds(lookupResultsSequenceNumber);
        if (selectedObjectIds != null) {
            this.businessObjectService.delete(selectedObjectIds);
        }
    }

    @Override
    public String getLookupId(BusinessObject businessObject) {
        LookupResultsSupportStrategyService supportService = this.getQualifingSupportStrategy(businessObject.getClass());
        if (supportService == null) {
            return null;
        }
        return supportService.getLookupIdForBusinessObject(businessObject);
    }

    public BusinessObjectService getBusinessObjectService() {
        return this.businessObjectService;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    protected boolean isAuthorizedToAccessMultipleValueLookupMetadata(MultipleValueLookupMetadata mvlm, String personId) {
        return personId.equals(mvlm.getLookupPersonId());
    }

    @Override
    public void deleteOldLookupResults(Timestamp expirationDate) {
        this.persistedLookupMetadataDao.deleteOldLookupResults(expirationDate);
    }

    @Override
    public void deleteOldSelectedObjectIds(Timestamp expirationDate) {
        this.persistedLookupMetadataDao.deleteOldSelectedObjectIds(expirationDate);
    }

    public PersistedLookupMetadataDao getPersistedLookupMetadataDao() {
        return this.persistedLookupMetadataDao;
    }

    public void setPersistedLookupMetadataDao(PersistedLookupMetadataDao persistedLookupMetadataDao) {
        this.persistedLookupMetadataDao = persistedLookupMetadataDao;
    }

    public LookupResultsSupportStrategyService getPersistableBusinessObjectSupportStrategy() {
        return this.persistableBusinessObjectSupportStrategy;
    }

    public LookupResultsSupportStrategyService getDataDictionarySupportStrategy() {
        return this.dataDictionarySupportStrategy;
    }

    public void setPersistableBusinessObjectSupportStrategy(LookupResultsSupportStrategyService persistableBusinessObjectSupportStrategy) {
        this.persistableBusinessObjectSupportStrategy = persistableBusinessObjectSupportStrategy;
    }

    public void setDataDictionarySupportStrategy(LookupResultsSupportStrategyService dataDictionarySupportStrategy) {
        this.dataDictionarySupportStrategy = dataDictionarySupportStrategy;
    }
}

