/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.krad.bo;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.sql.Timestamp;
import java.util.Properties;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.OneToOne;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.kuali.kfs.krad.bo.AdHocRoutePerson;
import org.kuali.kfs.krad.bo.AdHocRouteRecipient;
import org.kuali.kfs.krad.bo.Attachment;
import org.kuali.kfs.krad.bo.NoteType;
import org.kuali.kfs.krad.bo.PersistableBusinessObjectBase;
import org.kuali.kfs.krad.service.KRADServiceLocator;
import org.kuali.kfs.krad.util.UrlFactory;
import org.kuali.rice.core.api.CoreApiServiceLocator;
import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.kim.api.services.KimApiServiceLocator;

@Entity
@Table(name="KRNS_NTE_T")
public class Note
extends PersistableBusinessObjectBase {
    private static final long serialVersionUID = -7647166354016356770L;
    @Id
    @GeneratedValue(generator="KRNS_NTE_S")
    @Column(name="NTE_ID")
    private Long noteIdentifier;
    @Column(name="RMT_OBJ_ID")
    private String remoteObjectIdentifier;
    @Column(name="AUTH_PRNCPL_ID")
    private String authorUniversalIdentifier;
    @Column(name="POST_TS")
    private Timestamp notePostedTimestamp;
    @Column(name="NTE_TYP_CD")
    private String noteTypeCode;
    @Column(name="TXT")
    private String noteText;
    @Column(name="TPC_TXT")
    private String noteTopicText;
    @Column(name="PRG_CD")
    private String notePurgeCode;
    @Transient
    private String attachmentIdentifier;
    @OneToOne(fetch=FetchType.EAGER)
    @JoinColumn(name="NTE_TYP_CD", insertable=false, updatable=false)
    private NoteType noteType;
    @Transient
    private transient Person authorUniversal;
    @OneToOne(fetch=FetchType.EAGER, cascade={CascadeType.ALL})
    @JoinColumn(name="NTE_ID", insertable=false, updatable=false)
    @JsonIgnore
    private Attachment attachment;
    @Transient
    @JsonIgnore
    private AdHocRouteRecipient adHocRouteRecipient;

    public Note() {
        this.setNoteText("");
        this.setNoteTypeCode("DH");
        this.setAdHocRouteRecipient(new AdHocRoutePerson());
    }

    public void setNotePostedTimestampToCurrent() {
        Timestamp now = CoreApiServiceLocator.getDateTimeService().getCurrentTimestamp();
        this.setNotePostedTimestamp(now);
    }

    public Long getNoteIdentifier() {
        return this.noteIdentifier;
    }

    public void setNoteIdentifier(Long noteIdentifier) {
        this.noteIdentifier = noteIdentifier;
    }

    public String getRemoteObjectIdentifier() {
        return this.remoteObjectIdentifier;
    }

    public void setRemoteObjectIdentifier(String remoteObjectIdentifier) {
        this.remoteObjectIdentifier = remoteObjectIdentifier;
    }

    public String getAuthorUniversalIdentifier() {
        return this.authorUniversalIdentifier;
    }

    public void setAuthorUniversalIdentifier(String noteAuthorIdentifier) {
        this.authorUniversalIdentifier = noteAuthorIdentifier;
    }

    public Timestamp getNotePostedTimestamp() {
        return this.notePostedTimestamp;
    }

    public void setNotePostedTimestamp(Timestamp notePostedTimestamp) {
        this.notePostedTimestamp = notePostedTimestamp;
    }

    public String getNoteTypeCode() {
        return this.noteTypeCode;
    }

    public void setNoteTypeCode(String noteTypeCode) {
        this.noteTypeCode = noteTypeCode;
    }

    public String getNoteText() {
        return this.noteText;
    }

    public void setNoteText(String noteText) {
        this.noteText = noteText;
    }

    public String getNoteTopicText() {
        return this.noteTopicText;
    }

    public void setNoteTopicText(String noteTopicText) {
        this.noteTopicText = noteTopicText;
    }

    public String getNotePurgeCode() {
        return this.notePurgeCode;
    }

    public void setNotePurgeCode(String notePurgeCode) {
        this.notePurgeCode = notePurgeCode;
    }

    public NoteType getNoteType() {
        return this.noteType;
    }

    public void setNoteType(NoteType noteType) {
        this.noteType = noteType;
    }

    public Person getAuthorUniversal() {
        this.authorUniversal = KimApiServiceLocator.getPersonService().updatePersonIfNecessary(this.authorUniversalIdentifier, this.authorUniversal);
        return this.authorUniversal;
    }

    public void setAuthorUniversal(Person authorUniversal) {
        this.authorUniversal = authorUniversal;
    }

    public Attachment getAttachment() {
        return this.attachment;
    }

    public void setAttachment(Attachment attachment) {
        this.attachment = attachment;
    }

    public String getAttachmentIdentifier() {
        return this.attachmentIdentifier;
    }

    public void setAttachmentIdentifier(String attachmentIdentifier) {
        this.attachmentIdentifier = attachmentIdentifier;
    }

    public void addAttachment(Attachment attachment) {
        this.setAttachmentIdentifier(attachment.getAttachmentIdentifier());
        this.setAttachment(attachment);
        attachment.setNoteIdentifier(this.noteIdentifier);
        attachment.setNote(this);
    }

    public void removeAttachment() {
        this.setAttachment(null);
        this.setAttachmentIdentifier(null);
    }

    public AdHocRouteRecipient getAdHocRouteRecipient() {
        return this.adHocRouteRecipient;
    }

    public void setAdHocRouteRecipient(AdHocRouteRecipient adHocRouteRecipient) {
        this.adHocRouteRecipient = adHocRouteRecipient;
    }

    public String getAttachmentLink() {
        if (KRADServiceLocator.getAttachmentService().getAttachmentByNoteId(this.getNoteIdentifier()) == null) {
            return "";
        }
        Properties params = new Properties();
        params.put("methodToCall", "downloadBOAttachment");
        params.put("docFormKey", "88888888");
        params.put("noteIdentifier", this.getNoteIdentifier().toString());
        return UrlFactory.parameterizeUrl(KRADServiceLocator.getKualiConfigurationService().getPropertyValueAsString("application.url") + "/" + "kr" + "/" + "inquiry.do", params);
    }
}

