/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.krad.datadictionary;

import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.kuali.kfs.krad.bo.Exporter;
import org.kuali.kfs.krad.datadictionary.DataDictionaryEntryBase;
import org.kuali.kfs.krad.datadictionary.HelpDefinition;
import org.kuali.kfs.krad.datadictionary.InactivationBlockingDefinition;
import org.kuali.kfs.krad.datadictionary.exception.AttributeValidationException;
import org.kuali.kfs.krad.datadictionary.validation.capability.MustOccurConstrainable;
import org.kuali.kfs.krad.datadictionary.validation.constraint.MustOccurConstraint;

public class DataObjectEntry
extends DataDictionaryEntryBase
implements MustOccurConstrainable {
    protected String name;
    protected Class<?> dataObjectClass;
    protected String titleAttribute;
    protected String objectLabel;
    protected String objectDescription;
    protected List<String> primaryKeys;
    protected Class<? extends Exporter> exporterClass;
    protected List<MustOccurConstraint> mustOccurConstraints;
    protected List<String> groupByAttributesForEffectiveDating;
    protected HelpDefinition helpDefinition;
    protected boolean boNotesEnabled = false;
    protected List<InactivationBlockingDefinition> inactivationBlockingDefinitions;

    @Override
    public void completeValidation() {
        if (StringUtils.isBlank((CharSequence)this.getObjectLabel())) {
            throw new AttributeValidationException("Object label cannot be blank for class " + this.dataObjectClass.getName());
        }
        super.completeValidation();
    }

    @Override
    public String getJstlKey() {
        if (this.dataObjectClass == null) {
            throw new IllegalStateException("cannot generate JSTL key: dataObjectClass is null");
        }
        return this.dataObjectClass.getSimpleName();
    }

    @Override
    public String getFullClassName() {
        return this.dataObjectClass.getName();
    }

    @Override
    public Class<?> getEntryClass() {
        return this.dataObjectClass;
    }

    public Class<?> getDataObjectClass() {
        return this.dataObjectClass;
    }

    public void setDataObjectClass(Class<?> dataObjectClass) {
        this.dataObjectClass = dataObjectClass;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getObjectLabel() {
        return this.objectLabel;
    }

    public void setObjectLabel(String objectLabel) {
        this.objectLabel = objectLabel;
    }

    public String getObjectDescription() {
        return this.objectDescription;
    }

    public void setObjectDescription(String objectDescription) {
        this.objectDescription = objectDescription;
    }

    public HelpDefinition getHelpDefinition() {
        return this.helpDefinition;
    }

    public void setHelpDefinition(HelpDefinition helpDefinition) {
        this.helpDefinition = helpDefinition;
    }

    public String toString() {
        return "DataObjectEntry for " + this.getDataObjectClass();
    }

    @Override
    public List<MustOccurConstraint> getMustOccurConstraints() {
        return this.mustOccurConstraints;
    }

    public void setMustOccurConstraints(List<MustOccurConstraint> mustOccurConstraints) {
        this.mustOccurConstraints = mustOccurConstraints;
    }

    public String getTitleAttribute() {
        return this.titleAttribute;
    }

    public void setTitleAttribute(String titleAttribute) {
        this.titleAttribute = titleAttribute;
    }

    public List<String> getPrimaryKeys() {
        return this.primaryKeys;
    }

    public void setPrimaryKeys(List<String> primaryKeys) {
        this.primaryKeys = primaryKeys;
    }

    public Class<? extends Exporter> getExporterClass() {
        return this.exporterClass;
    }

    public void setExporterClass(Class<? extends Exporter> exporterClass) {
        this.exporterClass = exporterClass;
    }

    public List<String> getGroupByAttributesForEffectiveDating() {
        return this.groupByAttributesForEffectiveDating;
    }

    public void setGroupByAttributesForEffectiveDating(List<String> groupByAttributesForEffectiveDating) {
        this.groupByAttributesForEffectiveDating = groupByAttributesForEffectiveDating;
    }

    public boolean isBoNotesEnabled() {
        return this.boNotesEnabled;
    }

    public void setBoNotesEnabled(boolean boNotesEnabled) {
        this.boNotesEnabled = boNotesEnabled;
    }

    public List<InactivationBlockingDefinition> getInactivationBlockingDefinitions() {
        return this.inactivationBlockingDefinitions;
    }

    public void setInactivationBlockingDefinitions(List<InactivationBlockingDefinition> inactivationBlockingDefinitions) {
        this.inactivationBlockingDefinitions = inactivationBlockingDefinitions;
    }
}

