/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.krad.rules.rule.event;

import java.util.ArrayList;
import java.util.List;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.krad.rules.rule.BusinessRule;
import org.kuali.kfs.krad.rules.rule.SaveDocumentRule;
import org.kuali.kfs.krad.rules.rule.event.KualiDocumentEvent;
import org.kuali.kfs.krad.rules.rule.event.KualiDocumentEventBase;
import org.kuali.kfs.krad.rules.rule.event.SaveEvent;
import org.kuali.kfs.krad.service.KRADServiceLocatorWeb;
import org.kuali.kfs.krad.service.KualiRuleService;

public class SaveDocumentEvent
extends KualiDocumentEventBase
implements SaveEvent {
    public SaveDocumentEvent(String errorPathPrefix, Document document) {
        this("creating save event for document " + SaveDocumentEvent.getDocumentId(document), errorPathPrefix, document);
    }

    public SaveDocumentEvent(Document document) {
        this("", document);
    }

    public SaveDocumentEvent(String description, String errorPathPrefix, Document document) {
        super(description, errorPathPrefix, document);
    }

    @Override
    public Class<? extends BusinessRule> getRuleInterfaceClass() {
        return SaveDocumentRule.class;
    }

    @Override
    public boolean invokeRuleMethod(BusinessRule rule) {
        return ((SaveDocumentRule)rule).processSaveDocument(this.document);
    }

    @Override
    public List<KualiDocumentEvent> generateEvents() {
        KualiRuleService ruleService = KRADServiceLocatorWeb.getKualiRuleService();
        ArrayList<KualiDocumentEvent> events = new ArrayList<KualiDocumentEvent>();
        events.addAll(ruleService.generateAdHocRoutePersonEvents(this.getDocument()));
        events.addAll(ruleService.generateAdHocRouteWorkgroupEvents(this.getDocument()));
        events.addAll(this.getDocument().generateSaveEvents());
        return events;
    }
}

