/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.krad.service;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.kuali.kfs.krad.datadictionary.AttributeDefinition;
import org.kuali.kfs.krad.datadictionary.AttributeSecurity;
import org.kuali.kfs.krad.datadictionary.BusinessObjectEntry;
import org.kuali.kfs.krad.datadictionary.CollectionDefinition;
import org.kuali.kfs.krad.datadictionary.DataDictionary;
import org.kuali.kfs.krad.datadictionary.DataDictionaryEntryBase;
import org.kuali.kfs.krad.datadictionary.DataObjectEntry;
import org.kuali.kfs.krad.datadictionary.DocumentEntry;
import org.kuali.kfs.krad.datadictionary.InactivationBlockingMetadata;
import org.kuali.kfs.krad.datadictionary.PrimitiveAttributeDefinition;
import org.kuali.kfs.krad.datadictionary.RelationshipDefinition;
import org.kuali.kfs.krad.datadictionary.control.ControlDefinition;
import org.kuali.kfs.krad.datadictionary.exception.UnknownBusinessClassAttributeException;
import org.kuali.kfs.krad.datadictionary.exception.UnknownDocumentTypeException;
import org.kuali.kfs.krad.datadictionary.validation.ValidationPattern;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.krad.service.KualiModuleService;
import org.kuali.rice.core.api.config.property.ConfigurationService;
import org.kuali.rice.core.api.util.ClassLoaderUtils;
import org.kuali.rice.core.web.format.Formatter;
import org.kuali.rice.kew.api.KewApiServiceLocator;
import org.kuali.rice.kew.api.doctype.DocumentType;
import org.kuali.rice.kew.api.doctype.DocumentTypeService;
import org.kuali.rice.krad.bo.BusinessObject;

public class DataDictionaryService {
    private DataDictionary dataDictionary;
    private ConfigurationService kualiConfigurationService;
    private KualiModuleService kualiModuleService;
    private volatile DocumentTypeService documentTypeService;

    public DataDictionaryService() {
        this.dataDictionary = new DataDictionary();
    }

    public DataDictionaryService(DataDictionary dataDictionary) {
        this.dataDictionary = dataDictionary;
    }

    public void setBaselinePackages(List baselinePackages) throws IOException {
        this.addDataDictionaryLocations(baselinePackages);
    }

    public DataDictionary getDataDictionary() {
        return this.dataDictionary;
    }

    public ControlDefinition getAttributeControlDefinition(String entryName, String attributeName) {
        ControlDefinition controlDefinition = null;
        AttributeDefinition attributeDefinition = this.getAttributeDefinition(entryName, attributeName);
        if (attributeDefinition != null) {
            controlDefinition = attributeDefinition.getControl();
        }
        return controlDefinition;
    }

    public ControlDefinition getAttributeControlDefinition(Class dataObjectClass, String attributeName) {
        return this.getAttributeControlDefinition(dataObjectClass.getName(), attributeName);
    }

    public Integer getAttributeSize(String entryName, String attributeName) {
        ControlDefinition controlDefinition;
        Integer size = null;
        AttributeDefinition attributeDefinition = this.getAttributeDefinition(entryName, attributeName);
        if (attributeDefinition != null && ((controlDefinition = attributeDefinition.getControl()).isText() || controlDefinition.isCurrency())) {
            size = controlDefinition.getSize();
        }
        return size;
    }

    public Integer getAttributeSize(Class dataObjectClass, String attributeName) {
        return this.getAttributeSize(dataObjectClass.getName(), attributeName);
    }

    public Integer getAttributeMinLength(String entryName, String attributeName) {
        Integer minLength = null;
        AttributeDefinition attributeDefinition = this.getAttributeDefinition(entryName, attributeName);
        if (attributeDefinition != null) {
            minLength = attributeDefinition.getMinLength();
        }
        return minLength;
    }

    public Integer getAttributeMaxLength(String entryName, String attributeName) {
        Integer maxLength = null;
        AttributeDefinition attributeDefinition = this.getAttributeDefinition(entryName, attributeName);
        if (attributeDefinition != null) {
            maxLength = attributeDefinition.getMaxLength();
        }
        return maxLength;
    }

    public Integer getAttributeMaxLength(Class dataObjectClass, String attributeName) {
        return this.getAttributeMaxLength(dataObjectClass.getName(), attributeName);
    }

    public String getAttributeExclusiveMin(String entryName, String attributeName) {
        AttributeDefinition attributeDefinition = this.getAttributeDefinition(entryName, attributeName);
        return attributeDefinition == null ? null : attributeDefinition.getExclusiveMin();
    }

    public String getAttributeInclusiveMax(String entryName, String attributeName) {
        AttributeDefinition attributeDefinition = this.getAttributeDefinition(entryName, attributeName);
        return attributeDefinition == null ? null : attributeDefinition.getInclusiveMax();
    }

    public Pattern getAttributeValidatingExpression(String entryName, String attributeName) {
        Pattern regex = null;
        AttributeDefinition attributeDefinition = this.getAttributeDefinition(entryName, attributeName);
        if (attributeDefinition != null) {
            regex = attributeDefinition.hasValidationPattern() ? attributeDefinition.getValidationPattern().getRegexPattern() : Pattern.compile(".*");
        }
        return regex;
    }

    public Pattern getAttributeValidatingExpression(Class dataObjectClass, String attributeName) {
        return this.getAttributeValidatingExpression(dataObjectClass.getName(), attributeName);
    }

    public String getAttributeLabel(String entryName, String attributeName) {
        String label = "";
        AttributeDefinition attributeDefinition = this.getAttributeDefinition(entryName, attributeName);
        if (attributeDefinition != null) {
            label = attributeDefinition.getLabel();
            if (!StringUtils.isEmpty((CharSequence)attributeDefinition.getDisplayLabelAttribute()) && (attributeDefinition = this.getAttributeDefinition(entryName, attributeDefinition.getDisplayLabelAttribute())) != null) {
                label = attributeDefinition.getLabel();
            }
        }
        return label;
    }

    public String getAttributeLabel(Class dataObjectClass, String attributeName) {
        return this.getAttributeLabel(dataObjectClass.getName(), attributeName);
    }

    public String getAttributeShortLabel(String entryName, String attributeName) {
        String shortLabel = "";
        AttributeDefinition attributeDefinition = this.getAttributeDefinition(entryName, attributeName);
        if (attributeDefinition != null) {
            if (!StringUtils.isEmpty((CharSequence)attributeDefinition.getDisplayLabelAttribute())) {
                if ((attributeDefinition = this.getAttributeDefinition(entryName, attributeDefinition.getDisplayLabelAttribute())) != null) {
                    shortLabel = attributeDefinition.getShortLabel();
                }
            } else {
                shortLabel = attributeDefinition.getShortLabel();
            }
        }
        return shortLabel;
    }

    public String getAttributeShortLabel(Class dataObjectClass, String attributeName) {
        return this.getAttributeShortLabel(dataObjectClass.getName(), attributeName);
    }

    public String getAttributeErrorLabel(String entryName, String attributeName) {
        String longAttributeLabel = this.getAttributeLabel(entryName, attributeName);
        String shortAttributeLabel = this.getAttributeShortLabel(entryName, attributeName);
        return longAttributeLabel + " (" + shortAttributeLabel + ")";
    }

    public String getAttributeErrorLabel(Class dataObjectClass, String attributeName) {
        return this.getAttributeErrorLabel(dataObjectClass.getName(), attributeName);
    }

    public Class<? extends Formatter> getAttributeFormatter(String entryName, String attributeName) {
        Class formatterClass = null;
        AttributeDefinition attributeDefinition = this.getAttributeDefinition(entryName, attributeName);
        if (attributeDefinition != null && attributeDefinition.hasFormatterClass()) {
            formatterClass = ClassLoaderUtils.getClass((String)attributeDefinition.getFormatterClass());
        }
        return formatterClass;
    }

    public Class<? extends Formatter> getAttributeFormatter(Class dataObjectClass, String attributeName) {
        return this.getAttributeFormatter(dataObjectClass.getName(), attributeName);
    }

    public Boolean getAttributeForceUppercase(String entryName, String attributeName) throws UnknownBusinessClassAttributeException {
        AttributeDefinition attributeDefinition = this.getAttributeDefinition(entryName, attributeName);
        if (attributeDefinition == null) {
            throw new UnknownBusinessClassAttributeException("Could not find a matching data dictionary business class attribute entry for " + entryName + "." + attributeName);
        }
        Boolean forceUppercase = attributeDefinition.getForceUppercase();
        return forceUppercase;
    }

    public Boolean getAttributeForceUppercase(Class dataObjectClass, String attributeName) {
        return this.getAttributeForceUppercase(dataObjectClass.getName(), attributeName);
    }

    public AttributeSecurity getAttributeSecurity(String entryName, String attributeName) {
        AttributeSecurity attributeSecurity = null;
        AttributeDefinition attributeDefinition = this.getAttributeDefinition(entryName, attributeName);
        if (attributeDefinition != null) {
            attributeSecurity = attributeDefinition.getAttributeSecurity();
        }
        return attributeSecurity;
    }

    public String getAttributeSummary(String entryName, String attributeName) {
        String summary = null;
        AttributeDefinition attributeDefinition = this.getAttributeDefinition(entryName, attributeName);
        if (attributeDefinition != null) {
            summary = attributeDefinition.getSummary();
        }
        return summary;
    }

    public String getAttributeSummary(Class dataObjectClass, String attributeName) {
        return this.getAttributeSummary(dataObjectClass.getName(), attributeName);
    }

    public String getAttributeDescription(String entryName, String attributeName) {
        String description = null;
        AttributeDefinition attributeDefinition = this.getAttributeDefinition(entryName, attributeName);
        if (attributeDefinition != null) {
            description = attributeDefinition.getDescription();
        }
        return description;
    }

    public String getAttributeDescription(Class dataObjectClass, String attributeName) {
        return this.getAttributeDescription(dataObjectClass.getName(), attributeName);
    }

    public Boolean isAttributeRequired(String entryName, String attributeName) {
        Boolean required = null;
        AttributeDefinition attributeDefinition = this.getAttributeDefinition(entryName, attributeName);
        if (attributeDefinition != null) {
            required = attributeDefinition.isRequired();
        }
        return required;
    }

    public Boolean isAttributeRequired(Class dataObjectClass, String attributeName) {
        return this.isAttributeRequired(dataObjectClass.getName(), attributeName);
    }

    public Boolean isAttributeDefined(String entryName, String attributeName) {
        boolean isDefined = false;
        AttributeDefinition attributeDefinition = this.getAttributeDefinition(entryName, attributeName);
        if (attributeDefinition != null) {
            isDefined = true;
        }
        return isDefined;
    }

    public Boolean isAttributeDefined(Class dataObjectClass, String attributeName) {
        return this.isAttributeDefined(dataObjectClass.getName(), attributeName);
    }

    public String getCollectionLabel(String entryName, String collectionName) {
        String label = "";
        CollectionDefinition collectionDefinition = this.getCollectionDefinition(entryName, collectionName);
        if (collectionDefinition != null) {
            label = collectionDefinition.getLabel();
        }
        return label;
    }

    public String getCollectionLabel(Class dataObjectClass, String collectionName) {
        return this.getCollectionLabel(dataObjectClass.getName(), collectionName);
    }

    public String getCollectionShortLabel(String entryName, String collectionName) {
        String shortLabel = "";
        CollectionDefinition collectionDefinition = this.getCollectionDefinition(entryName, collectionName);
        if (collectionDefinition != null) {
            shortLabel = collectionDefinition.getShortLabel();
        }
        return shortLabel;
    }

    public String getCollectionShortLabel(Class dataObjectClass, String collectionName) {
        return this.getCollectionShortLabel(dataObjectClass.getName(), collectionName);
    }

    public String getCollectionDescription(Class dataObjectClass, String collectionName) {
        return this.getCollectionDescription(dataObjectClass.getName(), collectionName);
    }

    public String getCollectionDescription(String entryName, String collectionName) {
        String description = null;
        CollectionDefinition collectionDefinition = this.getCollectionDefinition(entryName, collectionName);
        if (collectionDefinition != null) {
            description = collectionDefinition.getDescription();
        }
        return description;
    }

    public String getCollectionSummary(Class dataObjectClass, String collectionName) {
        return this.getCollectionSummary(dataObjectClass.getName(), collectionName);
    }

    public String getCollectionSummary(String entryName, String collectionName) {
        String summary = null;
        CollectionDefinition collectionDefinition = this.getCollectionDefinition(entryName, collectionName);
        if (collectionDefinition != null) {
            summary = collectionDefinition.getSummary();
        }
        return summary;
    }

    public String getCollectionElementLabel(String entryName, String collectionName, Class dataObjectClass) {
        BusinessObjectEntry boe;
        String elementLabel = "";
        CollectionDefinition collectionDefinition = this.getCollectionDefinition(entryName, collectionName);
        if (collectionDefinition != null && StringUtils.isEmpty((CharSequence)(elementLabel = collectionDefinition.getElementLabel())) && (boe = this.getDataDictionary().getBusinessObjectEntry(dataObjectClass.getName())) != null) {
            elementLabel = boe.getObjectLabel();
        }
        return elementLabel;
    }

    public Class<? extends BusinessObject> getRelationshipSourceClass(String entryName, String relationshipName) {
        Class<?> sourceClass = null;
        RelationshipDefinition rd = this.getRelationshipDefinition(entryName, relationshipName);
        if (rd != null) {
            sourceClass = rd.getSourceClass();
        }
        return sourceClass;
    }

    public Class<? extends BusinessObject> getRelationshipTargetClass(String entryName, String relationshipName) {
        Class<?> targetClass = null;
        RelationshipDefinition rd = this.getRelationshipDefinition(entryName, relationshipName);
        if (rd != null) {
            targetClass = rd.getTargetClass();
        }
        return targetClass;
    }

    public List<String> getRelationshipSourceAttributes(String entryName, String relationshipName) {
        ArrayList<String> sourceAttributes = null;
        RelationshipDefinition rd = this.getRelationshipDefinition(entryName, relationshipName);
        if (rd != null) {
            sourceAttributes = new ArrayList<String>();
            for (PrimitiveAttributeDefinition pad : rd.getPrimitiveAttributes()) {
                sourceAttributes.add(pad.getSourceName());
            }
        }
        return sourceAttributes;
    }

    public List<String> getRelationshipTargetAttributes(String entryName, String relationshipName) {
        ArrayList<String> targetAttributes = null;
        RelationshipDefinition rd = this.getRelationshipDefinition(entryName, relationshipName);
        if (rd != null) {
            targetAttributes = new ArrayList<String>();
            for (PrimitiveAttributeDefinition pad : rd.getPrimitiveAttributes()) {
                targetAttributes.add(pad.getTargetName());
            }
        }
        return targetAttributes;
    }

    public List<String> getRelationshipEntriesForSourceAttribute(String entryName, String sourceAttributeName) {
        ArrayList<String> relationships = new ArrayList<String>();
        DataDictionaryEntryBase entry = (DataDictionaryEntryBase)this.getDataDictionary().getDictionaryObjectEntry(entryName);
        block0: for (RelationshipDefinition def : entry.getRelationships()) {
            for (PrimitiveAttributeDefinition pddef : def.getPrimitiveAttributes()) {
                if (!StringUtils.equals((CharSequence)sourceAttributeName, (CharSequence)pddef.getSourceName())) continue;
                relationships.add(def.getObjectAttributeName());
                continue block0;
            }
        }
        return relationships;
    }

    public List<String> getRelationshipEntriesForTargetAttribute(String entryName, String targetAttributeName) {
        ArrayList<String> relationships = new ArrayList<String>();
        DataDictionaryEntryBase entry = (DataDictionaryEntryBase)this.getDataDictionary().getDictionaryObjectEntry(entryName);
        block0: for (RelationshipDefinition def : entry.getRelationships()) {
            for (PrimitiveAttributeDefinition pddef : def.getPrimitiveAttributes()) {
                if (!StringUtils.equals((CharSequence)targetAttributeName, (CharSequence)pddef.getTargetName())) continue;
                relationships.add(def.getObjectAttributeName());
                continue block0;
            }
        }
        return relationships;
    }

    public AttributeDefinition getAttributeDefinition(String entryName, String attributeName) {
        if (StringUtils.isBlank((CharSequence)attributeName)) {
            throw new IllegalArgumentException("invalid (blank) attributeName");
        }
        AttributeDefinition attributeDefinition = null;
        DataDictionaryEntryBase entry = (DataDictionaryEntryBase)this.getDataDictionary().getDictionaryObjectEntry(entryName);
        if (entry != null) {
            attributeDefinition = entry.getAttributeDefinition(attributeName);
        }
        return attributeDefinition;
    }

    private CollectionDefinition getCollectionDefinition(String entryName, String collectionName) {
        if (StringUtils.isBlank((CharSequence)collectionName)) {
            throw new IllegalArgumentException("invalid (blank) collectionName");
        }
        CollectionDefinition collectionDefinition = null;
        DataDictionaryEntryBase entry = (DataDictionaryEntryBase)this.getDataDictionary().getDictionaryObjectEntry(entryName);
        if (entry != null) {
            collectionDefinition = entry.getCollectionDefinition(collectionName);
        }
        return collectionDefinition;
    }

    private RelationshipDefinition getRelationshipDefinition(String entryName, String relationshipName) {
        if (StringUtils.isBlank((CharSequence)relationshipName)) {
            throw new IllegalArgumentException("invalid (blank) relationshipName");
        }
        RelationshipDefinition relationshipDefinition = null;
        DataDictionaryEntryBase entry = (DataDictionaryEntryBase)this.getDataDictionary().getDictionaryObjectEntry(entryName);
        if (entry != null) {
            relationshipDefinition = entry.getRelationshipDefinition(relationshipName);
        }
        return relationshipDefinition;
    }

    public Map<String, String> getRelationshipAttributeMap(String entryName, String relationshipName) {
        HashMap<String, String> attributeMap = new HashMap<String, String>();
        RelationshipDefinition relationshipDefinition = this.getRelationshipDefinition(entryName, relationshipName);
        for (PrimitiveAttributeDefinition attribute : relationshipDefinition.getPrimitiveAttributes()) {
            attributeMap.put(attribute.getTargetName(), attribute.getSourceName());
        }
        return attributeMap;
    }

    public boolean hasRelationship(String entryName, String relationshipName) {
        return this.getRelationshipDefinition(entryName, relationshipName) != null;
    }

    public List<String> getRelationshipNames(String entryName) {
        DataDictionaryEntryBase entry = (DataDictionaryEntryBase)this.getDataDictionary().getDictionaryObjectEntry(entryName);
        ArrayList<String> relationshipNames = new ArrayList<String>();
        for (RelationshipDefinition def : entry.getRelationships()) {
            relationshipNames.add(def.getObjectAttributeName());
        }
        return relationshipNames;
    }

    public String getAttributeValidatingErrorMessageKey(String entryName, String attributeName) {
        AttributeDefinition attributeDefinition = this.getAttributeDefinition(entryName, attributeName);
        if (attributeDefinition != null && attributeDefinition.hasValidationPattern()) {
            ValidationPattern validationPattern = attributeDefinition.getValidationPattern();
            return validationPattern.getValidationErrorMessageKey();
        }
        return null;
    }

    public String[] getAttributeValidatingErrorMessageParameters(String entryName, String attributeName) {
        AttributeDefinition attributeDefinition = this.getAttributeDefinition(entryName, attributeName);
        if (attributeDefinition != null && attributeDefinition.hasValidationPattern()) {
            ValidationPattern validationPattern = attributeDefinition.getValidationPattern();
            String attributeLabel = this.getAttributeErrorLabel(entryName, attributeName);
            return validationPattern.getValidationErrorMessageParameters(attributeLabel);
        }
        return null;
    }

    public String getDocumentLabelByClass(Class documentOrBusinessObjectClass) {
        return this.getDocumentLabelByTypeName(this.getDocumentTypeNameByClass(documentOrBusinessObjectClass));
    }

    public String getDocumentLabelByTypeName(String documentTypeName) {
        DocumentType documentType;
        String label = null;
        if (StringUtils.isNotBlank((CharSequence)documentTypeName) && (documentType = this.getDocumentTypeService().getDocumentTypeByName(documentTypeName)) != null) {
            label = documentType.getLabel();
        }
        return label;
    }

    public String getDocumentTypeNameByClass(Class documentClass) {
        if (documentClass == null) {
            throw new IllegalArgumentException("invalid (null) documentClass");
        }
        if (!Document.class.isAssignableFrom(documentClass)) {
            throw new IllegalArgumentException("invalid (non-Document) documentClass");
        }
        String documentTypeName = null;
        DocumentEntry documentEntry = this.getDataDictionary().getDocumentEntry(documentClass.getName());
        if (documentEntry != null) {
            documentTypeName = documentEntry.getDocumentTypeName();
        }
        return documentTypeName;
    }

    public String getValidDocumentTypeNameByClass(Class documentClass) {
        String documentTypeName = this.getDocumentTypeNameByClass(documentClass);
        if (StringUtils.isBlank((CharSequence)documentTypeName)) {
            throw new UnknownDocumentTypeException("unable to get documentTypeName for unknown documentClass '" + documentClass.getName() + "'");
        }
        return documentTypeName;
    }

    public Class<? extends Document> getDocumentClassByTypeName(String documentTypeName) {
        Class<? extends Document> clazz = null;
        DocumentEntry documentEntry = this.getDataDictionary().getDocumentEntry(documentTypeName);
        if (documentEntry != null) {
            clazz = documentEntry.getDocumentClass();
        }
        return clazz;
    }

    public Class<? extends Document> getValidDocumentClassByTypeName(String documentTypeName) {
        Class<? extends Document> clazz = this.getDocumentClassByTypeName(documentTypeName);
        if (clazz == null) {
            throw new UnknownDocumentTypeException("unable to get class for unknown documentTypeName '" + documentTypeName + "'");
        }
        return clazz;
    }

    public Object getDictionaryObject(String id) {
        return this.dataDictionary.getDictionaryObject(id);
    }

    public boolean containsDictionaryObject(String id) {
        return this.dataDictionary.containsDictionaryObject(id);
    }

    public void addDataDictionaryLocation(String location) throws IOException {
        this.dataDictionary.addConfigFileLocation(location);
    }

    public void addDataDictionaryLocations(List<String> locations) throws IOException {
        for (String location : locations) {
            this.addDataDictionaryLocation(location);
        }
    }

    public List<String> getGroupByAttributesForEffectiveDating(Class businessObjectClass) {
        List<String> groupByList = null;
        DataObjectEntry objectEntry = this.getDataDictionary().getDataObjectEntry(businessObjectClass.getName());
        if (objectEntry != null) {
            groupByList = objectEntry.getGroupByAttributesForEffectiveDating();
        }
        return groupByList;
    }

    public Set<InactivationBlockingMetadata> getAllInactivationBlockingDefinitions(Class inactivationBlockedBusinessObjectClass) {
        Set<InactivationBlockingMetadata> blockingClasses = this.dataDictionary.getAllInactivationBlockingMetadatas(inactivationBlockedBusinessObjectClass);
        if (blockingClasses == null) {
            return Collections.emptySet();
        }
        return blockingClasses;
    }

    public DocumentTypeService getDocumentTypeService() {
        if (this.documentTypeService == null) {
            this.documentTypeService = KewApiServiceLocator.getDocumentTypeService();
        }
        return this.documentTypeService;
    }

    public void setKualiConfigurationService(ConfigurationService kualiConfigurationService) {
        this.kualiConfigurationService = kualiConfigurationService;
    }

    public ConfigurationService getKualiConfigurationService() {
        return this.kualiConfigurationService;
    }

    public KualiModuleService getKualiModuleService() {
        return this.kualiModuleService;
    }

    public void setKualiModuleService(KualiModuleService kualiModuleService) {
        this.kualiModuleService = kualiModuleService;
    }
}

