/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.krad.service.impl;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.kuali.kfs.kns.service.KNSServiceLocator;
import org.kuali.kfs.krad.dao.LookupDao;
import org.kuali.kfs.krad.service.LookupService;
import org.kuali.rice.core.api.config.property.ConfigurationService;
import org.kuali.rice.core.api.search.SearchOperator;
import org.springframework.transaction.annotation.Transactional;

@Transactional
public class LookupServiceImpl
implements LookupService {
    private LookupDao lookupDao;
    private ConfigurationService kualiConfigurationService;

    @Override
    public <T> Collection<T> findCollectionBySearchUnbounded(Class<T> example, Map<String, String> formProps) {
        return this.findCollectionBySearchHelper(example, formProps, true);
    }

    @Override
    public <T> Collection<T> findCollectionBySearch(Class<T> example, Map<String, String> formProps) {
        return this.findCollectionBySearchHelper(example, formProps, false);
    }

    @Override
    public <T> Collection<T> findCollectionBySearchHelper(Class<T> example, Map<String, String> formProps, boolean unbounded) {
        return this.lookupDao.findCollectionBySearchHelper(example, formProps, unbounded, this.allPrimaryKeyValuesPresentAndNotWildcard(example, formProps));
    }

    @Override
    public <T> T findObjectBySearch(Class<T> example, Map<String, String> formProps) {
        T obj;
        if (example == null || formProps == null) {
            throw new IllegalArgumentException("Object and Map must not be null");
        }
        try {
            obj = example.newInstance();
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Cannot get new instance of " + example.getName(), e);
        }
        catch (InstantiationException e) {
            throw new RuntimeException("Cannot instantiate " + example.getName(), e);
        }
        return this.lookupDao.findObjectByMap(obj, formProps);
    }

    @Override
    public boolean allPrimaryKeyValuesPresentAndNotWildcard(Class<?> boClass, Map<String, String> formProps) {
        List<String> pkFields = KNSServiceLocator.getBusinessObjectMetaDataService().listPrimaryKeyFieldNames(boClass);
        Iterator<String> pkIter = pkFields.iterator();
        boolean returnVal = true;
        block0: while (returnVal && pkIter.hasNext()) {
            String pkName = pkIter.next();
            String pkValue = formProps.get(pkName);
            if (StringUtils.isBlank((CharSequence)pkValue)) {
                returnVal = false;
                continue;
            }
            for (SearchOperator op : SearchOperator.QUERY_CHARACTERS) {
                if (!pkValue.contains(op.op())) continue;
                returnVal = false;
                continue block0;
            }
        }
        return returnVal;
    }

    public LookupDao getLookupDao() {
        return this.lookupDao;
    }

    public void setLookupDao(LookupDao lookupDao) {
        this.lookupDao = lookupDao;
    }

    public ConfigurationService getKualiConfigurationService() {
        return this.kualiConfigurationService;
    }

    public void setKualiConfigurationService(ConfigurationService kualiConfigurationService) {
        this.kualiConfigurationService = kualiConfigurationService;
    }
}

