/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.krad.util;

import java.io.Serializable;
import java.util.Arrays;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

public class ErrorMessage
implements Serializable {
    private String errorKey;
    private String[] messageParameters;

    public ErrorMessage() {
    }

    public ErrorMessage(String errorKey, String ... messageParameters) {
        if (StringUtils.isBlank((CharSequence)errorKey)) {
            throw new IllegalArgumentException("invalid (blank) errorKey");
        }
        this.setErrorKey(errorKey);
        this.setMessageParameters((String[])ArrayUtils.clone((Object[])messageParameters));
    }

    public void setErrorKey(String errorKey) {
        if (StringUtils.isBlank((CharSequence)errorKey)) {
            throw new IllegalArgumentException("invalid (blank) errorKey");
        }
        this.errorKey = errorKey;
    }

    public String getErrorKey() {
        return this.errorKey;
    }

    public void setMessageParameters(String[] messageParameters) {
        this.messageParameters = messageParameters;
    }

    public String[] getMessageParameters() {
        return this.messageParameters;
    }

    public String toString() {
        StringBuffer s = new StringBuffer(this.getErrorKey());
        String[] params = this.getMessageParameters();
        if (params != null) {
            s.append("(");
            for (int i = 0; i < params.length; ++i) {
                if (i > 0) {
                    s.append(", ");
                }
                s.append(params[i]);
            }
            s.append(")");
        }
        return s.toString();
    }

    public boolean equals(Object obj) {
        boolean equals = false;
        if (this == obj) {
            equals = true;
        } else if (obj instanceof ErrorMessage) {
            ErrorMessage other = (ErrorMessage)obj;
            if (StringUtils.equals((CharSequence)this.getErrorKey(), (CharSequence)other.getErrorKey())) {
                equals = Arrays.equals(this.getMessageParameters(), other.getMessageParameters());
            }
        }
        return equals;
    }

    public int hashCode() {
        int hashCode = 5011966;
        if (this.getErrorKey() != null) {
            hashCode = this.getErrorKey().hashCode();
        }
        return hashCode;
    }
}

