/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.krad.util;

import java.io.IOException;
import java.net.URL;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.kuali.rice.core.api.util.ClassLoaderUtils;
import org.springframework.context.ApplicationContext;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.Resource;
import org.springframework.util.ResourceUtils;

public final class ResourceLoaderUtil {
    protected static Pattern resourceJarUrlPattern = Pattern.compile("^.*?\\.jar!(.+)$");

    private ResourceLoaderUtil() {
    }

    public static Resource getFileResource(String sourceName, ApplicationContext applicationContext) {
        return applicationContext.getResource(sourceName);
    }

    public static Resource getFileResource(String sourceName) {
        DefaultResourceLoader resourceLoader = new DefaultResourceLoader(ClassLoaderUtils.getDefaultClassLoader());
        return resourceLoader.getResource(sourceName);
    }

    public static String parseResourcePathFromUrl(Resource resource) throws IOException {
        URL resourceUrl = resource.getURL();
        if (ResourceUtils.isJarURL((URL)resourceUrl)) {
            Matcher resourceUrlPathMatcher = resourceJarUrlPattern.matcher(resourceUrl.getPath());
            if (resourceUrlPathMatcher.matches() && !StringUtils.isBlank((CharSequence)resourceUrlPathMatcher.group(1))) {
                return "classpath:" + resourceUrlPathMatcher.group(1);
            }
        } else if ("file".equals(resourceUrl.getProtocol()) && resource.exists()) {
            return "file:" + resourceUrl.getFile();
        }
        return null;
    }
}

