/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.krad.util;

import java.util.Properties;
import org.apache.commons.codec.EncoderException;
import org.apache.commons.codec.net.URLCodec;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class UrlFactory {
    private static Logger LOG = LogManager.getLogger(UrlFactory.class);
    private static URLCodec urlCodec = new URLCodec("UTF-8");

    private UrlFactory() {
    }

    public static String parameterizeUrl(String baseUrl, Properties params) {
        if (StringUtils.isEmpty((CharSequence)(baseUrl = StringUtils.trim((String)baseUrl)))) {
            throw new IllegalArgumentException("invalid (blank) base URL");
        }
        if (params == null) {
            throw new IllegalArgumentException("invalid (null) Properties");
        }
        StringBuffer ret = new StringBuffer(baseUrl);
        String delimiter = ret.indexOf("?") == -1 ? "?" : "&";
        for (Object key : params.keySet()) {
            String paramName = StringUtils.trim((String)((String)key));
            String paramValue = params.getProperty(paramName);
            ret.append(delimiter);
            if (StringUtils.isEmpty((CharSequence)paramName)) {
                throw new IllegalArgumentException("invalid (blank) paramName");
            }
            if (paramValue == null) {
                ret.append(paramName);
                ret.append("=");
            } else {
                try {
                    ret.append(paramName);
                    ret.append("=");
                    ret.append(urlCodec.encode(paramValue));
                }
                catch (EncoderException ex) {
                    LOG.error("Unable to encode parameter name or value: " + paramName + "=" + paramValue, (Throwable)ex);
                    throw new RuntimeException("Unable to encode parameter name or value: " + paramName + "=" + paramValue, ex);
                }
            }
            delimiter = "&";
        }
        return ret.toString();
    }

    public static String encode(String value) {
        try {
            return urlCodec.encode(value);
        }
        catch (EncoderException ex) {
            throw new RuntimeException("Unable to encode value: " + value, ex);
        }
    }
}

