/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.kns.datadictionary;

import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.kuali.kfs.kns.datadictionary.ActionType;
import org.kuali.kfs.kns.datadictionary.ActionsProvider;
import org.kuali.kfs.kns.datadictionary.BusinessObjectAdminService;
import org.kuali.kfs.kns.datadictionary.InquiryDefinition;
import org.kuali.kfs.kns.datadictionary.LookupDefinition;
import org.kuali.kfs.krad.bo.Exporter;
import org.kuali.kfs.krad.datadictionary.DataDictionary;
import org.kuali.kfs.krad.datadictionary.DataDictionaryEntry;
import org.kuali.kfs.krad.datadictionary.DataDictionaryException;
import org.kuali.kfs.krad.datadictionary.HelpDefinition;
import org.kuali.kfs.krad.datadictionary.InactivationBlockingDefinition;
import org.kuali.kfs.krad.datadictionary.RelationshipDefinition;
import org.kuali.kfs.krad.datadictionary.exception.AttributeValidationException;
import org.kuali.kfs.krad.datadictionary.validation.capability.MustOccurConstrainable;
import org.kuali.kfs.krad.datadictionary.validation.constraint.MustOccurConstraint;
import org.kuali.rice.krad.bo.BusinessObject;

public class BusinessObjectEntry
extends DataDictionaryEntry
implements MustOccurConstrainable {
    protected InquiryDefinition inquiryDefinition;
    protected LookupDefinition lookupDefinition;
    protected BusinessObjectAdminService businessObjectAdminService;
    private List<ActionType> actions;
    private ActionsProvider actionsProvider;
    protected Class<? extends BusinessObject> baseBusinessObjectClass;
    protected boolean boNotesEnabled = false;
    protected Class<? extends BusinessObject> businessObjectClass;
    protected Class<? extends Exporter> exporterClass;
    protected List<String> groupByAttributesForEffectiveDating;
    protected HelpDefinition helpDefinition;
    protected List<InactivationBlockingDefinition> inactivationBlockingDefinitions;
    protected String name;
    protected String objectDescription;
    protected String objectLabel;
    protected List<String> primaryKeys;
    protected List<MustOccurConstraint> mustOccurConstraints;
    protected String titleAttribute;

    @Override
    public void completeValidation() {
        try {
            if (StringUtils.isBlank((CharSequence)this.getObjectLabel())) {
                throw new AttributeValidationException("Object label cannot be blank for class " + this.businessObjectClass.getName());
            }
            super.completeValidation();
            if (this.inactivationBlockingDefinitions != null && !this.inactivationBlockingDefinitions.isEmpty()) {
                for (InactivationBlockingDefinition inactivationBlockingDefinition : this.inactivationBlockingDefinitions) {
                    inactivationBlockingDefinition.completeValidation((Class)this.businessObjectClass, (Class)null);
                }
            }
        }
        catch (DataDictionaryException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new DataDictionaryException("Exception validating " + this, ex);
        }
        if (this.hasInquiryDefinition()) {
            this.inquiryDefinition.completeValidation((Class)this.businessObjectClass, (Class)null);
        }
        if (this.hasLookupDefinition()) {
            this.lookupDefinition.completeValidation((Class)this.businessObjectClass, (Class)null);
        }
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        super.afterPropertiesSet();
        if (this.inactivationBlockingDefinitions != null) {
            for (InactivationBlockingDefinition ibd : this.inactivationBlockingDefinitions) {
                ibd.setBusinessObjectClass(this.getBusinessObjectClass());
                if (StringUtils.isNotBlank((CharSequence)ibd.getBlockedReferencePropertyName()) && ibd.getBlockedBusinessObjectClass() == null) {
                    ibd.setBlockedBusinessObjectClass(DataDictionary.getAttributeClass(this.businessObjectClass, ibd.getBlockedReferencePropertyName()));
                }
                ibd.setBlockingReferenceBusinessObjectClass(this.getBusinessObjectClass());
            }
        }
    }

    public void setBusinessObjectClass(Class<? extends BusinessObject> businessObjectClass) {
        if (businessObjectClass == null) {
            throw new IllegalArgumentException("invalid (null) businessObjectClass");
        }
        this.businessObjectClass = businessObjectClass;
        if (this.getRelationships() != null) {
            for (RelationshipDefinition rd : this.getRelationships()) {
                rd.setSourceClass(businessObjectClass);
            }
        }
    }

    public Class<? extends BusinessObject> getBusinessObjectClass() {
        return this.businessObjectClass;
    }

    public void setBaseBusinessObjectClass(Class<? extends BusinessObject> baseBusinessObjectClass) {
        this.baseBusinessObjectClass = baseBusinessObjectClass;
    }

    public Class<? extends BusinessObject> getBaseBusinessObjectClass() {
        return this.baseBusinessObjectClass;
    }

    public boolean hasInquiryDefinition() {
        return this.inquiryDefinition != null;
    }

    public InquiryDefinition getInquiryDefinition() {
        return this.inquiryDefinition;
    }

    public void setInquiryDefinition(InquiryDefinition inquiryDefinition) {
        this.inquiryDefinition = inquiryDefinition;
    }

    public boolean hasLookupDefinition() {
        return this.lookupDefinition != null;
    }

    public LookupDefinition getLookupDefinition() {
        return this.lookupDefinition;
    }

    public void setLookupDefinition(LookupDefinition lookupDefinition) {
        this.lookupDefinition = lookupDefinition;
    }

    public void setActions(List<ActionType> actions) {
        this.actions = actions;
    }

    public boolean supportsAction(ActionType actionType) {
        return this.actions != null && this.actions.contains((Object)actionType);
    }

    public ActionsProvider getActionsProvider() {
        return this.actionsProvider;
    }

    public void setActionsProvider(ActionsProvider actionsProvider) {
        this.actionsProvider = actionsProvider;
    }

    @Override
    public String getJstlKey() {
        if (this.businessObjectClass == null) {
            throw new IllegalStateException("cannot generate JSTL key: businessObjectClass is null");
        }
        return this.businessObjectClass.getSimpleName();
    }

    @Override
    public String getFullClassName() {
        return this.businessObjectClass.getName();
    }

    @Override
    public Class<?> getEntryClass() {
        return this.businessObjectClass;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getObjectLabel() {
        return this.objectLabel;
    }

    public void setObjectLabel(String objectLabel) {
        this.objectLabel = objectLabel;
    }

    public String getObjectDescription() {
        return this.objectDescription;
    }

    public void setObjectDescription(String objectDescription) {
        this.objectDescription = objectDescription;
    }

    public HelpDefinition getHelpDefinition() {
        return this.helpDefinition;
    }

    public void setHelpDefinition(HelpDefinition helpDefinition) {
        this.helpDefinition = helpDefinition;
    }

    @Override
    public List<MustOccurConstraint> getMustOccurConstraints() {
        return this.mustOccurConstraints;
    }

    public void setMustOccurConstraints(List<MustOccurConstraint> mustOccurConstraints) {
        this.mustOccurConstraints = mustOccurConstraints;
    }

    public String getTitleAttribute() {
        return this.titleAttribute;
    }

    public void setTitleAttribute(String titleAttribute) {
        this.titleAttribute = titleAttribute;
    }

    public List<String> getPrimaryKeys() {
        return this.primaryKeys;
    }

    public void setPrimaryKeys(List<String> primaryKeys) {
        this.primaryKeys = primaryKeys;
    }

    public Class<? extends Exporter> getExporterClass() {
        return this.exporterClass;
    }

    public void setExporterClass(Class<? extends Exporter> exporterClass) {
        this.exporterClass = exporterClass;
    }

    public List<String> getGroupByAttributesForEffectiveDating() {
        return this.groupByAttributesForEffectiveDating;
    }

    public void setGroupByAttributesForEffectiveDating(List<String> groupByAttributesForEffectiveDating) {
        this.groupByAttributesForEffectiveDating = groupByAttributesForEffectiveDating;
    }

    public boolean isBoNotesEnabled() {
        return this.boNotesEnabled;
    }

    public void setBoNotesEnabled(boolean boNotesEnabled) {
        this.boNotesEnabled = boNotesEnabled;
    }

    public List<InactivationBlockingDefinition> getInactivationBlockingDefinitions() {
        return this.inactivationBlockingDefinitions;
    }

    public void setInactivationBlockingDefinitions(List<InactivationBlockingDefinition> inactivationBlockingDefinitions) {
        this.inactivationBlockingDefinitions = inactivationBlockingDefinitions;
    }

    public BusinessObjectAdminService getBusinessObjectAdminService() {
        return this.businessObjectAdminService;
    }

    public void setBusinessObjectAdminService(BusinessObjectAdminService businessObjectAdminService) {
        this.businessObjectAdminService = businessObjectAdminService;
    }

    public String toString() {
        return "BusinessObjectEntry for " + this.getBusinessObjectClass();
    }
}

