/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.kns.datadictionary;

import org.apache.commons.lang3.StringUtils;
import org.kuali.kfs.kns.datadictionary.FieldDefinitionI;
import org.kuali.kfs.kns.service.BusinessObjectMetaDataService;
import org.kuali.kfs.kns.service.KNSServiceLocator;
import org.kuali.kfs.krad.datadictionary.DataDictionary;
import org.kuali.kfs.krad.datadictionary.DataDictionaryDefinition;
import org.kuali.kfs.krad.datadictionary.RelationshipDefinition;
import org.kuali.kfs.krad.datadictionary.exception.AttributeValidationException;
import org.kuali.kfs.krad.datadictionary.exception.ClassValidationException;
import org.kuali.kfs.krad.datadictionary.mask.Mask;
import org.kuali.kfs.krad.valuefinder.DefaultValueFinder;

@Deprecated
public class FieldDefinition
extends DataDictionaryDefinition
implements FieldDefinitionI {
    private static final long serialVersionUID = -3426603523049661524L;
    protected String attributeName;
    protected boolean required = false;
    protected boolean forceInquiry = false;
    protected boolean noInquiry = false;
    protected boolean noDirectInquiry = false;
    protected boolean forceLookup = false;
    protected boolean noLookup = false;
    protected boolean useShortLabel = false;
    protected String defaultValue;
    protected DefaultValueFinder defaultValueFinder;
    protected String quickfinderParameterString;
    protected Class<? extends DefaultValueFinder> quickfinderParameterStringBuilderClass;
    protected Integer maxLength = null;
    protected String displayEditMode;
    protected Mask displayMask;
    protected boolean hidden = false;
    protected boolean readOnly = false;
    protected boolean treatWildcardsAndOperatorsAsLiteral = false;
    protected String alternateDisplayAttributeName;
    protected String additionalDisplayAttributeName;
    protected boolean triggerOnChange;
    protected boolean total = false;

    public String getAttributeName() {
        return this.attributeName;
    }

    public void setAttributeName(String attributeName) {
        if (StringUtils.isBlank((CharSequence)attributeName)) {
            throw new IllegalArgumentException("invalid (blank) attributeName");
        }
        this.attributeName = attributeName;
    }

    public boolean isRequired() {
        return this.required;
    }

    public void setRequired(boolean required) {
        this.required = required;
    }

    public boolean isForceInquiry() {
        return this.forceInquiry;
    }

    public void setForceInquiry(boolean forceInquiry) {
        this.forceInquiry = forceInquiry;
    }

    public boolean isForceLookup() {
        return this.forceLookup;
    }

    public void setForceLookup(boolean forceLookup) {
        this.forceLookup = forceLookup;
    }

    public boolean isNoInquiry() {
        return this.noInquiry;
    }

    public boolean isNoDirectInquiry() {
        return this.noDirectInquiry;
    }

    public void setNoInquiry(boolean noInquiry) {
        this.noInquiry = noInquiry;
    }

    public void setNoDirectInquiry(boolean noDirectInquiry) {
        this.noDirectInquiry = noDirectInquiry;
    }

    public boolean isNoLookup() {
        return this.noLookup;
    }

    public void setNoLookup(boolean noLookup) {
        this.noLookup = noLookup;
    }

    public boolean isUseShortLabel() {
        return this.useShortLabel;
    }

    public void setUseShortLabel(boolean useShortLabel) {
        this.useShortLabel = useShortLabel;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    public String getQuickfinderParameterString() {
        return this.quickfinderParameterString;
    }

    public void setQuickfinderParameterString(String quickfinderParameterString) {
        this.quickfinderParameterString = quickfinderParameterString;
    }

    public Class<? extends DefaultValueFinder> getQuickfinderParameterStringBuilderClass() {
        return this.quickfinderParameterStringBuilderClass;
    }

    public void setQuickfinderParameterStringBuilderClass(Class<? extends DefaultValueFinder> quickfinderParameterStringBuilderClass) {
        if (quickfinderParameterStringBuilderClass == null) {
            throw new IllegalArgumentException("invalid (null) quickfinderParameterStringBuilderClass");
        }
        this.quickfinderParameterStringBuilderClass = quickfinderParameterStringBuilderClass;
    }

    public void completeValidation(Class rootBusinessObjectClass, Class otherBusinessObjectClass) {
        BusinessObjectMetaDataService boMetadataService = KNSServiceLocator.getBusinessObjectMetaDataService();
        if (!DataDictionary.isPropertyOf(rootBusinessObjectClass, this.getAttributeName())) {
            throw new AttributeValidationException("unable to find attribute '" + this.attributeName + "' in rootBusinessObjectClass '" + rootBusinessObjectClass.getName() + "' ()");
        }
        if (StringUtils.isNotBlank((CharSequence)this.getAlternateDisplayAttributeName()) && !DataDictionary.isPropertyOf(rootBusinessObjectClass, this.getAlternateDisplayAttributeName())) {
            throw new AttributeValidationException("unable to find attribute named '" + this.getName() + "' in rootBusinessObjectClass '" + rootBusinessObjectClass.getName() + "' ()");
        }
        if (StringUtils.isNotBlank((CharSequence)this.getAdditionalDisplayAttributeName()) && !DataDictionary.isPropertyOf(rootBusinessObjectClass, this.getAdditionalDisplayAttributeName())) {
            throw new AttributeValidationException("unable to find attribute named '" + this.getName() + "' in rootBusinessObjectClass '" + rootBusinessObjectClass.getName() + "' ()");
        }
        if (this.defaultValueFinder != null && this.defaultValue != null) {
            throw new AttributeValidationException("Both defaultValue and defaultValueFinderClass can not be specified on attribute " + this.getAttributeName() + " in rootBusinessObjectClass " + rootBusinessObjectClass.getName());
        }
        this.validateQuickfinderParameters(rootBusinessObjectClass, boMetadataService);
        if (this.forceInquiry && this.noInquiry) {
            throw new AttributeValidationException("Both forceInquiry and noInquiry can not be set to true on attribute " + this.getAttributeName() + " in rootBusinessObjectClass " + rootBusinessObjectClass.getName());
        }
        if (this.forceLookup && this.noLookup) {
            throw new AttributeValidationException("Both forceLookup and noLookup can not be set to true on attribute " + this.getAttributeName() + " in rootBusinessObjectClass " + rootBusinessObjectClass.getName());
        }
    }

    private void validateQuickfinderParameters(Class rootBusinessObjectClass, BusinessObjectMetaDataService boMetadataService) {
        if (this.quickfinderParameterStringBuilderClass != null && this.quickfinderParameterString != null) {
            throw new AttributeValidationException("Both quickfinderParameterString and quickfinderParameterStringBuilderClass can not be specified on attribute " + this.getAttributeName() + " in rootBusinessObjectClass " + rootBusinessObjectClass.getName());
        }
        String quickfinderParameterStringSource = "quickfinderParameterString";
        if (this.quickfinderParameterStringBuilderClass != null) {
            try {
                quickfinderParameterStringSource = "quickfinderParameterStringBuilderClass " + this.quickfinderParameterStringBuilderClass.getCanonicalName();
                this.quickfinderParameterString = this.quickfinderParameterStringBuilderClass.newInstance().getDefaultValue();
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new ClassValidationException("unable to create new instance of " + quickfinderParameterStringSource + " while validating rootBusinessObjectClass '" + rootBusinessObjectClass.getName() + "'", e);
            }
        }
        if (!StringUtils.isEmpty((CharSequence)this.quickfinderParameterString)) {
            for (String quickfinderParam : this.quickfinderParameterString.split(",")) {
                if (quickfinderParam.contains("=")) {
                    String propertyName = quickfinderParam.split("=")[0];
                    RelationshipDefinition relationship = boMetadataService.getBusinessObjectRelationshipDefinition(rootBusinessObjectClass, this.attributeName);
                    Class<?> targetClass = relationship.getTargetClass();
                    if (DataDictionary.isPropertyOf(targetClass, propertyName)) continue;
                    throw new ClassValidationException("malformed parameter string  '" + this.quickfinderParameterString + "' from " + quickfinderParameterStringSource + ", '" + propertyName + "' is not a property of " + targetClass + "' for rootBusinessObjectClass '" + rootBusinessObjectClass.getName() + "'");
                }
                throw new ClassValidationException("malformed parameter string '" + this.quickfinderParameterString + "' from " + quickfinderParameterStringSource + " for rootBusinessObjectClass '" + rootBusinessObjectClass.getName() + "'");
            }
        }
    }

    public String toString() {
        return "FieldDefinition for attribute " + this.getAttributeName();
    }

    @Override
    public String getName() {
        return this.attributeName;
    }

    public String getDisplayEditMode() {
        return this.displayEditMode;
    }

    public void setDisplayEditMode(String displayEditMode) {
        this.displayEditMode = displayEditMode;
    }

    public Mask getDisplayMask() {
        return this.displayMask;
    }

    public void setDisplayMask(Mask displayMask) {
        this.displayMask = displayMask;
    }

    @Override
    public boolean isReadOnlyAfterAdd() {
        return false;
    }

    public Integer getMaxLength() {
        return this.maxLength;
    }

    public void setMaxLength(Integer maxLength) {
        this.maxLength = maxLength;
    }

    public DefaultValueFinder getDefaultValueFinder() {
        return this.defaultValueFinder;
    }

    public void setDefaultValueFinder(DefaultValueFinder defaultValueFinder) {
        if (defaultValueFinder == null) {
            throw new IllegalArgumentException("invalid (null) defaultValueFinder");
        }
        this.defaultValueFinder = defaultValueFinder;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public void setHidden(boolean hidden) {
        this.hidden = hidden;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    public boolean isTriggerOnChange() {
        return this.triggerOnChange;
    }

    public void setTriggerOnChange(boolean triggerOnChange) {
        this.triggerOnChange = triggerOnChange;
    }

    public boolean isTreatWildcardsAndOperatorsAsLiteral() {
        return this.treatWildcardsAndOperatorsAsLiteral;
    }

    public void setTreatWildcardsAndOperatorsAsLiteral(boolean treatWildcardsAndOperatorsAsLiteralOnLookups) {
        this.treatWildcardsAndOperatorsAsLiteral = treatWildcardsAndOperatorsAsLiteralOnLookups;
    }

    @Override
    public String getAlternateDisplayAttributeName() {
        return this.alternateDisplayAttributeName;
    }

    public void setAlternateDisplayAttributeName(String alternateDisplayAttributeName) {
        this.alternateDisplayAttributeName = alternateDisplayAttributeName;
    }

    @Override
    public String getAdditionalDisplayAttributeName() {
        return this.additionalDisplayAttributeName;
    }

    public void setAdditionalDisplayAttributeName(String additionalDisplayAttributeName) {
        this.additionalDisplayAttributeName = additionalDisplayAttributeName;
    }

    public boolean isTotal() {
        return this.total;
    }

    public void setTotal(boolean total) {
        this.total = total;
    }
}

