/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.kns.datadictionary;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.kuali.kfs.kns.datadictionary.DocumentEntry;
import org.kuali.kfs.kns.datadictionary.HeaderNavigation;
import org.kuali.kfs.kns.datadictionary.MaintainableSectionDefinition;
import org.kuali.kfs.kns.document.MaintenanceDocumentBase;
import org.kuali.kfs.kns.document.authorization.DocumentAuthorizer;
import org.kuali.kfs.kns.document.authorization.MaintenanceDocumentAuthorizerBase;
import org.kuali.kfs.kns.document.authorization.MaintenanceDocumentPresentationControllerBase;
import org.kuali.kfs.kns.maintenance.Maintainable;
import org.kuali.kfs.kns.rule.PromptBeforeValidation;
import org.kuali.kfs.kns.rules.MaintenanceDocumentRule;
import org.kuali.kfs.kns.web.derivedvaluesetter.DerivedValuesSetter;
import org.kuali.kfs.krad.datadictionary.DataDictionary;
import org.kuali.kfs.krad.datadictionary.DataDictionaryException;
import org.kuali.kfs.krad.datadictionary.ReferenceDefinition;
import org.kuali.kfs.krad.datadictionary.exception.AttributeValidationException;
import org.kuali.kfs.krad.datadictionary.exception.ClassValidationException;
import org.kuali.kfs.krad.datadictionary.exception.DuplicateEntryException;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.krad.document.DocumentPresentationController;
import org.kuali.kfs.krad.maintenance.MaintenanceDocumentAuthorizer;
import org.kuali.kfs.krad.rules.MaintenanceDocumentRuleBase;
import org.kuali.rice.krad.bo.BusinessObject;

public class MaintenanceDocumentEntry
extends DocumentEntry {
    protected List<MaintainableSectionDefinition> maintainableSections = new ArrayList<MaintainableSectionDefinition>();
    protected List<String> lockingKeys = new ArrayList<String>();
    protected Map<String, MaintainableSectionDefinition> maintainableSectionMap = new LinkedHashMap<String, MaintainableSectionDefinition>();
    protected boolean allowsNewOrCopy = true;
    protected String additionalSectionsFile;
    protected boolean preserveLockingKeysOnCopy = false;
    protected boolean allowsRecordDeletion = false;
    protected boolean translateCodes = false;
    protected Class<? extends PromptBeforeValidation> promptBeforeValidationClass;
    protected Class<? extends DerivedValuesSetter> derivedValuesSetterClass;
    protected List<String> webScriptFiles = new ArrayList<String>(3);
    protected List<HeaderNavigation> headerNavigationList = new ArrayList<HeaderNavigation>();
    protected boolean sessionDocument = false;
    protected Class<?> dataObjectClass;
    protected Class<? extends Maintainable> maintainableClass;

    public MaintenanceDocumentEntry() {
        this.setDocumentClass(this.getStandardDocumentBaseClass());
        this.documentAuthorizerClass = MaintenanceDocumentAuthorizerBase.class;
        this.documentPresentationControllerClass = MaintenanceDocumentPresentationControllerBase.class;
    }

    @Override
    public Class<? extends PromptBeforeValidation> getPromptBeforeValidationClass() {
        return this.promptBeforeValidationClass;
    }

    @Override
    public void setPromptBeforeValidationClass(Class<? extends PromptBeforeValidation> preRulesCheckClass) {
        this.promptBeforeValidationClass = preRulesCheckClass;
    }

    public Class<? extends Document> getStandardDocumentBaseClass() {
        return MaintenanceDocumentBase.class;
    }

    public void setBusinessObjectClass(Class<? extends BusinessObject> businessObjectClass) {
        if (businessObjectClass == null) {
            throw new IllegalArgumentException("invalid (null) businessObjectClass");
        }
        this.setDataObjectClass(businessObjectClass);
    }

    public Class<? extends BusinessObject> getBusinessObjectClass() {
        return this.getDataObjectClass();
    }

    @Override
    public Class getEntryClass() {
        return this.dataObjectClass;
    }

    public Class<? extends Maintainable> getMaintainableClass() {
        return this.maintainableClass;
    }

    public List<MaintainableSectionDefinition> getMaintainableSections() {
        return this.maintainableSections;
    }

    public List<String> getLockingKeyFieldNames() {
        return this.lockingKeys;
    }

    public boolean getAllowsNewOrCopy() {
        return this.allowsNewOrCopy;
    }

    public void setAllowsNewOrCopy(boolean allowsNewOrCopy) {
        this.allowsNewOrCopy = allowsNewOrCopy;
    }

    @Override
    public void completeValidation() {
        if (!MaintenanceDocumentRule.class.isAssignableFrom(this.getBusinessRulesClass())) {
            throw new DataDictionaryException("ERROR: Business rules class for KNS Maintenance document entry " + this.getBusinessRulesClass().getName() + " does not implement the expected " + MaintenanceDocumentRule.class.getName() + " interface.");
        }
        super.completeValidation();
        for (String lockingKey : this.lockingKeys) {
            if (DataDictionary.isPropertyOf(this.dataObjectClass, lockingKey)) continue;
            throw new AttributeValidationException("unable to find attribute '" + lockingKey + "' for lockingKey in dataObjectClass '" + this.dataObjectClass.getName());
        }
        for (ReferenceDefinition reference : this.defaultExistenceChecks) {
            reference.completeValidation((Class)this.dataObjectClass, (Class)null);
        }
        if (this.documentAuthorizerClass != null && !MaintenanceDocumentAuthorizer.class.isAssignableFrom(this.documentAuthorizerClass)) {
            throw new ClassValidationException("This maintenance document for '" + this.getDataObjectClass().getName() + "' has an invalid documentAuthorizerClass ('" + this.documentAuthorizerClass.getName() + "').  Maintenance Documents must use an implementation of MaintenanceDocumentAuthorizer.");
        }
        for (MaintainableSectionDefinition maintainableSectionDefinition : this.maintainableSections) {
            maintainableSectionDefinition.completeValidation((Class)this.getDataObjectClass(), (Class)null);
        }
    }

    @Override
    public String toString() {
        return "MaintenanceDocumentEntry for documentType " + this.getDocumentTypeName();
    }

    @Deprecated
    public String getAdditionalSectionsFile() {
        return this.additionalSectionsFile;
    }

    @Deprecated
    public void setAdditionalSectionsFile(String additionalSectionsFile) {
        this.additionalSectionsFile = additionalSectionsFile;
    }

    public List<String> getLockingKeys() {
        return this.lockingKeys;
    }

    public void setLockingKeys(List<String> lockingKeys) {
        for (String lockingKey : lockingKeys) {
            if (lockingKey != null) continue;
            throw new IllegalArgumentException("invalid (null) lockingKey");
        }
        this.lockingKeys = lockingKeys;
    }

    @Deprecated
    public void setMaintainableSections(List<MaintainableSectionDefinition> maintainableSections) {
        this.maintainableSectionMap.clear();
        for (MaintainableSectionDefinition maintainableSectionDefinition : maintainableSections) {
            if (maintainableSectionDefinition == null) {
                throw new IllegalArgumentException("invalid (null) maintainableSectionDefinition");
            }
            String sectionTitle = maintainableSectionDefinition.getTitle();
            if (this.maintainableSectionMap.containsKey(sectionTitle)) {
                throw new DuplicateEntryException("section '" + sectionTitle + "' already defined for maintenanceDocument '" + this.getDocumentTypeName() + "'");
            }
            this.maintainableSectionMap.put(sectionTitle, maintainableSectionDefinition);
        }
        this.maintainableSections = maintainableSections;
    }

    public boolean getPreserveLockingKeysOnCopy() {
        return this.preserveLockingKeysOnCopy;
    }

    public void setPreserveLockingKeysOnCopy(boolean preserveLockingKeysOnCopy) {
        this.preserveLockingKeysOnCopy = preserveLockingKeysOnCopy;
    }

    public boolean getAllowsRecordDeletion() {
        return this.allowsRecordDeletion;
    }

    public void setAllowsRecordDeletion(boolean allowsRecordDeletion) {
        this.allowsRecordDeletion = allowsRecordDeletion;
    }

    @Deprecated
    public boolean isTranslateCodes() {
        return this.translateCodes;
    }

    @Deprecated
    public void setTranslateCodes(boolean translateCodes) {
        this.translateCodes = translateCodes;
    }

    public Class<? extends DocumentAuthorizer> getDocumentAuthorizerClass() {
        return super.getDocumentAuthorizerClass();
    }

    @Override
    public Class<? extends DocumentPresentationController> getDocumentPresentationControllerClass() {
        return super.getDocumentPresentationControllerClass();
    }

    @Override
    public List<HeaderNavigation> getHeaderNavigationList() {
        return this.headerNavigationList;
    }

    @Override
    public List<String> getWebScriptFiles() {
        return this.webScriptFiles;
    }

    @Override
    public void setWebScriptFiles(List<String> webScriptFiles) {
        this.webScriptFiles = webScriptFiles;
    }

    @Override
    public void setHeaderNavigationList(List<HeaderNavigation> headerNavigationList) {
        this.headerNavigationList = headerNavigationList;
    }

    @Override
    public boolean isSessionDocument() {
        return this.sessionDocument;
    }

    @Override
    public void setSessionDocument(boolean sessionDocument) {
        this.sessionDocument = sessionDocument;
    }

    @Override
    public Class<? extends DerivedValuesSetter> getDerivedValuesSetterClass() {
        return this.derivedValuesSetterClass;
    }

    @Override
    public void setDerivedValuesSetterClass(Class<? extends DerivedValuesSetter> derivedValuesSetter) {
        this.derivedValuesSetterClass = derivedValuesSetter;
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        if (this.getBusinessRulesClass() == null || this.getBusinessRulesClass().equals(MaintenanceDocumentRuleBase.class)) {
            this.setBusinessRulesClass(org.kuali.kfs.kns.maintenance.rules.MaintenanceDocumentRuleBase.class);
        }
        super.afterPropertiesSet();
    }

    public void setDataObjectClass(Class<?> dataObjectClass) {
        if (dataObjectClass == null) {
            throw new IllegalArgumentException("invalid (null) dataObjectClass");
        }
        this.dataObjectClass = dataObjectClass;
    }

    public Class<?> getDataObjectClass() {
        return this.dataObjectClass;
    }

    public void setMaintainableClass(Class<? extends Maintainable> maintainableClass) {
        if (maintainableClass == null) {
            throw new IllegalArgumentException("invalid (null) maintainableClass");
        }
        this.maintainableClass = maintainableClass;
    }
}

