/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.kns.document.authorization;

import java.util.HashSet;
import java.util.Set;
import org.kuali.kfs.kns.document.authorization.BusinessObjectRestrictionsBase;
import org.kuali.kfs.kns.document.authorization.FieldRestriction;
import org.kuali.kfs.kns.document.authorization.InquiryOrMaintenanceDocumentRestrictions;
import org.kuali.kfs.kns.inquiry.InquiryRestrictions;

public class InquiryOrMaintenanceDocumentRestrictionsBase
extends BusinessObjectRestrictionsBase
implements InquiryOrMaintenanceDocumentRestrictions,
InquiryRestrictions {
    private Set<String> hiddenFields;
    private Set<String> hiddenSectionIds;

    @Override
    public void addHiddenField(String fieldName) {
        this.hiddenFields.add(fieldName);
    }

    @Override
    public void addHiddenSectionId(String sectionId) {
        this.hiddenSectionIds.add(sectionId);
    }

    @Override
    public FieldRestriction getFieldRestriction(String fieldName) {
        FieldRestriction fieldRestriction = super.getFieldRestriction(fieldName);
        if (this.isHiddenField(fieldName)) {
            fieldRestriction = new FieldRestriction(fieldName, "hidden");
        }
        return fieldRestriction;
    }

    @Override
    public boolean hasRestriction(String fieldName) {
        return super.hasRestriction(fieldName) || this.isHiddenField(fieldName);
    }

    @Override
    public boolean hasAnyFieldRestrictions() {
        return super.hasAnyFieldRestrictions() || !this.hiddenFields.isEmpty();
    }

    @Override
    public void clearAllRestrictions() {
        super.clearAllRestrictions();
        this.hiddenFields = new HashSet<String>();
        this.hiddenSectionIds = new HashSet<String>();
    }

    @Override
    public boolean isHiddenSectionId(String sectionId) {
        return this.hiddenSectionIds.contains(sectionId);
    }

    protected boolean isHiddenField(String fieldName) {
        String normalizedFieldName = this.normalizeFieldName(fieldName);
        return this.hiddenFields.contains(normalizedFieldName);
    }
}

