/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.kns.maintenance;

import java.util.HashMap;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.kfs.kns.maintenance.MaintainableImpl;
import org.kuali.kfs.kns.service.KNSServiceLocator;
import org.kuali.kfs.krad.bo.GlobalBusinessObject;
import org.kuali.kfs.krad.bo.GlobalBusinessObjectDetail;
import org.kuali.kfs.krad.bo.PersistableBusinessObject;
import org.kuali.kfs.krad.maintenance.MaintenanceLock;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.krad.service.KRADServiceLocator;
import org.kuali.kfs.krad.util.ObjectUtils;

public abstract class GlobalMaintainableImpl
extends MaintainableImpl {
    private static final long serialVersionUID = 4814145799502207182L;
    private static final Logger LOG = LogManager.getLogger();

    @Override
    public void prepareForSave() {
        if (this.businessObject != null) {
            this.prepareGlobalsForSave();
        }
    }

    @Override
    public void processAfterRetrieve() {
        if (this.businessObject != null) {
            this.processGlobalsAfterRetrieve();
        }
    }

    protected void processGlobalsAfterRetrieve() {
        GlobalBusinessObject gbo = (GlobalBusinessObject)((Object)this.businessObject);
        Class<?> gboClass = this.businessObject.getClass();
        String finDocNumber = gbo.getDocumentNumber();
        boolean assumptionIsWrong = false;
        List<String> primaryKeys = KNSServiceLocator.getBusinessObjectMetaDataService().listPrimaryKeyFieldNames(gboClass);
        if (primaryKeys == null) {
            assumptionIsWrong = true;
        } else if (primaryKeys.isEmpty()) {
            assumptionIsWrong = true;
        } else if (primaryKeys.size() != 1) {
            assumptionIsWrong = true;
        } else if (!primaryKeys.get(0).getClass().equals(String.class)) {
            assumptionIsWrong = true;
        } else if (!"documentNumber".equalsIgnoreCase(primaryKeys.get(0))) {
            assumptionIsWrong = true;
        }
        if (assumptionIsWrong) {
            throw new RuntimeException("An assertion about the nature of the primary keys for this GBO has failed, and processing cannot continue.");
        }
        HashMap<String, String> pkMap = new HashMap<String, String>();
        pkMap.put("documentNumber", finDocNumber);
        PersistableBusinessObject newBo = (PersistableBusinessObject)KRADServiceLocator.getBusinessObjectService().findByPrimaryKey(gboClass, pkMap);
        if (newBo == null) {
            throw new RuntimeException("The Global Business Object could not be retrieved from the DB. This should never happen under normal circumstances.  If this is a legitimate case Then this exception should be removed.");
        }
        try {
            ObjectUtils.setObjectPropertyDeep(newBo, "newCollectionRecord", Boolean.TYPE, true, 2);
        }
        catch (Exception e) {
            LOG.error("unable to set newCollectionRecord property: " + e.getMessage());
            throw new RuntimeException("unable to set newCollectionRecord property: " + e.getMessage());
        }
        this.setBusinessObject(newBo);
    }

    protected void prepareGlobalsForSave() {
        GlobalBusinessObject gbo = (GlobalBusinessObject)((Object)this.businessObject);
        gbo.setDocumentNumber(this.getDocumentNumber());
        List<? extends GlobalBusinessObjectDetail> details = gbo.getAllDetailObjects();
        for (GlobalBusinessObjectDetail globalBusinessObjectDetail : details) {
            globalBusinessObjectDetail.setDocumentNumber(this.getDocumentNumber());
        }
    }

    @Override
    public abstract List<MaintenanceLock> generateMaintenanceLocks();

    @Override
    public void saveBusinessObject() {
        List<PersistableBusinessObject> bosToPersist;
        BusinessObjectService boService = KRADServiceLocator.getBusinessObjectService();
        GlobalBusinessObject gbo = (GlobalBusinessObject)((Object)this.businessObject);
        List<PersistableBusinessObject> bosToDeactivate = gbo.generateDeactivationsToPersist();
        if (bosToDeactivate != null && !bosToDeactivate.isEmpty()) {
            boService.save(bosToDeactivate);
        }
        if ((bosToPersist = gbo.generateGlobalChangesToPersist()) != null && !bosToPersist.isEmpty()) {
            boService.save(bosToPersist);
        }
    }

    public abstract Class<? extends PersistableBusinessObject> getPrimaryEditedBusinessObjectClass();
}

