/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.kns.service.impl;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.sql.Timestamp;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.collections4.map.AbstractHashedMap;
import org.apache.commons.collections4.map.LRUMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.kfs.kns.datadictionary.DocumentEntry;
import org.kuali.kfs.kns.service.DataDictionaryService;
import org.kuali.kfs.kns.service.KNSServiceLocator;
import org.kuali.kfs.kns.service.SessionDocumentService;
import org.kuali.kfs.kns.web.struts.form.KualiDocumentFormBase;
import org.kuali.kfs.krad.UserSession;
import org.kuali.kfs.krad.UserSessionUtils;
import org.kuali.kfs.krad.bo.SessionDocument;
import org.kuali.kfs.krad.dao.SessionDocumentDao;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.rice.core.api.CoreApiServiceLocator;
import org.kuali.rice.core.api.encryption.EncryptionService;
import org.kuali.rice.kew.api.WorkflowDocument;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.transaction.annotation.Transactional;

@Deprecated
@Transactional
public class SessionDocumentServiceImpl
implements SessionDocumentService,
InitializingBean {
    private static final Logger LOG = LogManager.getLogger(SessionDocumentServiceImpl.class);
    protected static final String IP_ADDRESS = "ipAddress";
    protected static final String PRINCIPAL_ID = "principalId";
    protected static final String DOCUMENT_NUMBER = "documentNumber";
    protected static final String SESSION_ID = "sessionId";
    private Map<String, CachedObject> cachedObjects;
    private EncryptionService encryptionService;
    private int maxCacheSize;
    private BusinessObjectService businessObjectService;
    private DataDictionaryService dataDictionaryService;
    private SessionDocumentDao sessionDocumentDao;

    public void afterPropertiesSet() throws Exception {
        this.cachedObjects = Collections.synchronizedMap(new KualiLRUMap(this.maxCacheSize));
    }

    @Override
    public KualiDocumentFormBase getDocumentForm(String documentNumber, String docFormKey, UserSession userSession, String ipAddress) {
        KualiDocumentFormBase documentForm = null;
        LOG.debug("getDocumentForm KualiDocumentFormBase from db");
        try {
            documentForm = (KualiDocumentFormBase)this.retrieveDocumentForm(userSession, userSession.getKualiSessionId(), documentNumber, ipAddress);
            if (!StringUtils.equals((CharSequence)((String)userSession.retrieveObject("METHOD_TO_CALL_KEYS_METHOD_OBJECT_KEY")), (CharSequence)"sort") && !StringUtils.equals((CharSequence)((String)userSession.retrieveObject("METHOD_TO_CALL_KEYS_METHOD_OBJECT_KEY")), (CharSequence)"inquiry")) {
                WorkflowDocument workflowDocument = documentForm.getDocument().getDocumentHeader().getWorkflowDocument();
                UserSessionUtils.addWorkflowDocument(userSession, workflowDocument);
            }
        }
        catch (Exception e) {
            LOG.error("getDocumentForm failed for SessId/DocNum/PrinId/IP:" + userSession.getKualiSessionId() + "/" + documentNumber + "/" + userSession.getPrincipalId() + "/" + ipAddress, (Throwable)e);
        }
        return documentForm;
    }

    protected Object retrieveDocumentForm(UserSession userSession, String sessionId, String documentNumber, String ipAddress) throws Exception {
        HashMap<String, String> primaryKeys = new HashMap<String, String>(4);
        primaryKeys.put(SESSION_ID, sessionId);
        if (documentNumber != null) {
            primaryKeys.put(DOCUMENT_NUMBER, documentNumber);
        }
        primaryKeys.put(PRINCIPAL_ID, userSession.getPrincipalId());
        primaryKeys.put(IP_ADDRESS, ipAddress);
        SessionDocument sessionDoc = this.getBusinessObjectService().findByPrimaryKey(SessionDocument.class, primaryKeys);
        if (sessionDoc != null) {
            byte[] formAsBytes = sessionDoc.getSerializedDocumentForm();
            if (sessionDoc.isEncrypted()) {
                formAsBytes = this.getEncryptionService().decryptBytes(formAsBytes);
            }
            ByteArrayInputStream baip = new ByteArrayInputStream(formAsBytes);
            ObjectInputStream ois = new ObjectInputStream(baip);
            return ois.readObject();
        }
        return null;
    }

    @Override
    public WorkflowDocument getDocumentFromSession(UserSession userSession, String docId) {
        return UserSessionUtils.getWorkflowDocument(userSession, docId);
    }

    @Override
    public void addDocumentToUserSession(UserSession userSession, WorkflowDocument document) {
        UserSessionUtils.addWorkflowDocument(userSession, document);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void purgeDocumentForm(String documentNumber, String docFormKey, UserSession userSession, String ipAddress) {
        UserSession userSession2 = userSession;
        synchronized (userSession2) {
            LOG.debug("purge document form from session");
            userSession.removeObject(docFormKey);
            try {
                LOG.debug("purge document form from database");
                HashMap<String, String> primaryKeys = new HashMap<String, String>(4);
                primaryKeys.put(SESSION_ID, userSession.getKualiSessionId());
                primaryKeys.put(DOCUMENT_NUMBER, documentNumber);
                primaryKeys.put(PRINCIPAL_ID, userSession.getPrincipalId());
                primaryKeys.put(IP_ADDRESS, ipAddress);
                this.getBusinessObjectService().deleteMatching(SessionDocument.class, primaryKeys);
            }
            catch (Exception e) {
                LOG.error("purgeDocumentForm failed for SessId/DocNum/PrinId/IP:" + userSession.getKualiSessionId() + "/" + documentNumber + "/" + userSession.getPrincipalId() + "/" + ipAddress, (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setDocumentForm(KualiDocumentFormBase form, UserSession userSession, String ipAddress) {
        UserSession userSession2 = userSession;
        synchronized (userSession2) {
            String formKey = form.getFormKey();
            String key = userSession.getKualiSessionId() + "-" + formKey;
            this.cachedObjects.put(key, new CachedObject(userSession, formKey));
            String documentNumber = form.getDocument().getDocumentNumber();
            if (StringUtils.isNotBlank((CharSequence)documentNumber)) {
                this.persistDocumentForm(form, userSession, ipAddress, userSession.getKualiSessionId(), documentNumber);
            } else {
                LOG.warn("documentNumber is null on form's document: " + form);
            }
        }
    }

    protected void persistDocumentForm(Object form, UserSession userSession, String ipAddress, String sessionId, String documentNumber) {
        try {
            DocumentEntry documentEntry;
            LOG.debug("set Document Form into database");
            Timestamp currentTime = new Timestamp(System.currentTimeMillis());
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            oos.writeObject(form);
            byte[] formAsBytes = baos.toByteArray();
            boolean encryptContent = false;
            if (form instanceof KualiDocumentFormBase && ((KualiDocumentFormBase)form).getDocTypeName() != null && (documentEntry = this.getDataDictionaryService().getDataDictionary().getDocumentEntry(((KualiDocumentFormBase)form).getDocTypeName())) != null) {
                encryptContent = documentEntry.isEncryptDocumentDataInPersistentSessionStorage();
            }
            if (encryptContent) {
                formAsBytes = this.getEncryptionService().encryptBytes(formAsBytes);
            }
            HashMap<String, String> primaryKeys = new HashMap<String, String>(4);
            primaryKeys.put(SESSION_ID, sessionId);
            primaryKeys.put(DOCUMENT_NUMBER, documentNumber);
            primaryKeys.put(PRINCIPAL_ID, userSession.getPrincipalId());
            primaryKeys.put(IP_ADDRESS, ipAddress);
            SessionDocument sessionDocument = this.getBusinessObjectService().findByPrimaryKey(SessionDocument.class, primaryKeys);
            if (sessionDocument == null) {
                sessionDocument = new SessionDocument();
                sessionDocument.setSessionId(sessionId);
                sessionDocument.setDocumentNumber(documentNumber);
                sessionDocument.setPrincipalId(userSession.getPrincipalId());
                sessionDocument.setIpAddress(ipAddress);
            }
            sessionDocument.setSerializedDocumentForm(formAsBytes);
            sessionDocument.setEncrypted(encryptContent);
            sessionDocument.setLastUpdatedDate(currentTime);
            this.businessObjectService.save(sessionDocument);
        }
        catch (Exception e) {
            String className = form != null ? form.getClass().getName() : "null";
            LOG.error("setDocumentForm failed for SessId/DocNum/PrinId/IP/class:" + userSession.getKualiSessionId() + "/" + documentNumber + "/" + userSession.getPrincipalId() + "/" + ipAddress + "/" + className, (Throwable)e);
        }
    }

    @Override
    public void purgeAllSessionDocuments(Timestamp expirationDate) {
        this.sessionDocumentDao.purgeAllSessionDocuments(expirationDate);
    }

    protected SessionDocumentDao getSessionDocumentDao() {
        return this.sessionDocumentDao;
    }

    public void setSessionDocumentDao(SessionDocumentDao sessionDocumentDao) {
        this.sessionDocumentDao = sessionDocumentDao;
    }

    protected BusinessObjectService getBusinessObjectService() {
        return this.businessObjectService;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    public int getMaxCacheSize() {
        return this.maxCacheSize;
    }

    public void setMaxCacheSize(int maxCacheSize) {
        this.maxCacheSize = maxCacheSize;
    }

    protected EncryptionService getEncryptionService() {
        if (this.encryptionService == null) {
            this.encryptionService = CoreApiServiceLocator.getEncryptionService();
        }
        return this.encryptionService;
    }

    protected DataDictionaryService getDataDictionaryService() {
        if (this.dataDictionaryService == null) {
            this.dataDictionaryService = KNSServiceLocator.getDataDictionaryService();
        }
        return this.dataDictionaryService;
    }

    private static final class KualiLRUMap
    extends LRUMap {
        private static final long serialVersionUID = 1L;

        private KualiLRUMap() {
        }

        private KualiLRUMap(int maxSize) {
            super(maxSize);
        }

        protected void removeEntry(AbstractHashedMap.HashEntry entry, int hashIndex, AbstractHashedMap.HashEntry previous) {
            try {
                CachedObject cachedObject = (CachedObject)this.entryValue(entry);
                cachedObject.getUserSession().removeObject(cachedObject.getFormKey());
            }
            catch (Exception ex) {
                LogManager.getLogger(((Object)((Object)this)).getClass()).warn("Problem purging old entry from the user session when removing from the map: ", (Throwable)ex);
            }
            super.removeEntry(entry, hashIndex, previous);
        }
    }

    private static class CachedObject {
        private UserSession userSession;
        private String formKey;

        CachedObject(UserSession userSession, String formKey) {
            this.userSession = userSession;
            this.formKey = formKey;
        }

        public String toString() {
            return "CachedObject: principalId=" + this.userSession.getPrincipalId() + " / objectWithFormKey=" + this.userSession.retrieveObject(this.formKey);
        }

        public UserSession getUserSession() {
            return this.userSession;
        }

        public String getFormKey() {
            return this.formKey;
        }
    }
}

