/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.krad.datadictionary;

import org.apache.commons.lang3.StringUtils;
import org.kuali.kfs.krad.datadictionary.DataDictionary;
import org.kuali.kfs.krad.datadictionary.DataDictionaryDefinition;
import org.kuali.kfs.krad.datadictionary.exception.AttributeValidationException;
import org.kuali.kfs.krad.datadictionary.validation.capability.CollectionSizeConstrainable;

public class CollectionDefinition
extends DataDictionaryDefinition
implements CollectionSizeConstrainable {
    private static final long serialVersionUID = -2644072136271281041L;
    protected String dataObjectClass;
    protected String name;
    protected String label;
    protected String shortLabel;
    protected String elementLabel;
    protected String summary;
    protected String description;
    protected Integer minOccurs;
    protected Integer maxOccurs;

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        if (StringUtils.isBlank((CharSequence)name)) {
            throw new IllegalArgumentException("invalid (blank) name");
        }
        this.name = name;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        if (StringUtils.isBlank((CharSequence)label)) {
            throw new IllegalArgumentException("invalid (blank) label");
        }
        this.label = label;
    }

    public String getShortLabel() {
        return this.shortLabel != null ? this.shortLabel : this.label;
    }

    public void setShortLabel(String shortLabel) {
        if (StringUtils.isBlank((CharSequence)shortLabel)) {
            throw new IllegalArgumentException("invalid (blank) shortLabel");
        }
        this.shortLabel = shortLabel;
    }

    public String getElementLabel() {
        return this.elementLabel;
    }

    public void setElementLabel(String elementLabel) {
        this.elementLabel = elementLabel;
    }

    public String getSummary() {
        return this.summary;
    }

    public void setSummary(String summary) {
        this.summary = summary;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDataObjectClass() {
        return this.dataObjectClass;
    }

    public void setDataObjectClass(String dataObjectClass) {
        this.dataObjectClass = dataObjectClass;
    }

    public void completeValidation(Class rootBusinessObjectClass, Class otherBusinessObjectClass) {
        if (!DataDictionary.isCollectionPropertyOf(rootBusinessObjectClass, this.name)) {
            throw new AttributeValidationException("property '" + this.name + "' is not a collection property of class '" + rootBusinessObjectClass + "' ()");
        }
    }

    public String toString() {
        return "CollectionDefinition for collection " + this.getName();
    }

    @Override
    public Integer getMaximumNumberOfElements() {
        return this.maxOccurs;
    }

    @Override
    public Integer getMinimumNumberOfElements() {
        return this.minOccurs;
    }

    public Integer getMinOccurs() {
        return this.minOccurs;
    }

    public void setMinOccurs(Integer minOccurs) {
        this.minOccurs = minOccurs;
    }

    public Integer getMaxOccurs() {
        return this.maxOccurs;
    }

    public void setMaxOccurs(Integer maxOccurs) {
        this.maxOccurs = maxOccurs;
    }
}

