/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.krad.datadictionary;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.kfs.krad.datadictionary.DataDictionary;
import org.kuali.kfs.krad.datadictionary.DataDictionaryDefinition;
import org.kuali.kfs.krad.datadictionary.PrimitiveAttributeDefinition;
import org.kuali.kfs.krad.datadictionary.SupportAttributeDefinition;
import org.kuali.kfs.krad.datadictionary.exception.AttributeValidationException;
import org.kuali.rice.kim.api.group.Group;
import org.kuali.rice.kim.api.role.Role;
import org.kuali.rice.kim.framework.group.GroupEbo;
import org.kuali.rice.kim.framework.role.RoleEbo;
import org.kuali.rice.krad.bo.BusinessObject;

public class RelationshipDefinition
extends DataDictionaryDefinition {
    private static final Logger LOG = LogManager.getLogger();
    private static final long serialVersionUID = 2946722646095412576L;
    protected String objectAttributeName;
    protected Class<?> sourceClass;
    protected Class<?> targetClass;
    protected List<PrimitiveAttributeDefinition> primitiveAttributes = new ArrayList<PrimitiveAttributeDefinition>();
    protected List<SupportAttributeDefinition> supportAttributes = new ArrayList<SupportAttributeDefinition>();

    public String getObjectAttributeName() {
        return this.objectAttributeName;
    }

    public Class<?> getSourceClass() {
        return this.sourceClass;
    }

    public Class<?> getTargetClass() {
        if (this.targetClass == null) {
            Class<RoleEbo> propertyClass = DataDictionary.getAttributeClass(this.sourceClass, this.objectAttributeName);
            if (propertyClass == null) {
                throw new AttributeValidationException("cannot get valid class for property '" + this.objectAttributeName + "' as an attribute of '" + this.sourceClass + "'");
            }
            if (Role.class.isAssignableFrom(propertyClass)) {
                LOG.error("ALERT! : " + propertyClass.getName() + " Reference Unconverted to Ebo class: " + this.sourceClass.getName() + "." + this.objectAttributeName);
                propertyClass = RoleEbo.class;
            } else if (Group.class.isAssignableFrom(propertyClass)) {
                LOG.error("ALERT! : " + propertyClass.getName() + " Reference Unconverted to Ebo class: " + this.sourceClass.getName() + "." + this.objectAttributeName);
                propertyClass = GroupEbo.class;
            } else if (!BusinessObject.class.isAssignableFrom(propertyClass)) {
                throw new AttributeValidationException("property '" + this.objectAttributeName + "' is not a BusinessObject (" + propertyClass.getName() + ") on sourceClass (" + this.sourceClass + ")");
            }
            this.targetClass = propertyClass;
        }
        return this.targetClass;
    }

    public void setTargetClass(Class<?> targetClass) {
        this.targetClass = targetClass;
    }

    public void setObjectAttributeName(String objectAttributeName) {
        if (StringUtils.isBlank((CharSequence)objectAttributeName)) {
            throw new IllegalArgumentException("invalid (blank) objectAttributeName");
        }
        this.objectAttributeName = objectAttributeName;
    }

    public List<PrimitiveAttributeDefinition> getPrimitiveAttributes() {
        return this.primitiveAttributes;
    }

    public List<SupportAttributeDefinition> getSupportAttributes() {
        return this.supportAttributes;
    }

    public boolean hasIdentifier() {
        for (SupportAttributeDefinition supportAttributeDefinition : this.supportAttributes) {
            if (!supportAttributeDefinition.isIdentifier()) continue;
            return true;
        }
        return false;
    }

    public SupportAttributeDefinition getIdentifier() {
        for (SupportAttributeDefinition supportAttributeDefinition : this.supportAttributes) {
            if (!supportAttributeDefinition.isIdentifier()) continue;
            return supportAttributeDefinition;
        }
        return null;
    }

    public void completeValidation(Class rootBusinessObjectClass, Class otherBusinessObjectClass) {
        String propertyName = this.objectAttributeName;
        if (!DataDictionary.isPropertyOf(rootBusinessObjectClass, propertyName)) {
            throw new AttributeValidationException("property '" + propertyName + "' is not an attribute of class '" + rootBusinessObjectClass + "' ()");
        }
        this.getTargetClass();
        for (PrimitiveAttributeDefinition primitiveAttributeDefinition : this.primitiveAttributes) {
            primitiveAttributeDefinition.completeValidation(rootBusinessObjectClass, (Class)this.targetClass);
        }
        for (SupportAttributeDefinition supportAttributeDefinition : this.supportAttributes) {
            supportAttributeDefinition.completeValidation(rootBusinessObjectClass, (Class)this.targetClass);
        }
    }

    public String toString() {
        return "RelationshipDefinition for relationship " + this.getObjectAttributeName();
    }

    public void setPrimitiveAttributes(List<PrimitiveAttributeDefinition> primitiveAttributes) {
        this.primitiveAttributes = primitiveAttributes;
    }

    public void setSupportAttributes(List<SupportAttributeDefinition> supportAttributes) {
        this.supportAttributes = supportAttributes;
    }

    public void setSourceClass(Class<?> sourceClass) {
        this.sourceClass = sourceClass;
    }
}

