/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.krad.datadictionary.validation.processor;

import java.util.Collection;
import org.kuali.kfs.krad.datadictionary.exception.AttributeValidationException;
import org.kuali.kfs.krad.datadictionary.validation.AttributeValueReader;
import org.kuali.kfs.krad.datadictionary.validation.ErrorLevel;
import org.kuali.kfs.krad.datadictionary.validation.ValidationUtils;
import org.kuali.kfs.krad.datadictionary.validation.constraint.Constraint;
import org.kuali.kfs.krad.datadictionary.validation.constraint.PrerequisiteConstraint;
import org.kuali.kfs.krad.datadictionary.validation.processor.MandatoryElementConstraintProcessor;
import org.kuali.kfs.krad.datadictionary.validation.result.ConstraintValidationResult;

public abstract class BasePrerequisiteConstraintProcessor<C extends Constraint>
extends MandatoryElementConstraintProcessor<C> {
    protected ConstraintValidationResult processPrerequisiteConstraint(PrerequisiteConstraint constraint, AttributeValueReader attributeValueReader) throws AttributeValidationException {
        boolean isSuccessful;
        ConstraintValidationResult constraintValidationResult = new ConstraintValidationResult(this.getName());
        if (constraint == null) {
            constraintValidationResult.setStatus(ErrorLevel.NOCONSTRAINT);
            return constraintValidationResult;
        }
        String attributeName = constraint.getPropertyName();
        if (ValidationUtils.isNullOrEmpty(attributeName)) {
            throw new AttributeValidationException("Prerequisite constraints must include the name of the attribute that is required");
        }
        Object value = attributeValueReader.getValue(attributeName);
        if (value instanceof String) {
            isSuccessful = ValidationUtils.hasText((String)value);
        } else if (value instanceof Collection) {
            isSuccessful = ((Collection)value).size() > 0;
        } else {
            boolean bl = isSuccessful = null != value;
        }
        if (!isSuccessful) {
            String label = attributeValueReader.getLabel(attributeName);
            if (label != null) {
                attributeName = label;
            }
            constraintValidationResult.setError("error.requiresField", attributeName);
            constraintValidationResult.setConstraintLabelKey(constraint.getLabelKey());
            constraintValidationResult.setErrorParameters(constraint.getValidationMessageParamsArray());
        }
        return constraintValidationResult;
    }
}

