/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.krad.maintenance;

import java.util.HashMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.kfs.kns.document.MaintenanceDocument;
import org.kuali.kfs.krad.exception.KualiExceptionIncident;
import org.kuali.kfs.krad.exception.ValidationException;
import org.kuali.kfs.krad.service.KRADServiceLocator;
import org.kuali.kfs.krad.service.KRADServiceLocatorWeb;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.krad.util.UrlFactory;
import org.kuali.rice.kew.api.WorkflowDocument;

public final class MaintenanceUtils {
    private static final Logger LOG = LogManager.getLogger(MaintenanceUtils.class);

    private MaintenanceUtils() {
    }

    public static void checkForLockingDocument(MaintenanceDocument document, boolean throwExceptionIfLocked) {
        LOG.info("starting checkForLockingDocument (by MaintenanceDocument)");
        String blockingDocId = document.getNewMaintainableObject().getLockingDocumentId();
        MaintenanceUtils.checkDocumentBlockingDocumentId(blockingDocId, throwExceptionIfLocked);
    }

    public static void checkDocumentBlockingDocumentId(String blockingDocId, boolean throwExceptionIfLocked) {
        if (StringUtils.isBlank((CharSequence)blockingDocId)) {
            return;
        }
        if (LOG.isInfoEnabled()) {
            LOG.info("Locking document found:  docId = " + blockingDocId + ".");
        }
        WorkflowDocument lockedDocument = null;
        try {
            if (KRADServiceLocatorWeb.getWorkflowDocumentService().workflowDocumentExists(blockingDocId)) {
                lockedDocument = KRADServiceLocatorWeb.getWorkflowDocumentService().loadWorkflowDocument(blockingDocId, GlobalVariables.getUserSession().getPerson());
            }
        }
        catch (Exception ex) {
            LOG.error("Unable to retrieve locking document specified in the maintenance lock table: " + blockingDocId, (Throwable)ex);
            MaintenanceUtils.cleanOrphanLocks(blockingDocId, ex);
            return;
        }
        if (lockedDocument == null) {
            LOG.warn("Locking document header for " + blockingDocId + "came back null.");
            MaintenanceUtils.cleanOrphanLocks(blockingDocId, null);
        }
        if (MaintenanceUtils.lockCanBeIgnored(lockedDocument)) {
            return;
        }
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("docId", blockingDocId);
        parameters.put("command", "displayDocSearchView");
        String blockingUrl = UrlFactory.parameterizeUrl(KRADServiceLocator.getKualiConfigurationService().getPropertyValueAsString("workflow.url") + "/" + "DocHandler.do", parameters);
        if (LOG.isDebugEnabled()) {
            LOG.debug("blockingUrl = '" + blockingUrl + "'");
            LOG.debug("Maintenance record: " + lockedDocument.getApplicationDocumentId() + "is locked.");
        }
        String[] errorParameters = new String[]{blockingUrl, blockingDocId};
        if (throwExceptionIfLocked) {
            GlobalVariables.getMessageMap().putError("GLOBAL_ERRORS", "error.maintenance.locked", errorParameters);
            throw new ValidationException("Maintenance Record is locked by another document.");
        }
        GlobalVariables.getMessageMap().putWarning("GlobalMessages", "warning.maintenance.locked", errorParameters);
    }

    private static boolean lockCanBeIgnored(WorkflowDocument lockedDocument) {
        if (lockedDocument == null) {
            return true;
        }
        String userId = GlobalVariables.getUserSession().getPrincipalId().trim();
        if (StringUtils.isBlank((CharSequence)userId)) {
            return false;
        }
        if (!userId.equalsIgnoreCase(lockedDocument.getInitiatorPrincipalId().trim())) {
            return false;
        }
        return lockedDocument.isInitiated();
    }

    protected static void cleanOrphanLocks(String lockingDocumentNumber, Exception workflowException) {
        try {
            KRADServiceLocatorWeb.getMaintenanceDocumentService().deleteLocks(lockingDocumentNumber);
            HashMap<String, String> parameters = new HashMap<String, String>(1);
            parameters.put("docId", lockingDocumentNumber);
            KualiExceptionIncident kei = KRADServiceLocatorWeb.getKualiExceptionIncidentService().getExceptionIncident(workflowException, parameters);
            KRADServiceLocatorWeb.getKualiExceptionIncidentService().report(kei);
        }
        catch (Exception ex) {
            LOG.error("Unable to delete and notify upon locking document retrieval failure.", (Throwable)ex);
        }
    }

    public static boolean isMaintenanceDocumentCreatingNewRecord(String maintenanceAction) {
        if ("Edit".equalsIgnoreCase(maintenanceAction)) {
            return false;
        }
        if ("newWithExisting".equalsIgnoreCase(maintenanceAction)) {
            return false;
        }
        if ("Delete".equalsIgnoreCase(maintenanceAction)) {
            return false;
        }
        if ("New".equalsIgnoreCase(maintenanceAction)) {
            return true;
        }
        if ("Copy".equalsIgnoreCase(maintenanceAction)) {
            return true;
        }
        return true;
    }
}

