/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.krad.service;

import org.kuali.kfs.krad.service.AttachmentService;
import org.kuali.kfs.krad.service.BusinessObjectSerializerService;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.krad.service.KeyValuesService;
import org.kuali.kfs.krad.service.NoteService;
import org.kuali.kfs.krad.service.PersistenceService;
import org.kuali.kfs.krad.service.PersistenceStructureService;
import org.kuali.kfs.krad.service.SequenceAccessorService;
import org.kuali.kfs.krad.service.XmlObjectSerializerService;
import org.kuali.rice.core.api.config.property.ConfigurationService;
import org.kuali.rice.core.api.resourceloader.GlobalResourceLoader;

public final class KRADServiceLocator {
    public static final String ATTACHMENT_SERVICE = "cf.attachmentService";
    public static final String PERSISTENCE_SERVICE = "cf.persistenceService";
    public static final String PERSISTENCE_STRUCTURE_SERVICE = "cf.persistenceStructureService";
    public static final String NOTE_SERVICE = "cf.noteService";
    public static final String BUSINESS_OBJECT_SERVICE = "cf.businessObjectService";
    public static final String KUALI_CONFIGURATION_SERVICE = "cf.kualiConfigurationService";
    public static final String XML_OBJECT_SERIALIZER_SERVICE = "cf.xmlObjectSerializerService";
    public static final String XML_OBJECT_SERIALIZER_IGNORE_MISSING_FIELDS_SERVICE = "xmlObjectSerializerIgnoreMissingFieldsService";
    public static final String SERIALIZER_SERVICE = "cf.businessObjectSerializerService";
    public static final String SEQUENCE_ACCESSOR_SERVICE = "cf.sequenceAccessorService";
    public static final String KEY_VALUES_SERVICE = "cf.keyValuesService";

    private KRADServiceLocator() {
    }

    static <T> T getService(String serviceName) {
        return (T)GlobalResourceLoader.getService((String)serviceName);
    }

    public static AttachmentService getAttachmentService() {
        return (AttachmentService)KRADServiceLocator.getService(ATTACHMENT_SERVICE);
    }

    public static PersistenceService getPersistenceService() {
        return (PersistenceService)KRADServiceLocator.getService(PERSISTENCE_SERVICE);
    }

    public static PersistenceStructureService getPersistenceStructureService() {
        return (PersistenceStructureService)KRADServiceLocator.getService(PERSISTENCE_STRUCTURE_SERVICE);
    }

    public static NoteService getNoteService() {
        return (NoteService)KRADServiceLocator.getService(NOTE_SERVICE);
    }

    public static BusinessObjectService getBusinessObjectService() {
        return (BusinessObjectService)KRADServiceLocator.getService(BUSINESS_OBJECT_SERVICE);
    }

    public static ConfigurationService getKualiConfigurationService() {
        return (ConfigurationService)KRADServiceLocator.getService(KUALI_CONFIGURATION_SERVICE);
    }

    public static XmlObjectSerializerService getXmlObjectSerializerService() {
        return (XmlObjectSerializerService)KRADServiceLocator.getService(XML_OBJECT_SERIALIZER_SERVICE);
    }

    public static XmlObjectSerializerService getXmlObjectSerializerIgnoreMissingFieldsService() {
        return (XmlObjectSerializerService)KRADServiceLocator.getService(XML_OBJECT_SERIALIZER_IGNORE_MISSING_FIELDS_SERVICE);
    }

    public static BusinessObjectSerializerService getBusinessObjectSerializerService() {
        return (BusinessObjectSerializerService)KRADServiceLocator.getService(SERIALIZER_SERVICE);
    }

    public static SequenceAccessorService getSequenceAccessorService() {
        return (SequenceAccessorService)KRADServiceLocator.getService(SEQUENCE_ACCESSOR_SERVICE);
    }

    public static KeyValuesService getKeyValuesService() {
        return (KeyValuesService)KRADServiceLocator.getService(KEY_VALUES_SERVICE);
    }
}

