/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.krad.web.filter;

import java.util.UUID;
import javax.servlet.Filter;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.namespace.QName;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.ThreadContext;
import org.kuali.kfs.coreservice.framework.CoreFrameworkServiceLocator;
import org.kuali.kfs.coreservice.framework.parameter.ParameterService;
import org.kuali.kfs.kns.bo.AuthenticationValidationResponse;
import org.kuali.kfs.kns.service.CfAuthenticationService;
import org.kuali.kfs.kns.service.KNSServiceLocator;
import org.kuali.kfs.krad.UserSession;
import org.kuali.kfs.krad.exception.AuthenticationException;
import org.kuali.kfs.krad.util.KRADUtils;
import org.kuali.rice.core.api.config.property.ConfigContext;
import org.kuali.rice.core.api.exception.RiceRuntimeException;
import org.kuali.rice.core.api.resourceloader.GlobalResourceLoader;
import org.kuali.rice.kim.api.identity.AuthenticationService;

public abstract class LoginFilterBase
implements Filter {
    private static final String MDC_USER = "user";
    protected ParameterService parameterService;
    protected CfAuthenticationService cfAuthenticationService;
    private FilterConfig filterConfig;

    public void init(FilterConfig filterConfig) throws ServletException {
        this.filterConfig = filterConfig;
    }

    public void destroy() {
    }

    protected boolean isUserSessionEstablished(HttpServletRequest request) {
        return KRADUtils.getUserSessionFromRequest(request) != null;
    }

    protected void establishUserSession(HttpServletRequest request) {
        if (!this.isUserSessionEstablished(request)) {
            String principalName = ((AuthenticationService)GlobalResourceLoader.getResourceLoader().getService(new QName("kimAuthenticationService"))).getPrincipalName(request);
            AuthenticationValidationResponse validationResponse = this.getCfAuthenticationService().validatePrincipalName(principalName);
            switch (validationResponse) {
                case INVALID_PRINCIPAL_NAME_BLANK: {
                    throw new AuthenticationException("Blank User from AuthenticationService - This should never happen.");
                }
                case INVALID_PRINCIPAL_DOES_NOT_EXIST: {
                    throw new AuthenticationException("Unknown User: " + principalName);
                }
                case INVALID_PRINCIPAL_CANNOT_LOGIN: {
                    throw new AuthenticationException("You cannot log in, because you are not an active Kuali user.\nPlease ask someone to activate your account if you need to use Kuali Systems.\nThe user id provided was: " + principalName + ".\n");
                }
            }
            UserSession userSession = new UserSession(principalName);
            if (userSession.getPerson() == null) {
                throw new AuthenticationException("Invalid User: " + principalName);
            }
            request.getSession().setAttribute("cf.UserSession", (Object)userSession);
            org.kuali.rice.krad.UserSession riceUserSession = new org.kuali.rice.krad.UserSession(principalName);
            request.getSession().setAttribute("UserSession", (Object)riceUserSession);
        }
    }

    protected void establishSessionCookie(HttpServletRequest request, HttpServletResponse response) {
        String kualiSessionId = this.getKualiSessionId(request.getCookies());
        if (kualiSessionId == null) {
            kualiSessionId = UUID.randomUUID().toString();
            Cookie cookie = new Cookie("cf.kualiSessionId", kualiSessionId);
            cookie.setPath(this.filterConfig.getServletContext().getContextPath());
            response.addCookie(cookie);
        }
        KRADUtils.getUserSessionFromRequest(request).setKualiSessionId(kualiSessionId);
    }

    private String getKualiSessionId(Cookie[] cookies) {
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                if (!"cf.kualiSessionId".equals(cookie.getName())) continue;
                return cookie.getValue();
            }
        }
        return null;
    }

    protected void establishBackdoorUser(HttpServletRequest request) {
        AuthenticationValidationResponse response;
        if (ConfigContext.getCurrentContextConfig().isProductionEnvironment()) {
            return;
        }
        String backdoor = request.getParameter("backdoorId");
        if (StringUtils.isNotBlank((CharSequence)backdoor) && (response = this.getCfAuthenticationService().validatePrincipalName(backdoor)) == AuthenticationValidationResponse.VALID_AUTHENTICATION && this.getParameterService().getParameterValueAsBoolean("KR-WKFLW", "Backdoor", "SHOW_BACK_DOOR_LOGIN_IND").booleanValue()) {
            try {
                KRADUtils.getUserSessionFromRequest(request).setBackdoorUser(backdoor);
            }
            catch (RiceRuntimeException riceRuntimeException) {
                // empty catch block
            }
        }
    }

    protected void addToMDC(HttpServletRequest request) {
        ThreadContext.put((String)MDC_USER, (String)KRADUtils.getUserSessionFromRequest(request).getPrincipalName());
    }

    protected void removeFromMDC() {
        ThreadContext.remove((String)MDC_USER);
    }

    protected CfAuthenticationService getCfAuthenticationService() {
        if (this.cfAuthenticationService == null) {
            this.cfAuthenticationService = KNSServiceLocator.getCfAuthenticationService();
        }
        return this.cfAuthenticationService;
    }

    protected ParameterService getParameterService() {
        if (this.parameterService == null) {
            this.parameterService = CoreFrameworkServiceLocator.getParameterService();
        }
        return this.parameterService;
    }
}

