/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.kns.util;

import java.lang.reflect.Method;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.kuali.kfs.kns.service.DataDictionaryService;
import org.kuali.kfs.kns.service.KNSServiceLocator;
import org.kuali.kfs.krad.keyvalues.KeyValuesFinder;
import org.kuali.kfs.krad.keyvalues.PersistableBusinessObjectValuesFinder;
import org.kuali.rice.core.api.CoreApiServiceLocator;
import org.kuali.rice.core.api.util.KeyValue;

public class ActionFormUtilMap
extends HashMap {
    private static final long serialVersionUID = 1L;
    private boolean cacheValueFinderResults;

    @Override
    public Object get(Object key) {
        Object methodValue;
        Method method;
        if (this.cacheValueFinderResults && super.containsKey(key)) {
            return super.get(key);
        }
        String[] methodKey = StringUtils.split((String)((String)key), (String)"~");
        String methodToCall = methodKey[0];
        Object[] methodParms = new Object[methodKey.length - 1];
        Class[] methodParmsPrototype = new Class[methodKey.length - 1];
        for (int i = 1; i < methodKey.length; ++i) {
            methodParms[i - 1] = methodKey[i];
            methodParmsPrototype[i - 1] = Object.class;
        }
        try {
            method = ActionFormUtilMap.class.getMethod(methodToCall, methodParmsPrototype);
        }
        catch (NoSuchMethodException | SecurityException e) {
            throw new RuntimeException("Unable to object handle on method given to ActionFormUtilMap: " + e.getMessage());
        }
        try {
            methodValue = method.invoke((Object)this, methodParms);
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to invoke method " + methodToCall, e);
        }
        if (this.cacheValueFinderResults) {
            super.put(key, methodValue);
        }
        return methodValue;
    }

    public List<KeyValue> getOptionsMap(Object key) {
        if (StringUtils.isBlank((CharSequence)((String)key))) {
            return new ArrayList<KeyValue>();
        }
        String keyName = this.getKeyValueFinderBeanName((String)key);
        DataDictionaryService dataDictionaryService = KNSServiceLocator.getDataDictionaryService();
        KeyValuesFinder finder = (KeyValuesFinder)dataDictionaryService.getDictionaryObject(keyName);
        return finder.getKeyValues();
    }

    public List<KeyValue> getOptionsMap(Object key, Object boClass, Object keyAttribute, Object labelAttribute, Object includeKeyInLabel) {
        return this.getOptionsMap(key, boClass, keyAttribute, labelAttribute, null, includeKeyInLabel);
    }

    public List<KeyValue> getOptionsMap(Object key, Object boClass, Object keyAttribute, Object labelAttribute, Object includeBlankRow, Object includeKeyInLabel) {
        if (StringUtils.isBlank((CharSequence)((String)key))) {
            return new ArrayList<KeyValue>();
        }
        String keyName = this.getKeyValueFinderBeanName((String)key);
        DataDictionaryService dataDictionaryService = KNSServiceLocator.getDataDictionaryService();
        KeyValuesFinder finder = (KeyValuesFinder)dataDictionaryService.getDictionaryObject(keyName);
        if (finder instanceof PersistableBusinessObjectValuesFinder) {
            Class<?> businessObjectClass;
            PersistableBusinessObjectValuesFinder pboFinder = (PersistableBusinessObjectValuesFinder)finder;
            String businessObjectClassName = StringUtils.replace((String)((String)boClass), (String)"|", (String)".");
            try {
                businessObjectClass = Class.forName(businessObjectClassName);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e.getMessage(), e);
            }
            pboFinder.setBusinessObjectClass(businessObjectClass);
            pboFinder.setKeyAttributeName((String)keyAttribute);
            pboFinder.setLabelAttributeName((String)labelAttribute);
            pboFinder.setIncludeBlankRow(Boolean.parseBoolean((String)includeBlankRow));
            pboFinder.setIncludeKeyInDescription(Boolean.parseBoolean((String)includeKeyInLabel));
            return pboFinder.getKeyValues();
        }
        return finder.getKeyValues();
    }

    private String getKeyValueFinderBeanName(String key) {
        String keyName = key;
        keyName = keyName.substring(keyName.lastIndexOf("|") + 1);
        char[] c = keyName.toCharArray();
        c[0] = Character.toLowerCase(c[0]);
        keyName = new String(c);
        return keyName;
    }

    public String encryptValue(Object value) {
        String encrypted = "";
        if (value != null) {
            encrypted = value.toString();
        }
        try {
            if (CoreApiServiceLocator.getEncryptionService().isEnabled()) {
                encrypted = CoreApiServiceLocator.getEncryptionService().encrypt(value);
            }
        }
        catch (GeneralSecurityException e) {
            throw new RuntimeException("Unable to encrypt value in action form: " + e.getMessage());
        }
        return encrypted;
    }

    public void setCacheValueFinderResults(boolean cacheValueFinderResults) {
        this.cacheValueFinderResults = cacheValueFinderResults;
    }
}

