/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.kns.web.struts.action;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.kuali.kfs.kns.web.struts.form.KualiExceptionIncidentForm;
import org.kuali.kfs.krad.exception.KualiExceptionIncident;
import org.kuali.kfs.krad.service.KRADServiceLocatorWeb;
import org.kuali.kfs.krad.service.KualiExceptionIncidentService;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.rice.core.api.config.property.ConfigContext;

public class KualiExceptionHandlerAction
extends Action {
    private static final Logger LOG = LogManager.getLogger(KualiExceptionHandlerAction.class);

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return this.executeException(mapping, form, request, response);
    }

    public ActionForward executeException(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        if (LOG.isDebugEnabled()) {
            String lm = String.format("ENTRY %s%n%s", form.getClass().getSimpleName(), request.getRequestURI());
            LOG.debug(lm);
        }
        Exception e = (Exception)request.getAttribute("org.apache.struts.action.EXCEPTION");
        ActionForward returnForward = null;
        if (e == null) {
            if (form instanceof KualiExceptionIncidentForm) {
                KualiExceptionIncidentForm formObject = (KualiExceptionIncidentForm)form;
                if (!formObject.isCancel()) {
                    KualiExceptionIncidentService reporterService = KRADServiceLocatorWeb.getKualiExceptionIncidentService();
                    HashMap<String, String> reducedMap = new HashMap<String, String>();
                    Enumeration names = request.getParameterNames();
                    while (names.hasMoreElements()) {
                        String name = (String)names.nextElement();
                        reducedMap.put(name, request.getParameter(name));
                    }
                    Map<String, Object> userSessionMap = GlobalVariables.getUserSession().getObjectMap();
                    if (userSessionMap.get("EXCEPTION_TIME_STAMP").toString().equals(reducedMap.get("stackTrace"))) {
                        reducedMap.put("documentId", userSessionMap.get("EXCEPTION_DOCUMENT_ID").toString());
                        reducedMap.put("userEmail", userSessionMap.get("EXCEPTION_USER_EMAIL").toString());
                        reducedMap.put("userName", userSessionMap.get("EXCEPTION_USER_NAME").toString());
                        reducedMap.put("principalName", userSessionMap.get("EXCEPTION_UUID").toString());
                        reducedMap.put("componentName", userSessionMap.get("EXCEPTION_COMPONENT_NAME").toString());
                        reducedMap.put("exceptionReportSubject", userSessionMap.get("EXCEPTION_EXCEPTION_REPORT_SUBJECT").toString());
                        reducedMap.put("exceptionMessage", userSessionMap.get("EXCEPTION_EXCEPTION_MESSAGE").toString());
                        reducedMap.put("stackTrace", userSessionMap.get("EXCEPTION_STACK_TRACE").toString());
                    } else {
                        reducedMap.put("stackTrace", "Not available.");
                    }
                    KualiExceptionIncident exceptionIncident = reporterService.getExceptionIncident(reducedMap);
                    reporterService.report(exceptionIncident);
                } else {
                    ActionForward cancelForward = mapping.findForward("cancel");
                    if (cancelForward == null) {
                        cancelForward = returnForward;
                    } else {
                        returnForward = cancelForward;
                    }
                }
            }
        } else {
            returnForward = this.processException(mapping, form, request, e);
        }
        if (returnForward == null) {
            returnForward = mapping.findForward("close");
        }
        if (LOG.isDebugEnabled()) {
            String lm = String.format("EXIT %s", returnForward == null ? "null" : returnForward.getPath());
            LOG.debug(lm);
        }
        return returnForward;
    }

    protected ActionForward processException(ActionMapping mapping, ActionForm form, HttpServletRequest request, Exception exception) throws Exception {
        KualiExceptionIncidentService reporterService = KRADServiceLocatorWeb.getKualiExceptionIncidentService();
        Map properties = (Map)request.getAttribute("exceptionProperties");
        KualiExceptionIncident ei = reporterService.getExceptionIncident(exception, properties);
        String exceptionTimeStamp = String.valueOf(System.currentTimeMillis());
        GlobalVariables.getUserSession().addObject("EXCEPTION_TIME_STAMP", exceptionTimeStamp);
        GlobalVariables.getUserSession().addObject("EXCEPTION_DOCUMENT_ID", ei.getProperty("documentId"));
        GlobalVariables.getUserSession().addObject("EXCEPTION_USER_EMAIL", ei.getProperty("userEmail"));
        GlobalVariables.getUserSession().addObject("EXCEPTION_USER_NAME", ei.getProperty("userName"));
        GlobalVariables.getUserSession().addObject("EXCEPTION_UUID", ei.getProperty("principalName"));
        GlobalVariables.getUserSession().addObject("EXCEPTION_COMPONENT_NAME", ei.getProperty("componentName"));
        GlobalVariables.getUserSession().addObject("EXCEPTION_EXCEPTION_REPORT_SUBJECT", ei.getProperty("exceptionReportSubject"));
        GlobalVariables.getUserSession().addObject("EXCEPTION_EXCEPTION_MESSAGE", ei.getProperty("exceptionMessage"));
        GlobalVariables.getUserSession().addObject("EXCEPTION_STACK_TRACE", ei.getProperty("stackTrace"));
        if (ConfigContext.getCurrentContextConfig().isProductionEnvironment()) {
            Map<String, String> prodProperties = ei.toProperties();
            prodProperties.put("documentId", "");
            prodProperties.put("userEmail", "");
            prodProperties.put("userName", "");
            prodProperties.put("principalName", "");
            prodProperties.put("componentName", "");
            prodProperties.put("exceptionReportSubject", "");
            prodProperties.put("exceptionMessage", "");
            prodProperties.put("stackTrace", exceptionTimeStamp);
            ei = reporterService.getExceptionIncident(null, prodProperties);
        }
        request.setAttribute(KualiExceptionHandlerAction.class.getSimpleName(), ei.toProperties());
        return mapping.findForward("basic");
    }
}

