/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.krad.dao.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.ojb.broker.query.Criteria;
import org.apache.ojb.broker.query.Query;
import org.apache.ojb.broker.query.QueryByCriteria;
import org.apache.ojb.broker.query.QueryFactory;
import org.kuali.kfs.krad.bo.Attachment;
import org.kuali.kfs.krad.bo.Note;
import org.kuali.kfs.krad.dao.NoteDao;
import org.kuali.rice.core.framework.persistence.ojb.dao.PlatformAwareDaoBaseOjb;
import org.springframework.dao.DataAccessException;

public class NoteDaoOjb
extends PlatformAwareDaoBaseOjb
implements NoteDao {
    @Override
    public void save(Note note) throws DataAccessException {
        if (note.getAttachment() != null && note.getAttachment().getAttachmentFileName() == null) {
            note.setAttachment(null);
        }
        if (note.getNoteIdentifier() == null && note.getAttachment() != null) {
            Attachment attachment = note.getAttachment();
            note.setAttachment(null);
            this.getPersistenceBrokerTemplate().store((Object)note);
            attachment.setNoteIdentifier(note.getNoteIdentifier());
            note.setAttachment(attachment);
        }
        this.getPersistenceBrokerTemplate().store((Object)note);
    }

    @Override
    public void deleteNote(Note note) throws DataAccessException {
        this.getPersistenceBrokerTemplate().delete((Object)note.getAttachment());
        note.setAttachment(null);
        this.getPersistenceBrokerTemplate().delete((Object)note);
    }

    @Override
    public List<Note> findByremoteObjectId(String remoteObjectId) {
        Criteria criteria = new Criteria();
        criteria.addEqualTo("RMT_OBJ_ID", (Object)remoteObjectId);
        QueryByCriteria query = QueryFactory.newQuery(Note.class, (Criteria)criteria);
        this.defaultOrderBy(query);
        Collection<Note> notes = this.findCollection((Query)query);
        return new ArrayList<Note>(notes);
    }

    @Override
    public Note getNoteByNoteId(Long noteId) {
        Criteria crit = new Criteria();
        crit.addEqualTo("noteIdentifier", (Object)noteId);
        return (Note)this.getPersistenceBrokerTemplate().getObjectByQuery((Query)new QueryByCriteria(Note.class, crit));
    }

    private void defaultOrderBy(QueryByCriteria query) {
        query.addOrderBy("notePostedTimestamp", true);
    }

    private Collection<Note> findCollection(Query query) throws DataAccessException {
        return this.getPersistenceBrokerTemplate().getCollectionByQuery(query);
    }
}

