/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.krad.datadictionary;

import java.beans.PropertyEditor;
import java.util.List;
import org.apache.commons.lang3.ClassUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.kuali.kfs.kns.datadictionary.control.ControlDefinition;
import org.kuali.kfs.krad.datadictionary.AttributeSecurity;
import org.kuali.kfs.krad.datadictionary.DataDictionaryDefinition;
import org.kuali.kfs.krad.datadictionary.exception.AttributeValidationException;
import org.kuali.kfs.krad.datadictionary.exception.ClassValidationException;
import org.kuali.kfs.krad.datadictionary.validation.ValidationPattern;
import org.kuali.kfs.krad.datadictionary.validation.capability.CaseConstrainable;
import org.kuali.kfs.krad.datadictionary.validation.capability.ExistenceConstrainable;
import org.kuali.kfs.krad.datadictionary.validation.capability.Formatable;
import org.kuali.kfs.krad.datadictionary.validation.capability.HierarchicallyConstrainable;
import org.kuali.kfs.krad.datadictionary.validation.capability.LengthConstrainable;
import org.kuali.kfs.krad.datadictionary.validation.capability.MustOccurConstrainable;
import org.kuali.kfs.krad.datadictionary.validation.capability.PrerequisiteConstrainable;
import org.kuali.kfs.krad.datadictionary.validation.capability.RangeConstrainable;
import org.kuali.kfs.krad.datadictionary.validation.capability.ValidCharactersConstrainable;
import org.kuali.kfs.krad.datadictionary.validation.constraint.CaseConstraint;
import org.kuali.kfs.krad.datadictionary.validation.constraint.MustOccurConstraint;
import org.kuali.kfs.krad.datadictionary.validation.constraint.PrerequisiteConstraint;
import org.kuali.kfs.krad.datadictionary.validation.constraint.ValidCharactersConstraint;
import org.kuali.kfs.krad.keyvalues.KeyValuesFinder;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.rice.core.api.data.DataType;
import org.kuali.rice.core.api.util.ClassLoaderUtils;
import org.kuali.rice.core.web.format.Formatter;

public class AttributeDefinition
extends DataDictionaryDefinition
implements CaseConstrainable,
PrerequisiteConstrainable,
Formatable,
HierarchicallyConstrainable,
MustOccurConstrainable,
LengthConstrainable,
RangeConstrainable,
ValidCharactersConstrainable,
ExistenceConstrainable {
    private static final long serialVersionUID = -2490613377818442742L;
    private Type type = Type.STRING;
    protected Boolean forceUppercase = Boolean.FALSE;
    protected DataType dataType;
    protected Integer minLength;
    protected Integer maxLength;
    protected Boolean unique;
    protected String exclusiveMin;
    protected String inclusiveMax;
    @Deprecated
    protected ValidationPattern validationPattern;
    protected ControlDefinition control;
    protected String formatterClass;
    protected PropertyEditor propertyEditor;
    protected AttributeSecurity attributeSecurity;
    protected Boolean dynamic;
    protected String constraintText;
    protected String description;
    protected String displayLabelAttribute;
    protected String label;
    protected String messageKey;
    protected String name;
    protected Boolean required = Boolean.FALSE;
    protected String shortLabel;
    protected String summary;
    protected String customValidatorClass;
    protected ValidCharactersConstraint validCharactersConstraint;
    protected CaseConstraint caseConstraint;
    protected List<PrerequisiteConstraint> dependencyConstraints;
    protected List<MustOccurConstraint> mustOccurConstraints;
    protected String childEntryName;
    private KeyValuesFinder optionsFinder;
    protected String alternateDisplayAttributeName;
    protected String additionalDisplayAttributeName;

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        if (StringUtils.isBlank((CharSequence)name)) {
            throw new IllegalArgumentException("invalid (blank) name");
        }
        this.name = name;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        if (StringUtils.isBlank((CharSequence)label)) {
            throw new IllegalArgumentException("invalid (blank) label");
        }
        this.label = label;
    }

    public String getShortLabel() {
        return this.shortLabel != null ? this.shortLabel : this.getLabel();
    }

    protected String getDirectShortLabel() {
        return this.shortLabel;
    }

    public void setShortLabel(String shortLabel) {
        if (StringUtils.isBlank((CharSequence)shortLabel)) {
            throw new IllegalArgumentException("invalid (blank) shortLabel");
        }
        this.shortLabel = shortLabel;
    }

    public void setRequired(Boolean required) {
        this.required = required;
    }

    @Override
    public Boolean isRequired() {
        return this.required;
    }

    public String getConstraintText() {
        return this.constraintText;
    }

    public void setConstraintText(String constraintText) {
        this.constraintText = constraintText;
    }

    public String getSummary() {
        return this.summary;
    }

    public void setSummary(String summary) {
        this.summary = summary;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDisplayLabelAttribute() {
        return this.displayLabelAttribute;
    }

    public void setDisplayLabelAttribute(String displayLabelAttribute) {
        this.displayLabelAttribute = displayLabelAttribute;
    }

    public void setForceUppercase(Boolean forceUppercase) {
        this.forceUppercase = forceUppercase;
    }

    public Boolean getForceUppercase() {
        return this.forceUppercase;
    }

    @Override
    public Integer getMaxLength() {
        return this.maxLength;
    }

    public void setMaxLength(Integer maxLength) {
        this.maxLength = maxLength;
    }

    @Override
    public String getExclusiveMin() {
        return this.exclusiveMin;
    }

    public void setExclusiveMin(String exclusiveMin) {
        this.exclusiveMin = exclusiveMin;
    }

    @Override
    public String getInclusiveMax() {
        return this.inclusiveMax;
    }

    public void setInclusiveMax(String inclusiveMax) {
        this.inclusiveMax = inclusiveMax;
    }

    public boolean hasValidationPattern() {
        return this.validationPattern != null;
    }

    public ValidationPattern getValidationPattern() {
        return this.validationPattern;
    }

    public void setValidationPattern(ValidationPattern validationPattern) {
        this.validationPattern = validationPattern;
    }

    public ControlDefinition getControl() {
        return this.control;
    }

    public void setControl(ControlDefinition control) {
        if (control == null) {
            throw new IllegalArgumentException("invalid (null) control");
        }
        this.control = control;
    }

    public boolean hasFormatterClass() {
        return this.formatterClass != null;
    }

    @Override
    public String getFormatterClass() {
        return this.formatterClass;
    }

    public void setFormatterClass(String formatterClass) {
        if (formatterClass == null) {
            throw new IllegalArgumentException("invalid (null) formatterClass");
        }
        this.formatterClass = formatterClass;
    }

    public PropertyEditor getPropertyEditor() {
        return this.propertyEditor;
    }

    public void setPropertyEditor(PropertyEditor propertyEditor) {
        this.propertyEditor = propertyEditor;
    }

    public void setPropertyEditorClass(Class<? extends PropertyEditor> propertyEditorClass) {
        this.propertyEditor = ObjectUtils.newInstance(propertyEditorClass);
    }

    @Override
    public void completeValidation(Class<?> rootObjectClass, Class<?> otherObjectClass) {
        block10: {
            try {
                if (!this.businessObjectDictionaryService.isPropertyOf(rootObjectClass, this.getName())) {
                    throw new AttributeValidationException("property '" + this.getName() + "' is not a property of class '" + rootObjectClass.getName() + "' ()");
                }
                if (this.getControl() == null) {
                    throw new AttributeValidationException("property '" + this.getName() + "' in class '" + rootObjectClass.getName() + " does not have a control defined");
                }
                if (this.getControl() != null) {
                    this.getControl().completeValidation((Class)rootObjectClass, (Class)otherObjectClass);
                }
                if (this.attributeSecurity != null) {
                    this.attributeSecurity.completeValidation((Class)rootObjectClass, (Class)otherObjectClass);
                }
                if (this.validationPattern != null) {
                    this.validationPattern.completeValidation();
                }
                if (this.formatterClass == null) break block10;
                try {
                    Class formatterClassObject = ClassUtils.getClass((ClassLoader)ClassLoaderUtils.getDefaultClassLoader(), (String)this.getFormatterClass());
                    if (!Formatter.class.isAssignableFrom(formatterClassObject)) {
                        throw new ClassValidationException("formatterClass is not a valid instance of " + Formatter.class.getName() + " instead was: " + formatterClassObject.getName());
                    }
                }
                catch (ClassNotFoundException e) {
                    throw new ClassValidationException("formatterClass could not be found: " + this.getFormatterClass(), e);
                }
            }
            catch (RuntimeException ex) {
                LogManager.getLogger(this.getClass()).error("Unable to validate attribute " + rootObjectClass + "." + this.getName() + ": " + ex.getMessage(), (Throwable)ex);
                throw ex;
            }
        }
    }

    public String toString() {
        return "AttributeDefinition for attribute " + this.getName();
    }

    public AttributeSecurity getAttributeSecurity() {
        return this.attributeSecurity;
    }

    @Override
    public void afterPropertiesSet() {
        if (StringUtils.isEmpty((CharSequence)this.name)) {
            throw new RuntimeException("blank name for bean: " + this.id);
        }
    }

    public void setAttributeSecurity(AttributeSecurity attributeSecurity) {
        this.attributeSecurity = attributeSecurity;
    }

    public boolean hasAttributeSecurity() {
        return this.attributeSecurity != null;
    }

    public Boolean getUnique() {
        return this.unique;
    }

    public void setUnique(Boolean unique) {
        this.unique = unique;
    }

    @Override
    public Integer getMinLength() {
        return this.minLength;
    }

    public void setMinLength(Integer minLength) {
        this.minLength = minLength;
    }

    @Override
    public DataType getDataType() {
        return this.dataType;
    }

    public void setDataType(DataType dataType) {
        this.dataType = dataType;
    }

    public void setDataType(String dataType) {
        this.dataType = DataType.valueOf((String)dataType);
    }

    public String getCustomValidatorClass() {
        return this.customValidatorClass;
    }

    public void setCustomValidatorClass(String customValidatorClass) {
        this.customValidatorClass = customValidatorClass;
    }

    @Override
    public ValidCharactersConstraint getValidCharactersConstraint() {
        return this.validCharactersConstraint;
    }

    public void setValidCharactersConstraint(ValidCharactersConstraint validCharactersConstraint) {
        this.validCharactersConstraint = validCharactersConstraint;
    }

    @Override
    public CaseConstraint getCaseConstraint() {
        return this.caseConstraint;
    }

    public void setCaseConstraint(CaseConstraint caseConstraint) {
        this.caseConstraint = caseConstraint;
    }

    @Override
    public List<PrerequisiteConstraint> getPrerequisiteConstraints() {
        return this.dependencyConstraints;
    }

    public void setPrerequisiteConstraints(List<PrerequisiteConstraint> dependencyConstraints) {
        this.dependencyConstraints = dependencyConstraints;
    }

    @Override
    public List<MustOccurConstraint> getMustOccurConstraints() {
        return this.mustOccurConstraints;
    }

    public void setMustOccurConstraints(List<MustOccurConstraint> mustOccurConstraints) {
        this.mustOccurConstraints = mustOccurConstraints;
    }

    @Override
    public String getChildEntryName() {
        return this.childEntryName;
    }

    public void setChildEntryName(String childEntryName) {
        this.childEntryName = childEntryName;
    }

    public KeyValuesFinder getOptionsFinder() {
        return this.optionsFinder;
    }

    public void setOptionsFinder(KeyValuesFinder optionsFinder) {
        this.optionsFinder = optionsFinder;
    }

    public void setOptionsFinderClass(Class<? extends KeyValuesFinder> optionsFinderClass) {
        this.optionsFinder = ObjectUtils.newInstance(optionsFinderClass);
    }

    public void setAdditionalDisplayAttributeName(String additionalDisplayAttributeName) {
        this.additionalDisplayAttributeName = additionalDisplayAttributeName;
    }

    public String getAdditionalDisplayAttributeName() {
        return this.additionalDisplayAttributeName;
    }

    public void setAlternateDisplayAttributeName(String alternateDisplayAttributeName) {
        this.alternateDisplayAttributeName = alternateDisplayAttributeName;
    }

    public String getAlternateDisplayAttributeName() {
        return this.alternateDisplayAttributeName;
    }

    public Type getType() {
        return this.type;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public static enum Type {
        BOOLEAN,
        CURRENCY,
        DATE_RANGE,
        DATE_TIME,
        DECIMAL,
        INTEGER,
        LONG,
        STRING,
        LINK,
        OTHER;

    }
}

