/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.krad.datadictionary;

import java.util.List;
import org.kuali.kfs.kns.service.DataDictionaryService;
import org.kuali.kfs.kns.service.KNSServiceLocator;
import org.kuali.rice.core.api.config.ConfigurationException;
import org.springframework.beans.factory.InitializingBean;

public class DataDictionaryLocationConfigurer
implements InitializingBean {
    private List<String> dataDictionaryPackages;
    private DataDictionaryService dataDictionaryService;

    public DataDictionaryLocationConfigurer(DataDictionaryService dataDictionaryService) {
        this.dataDictionaryService = dataDictionaryService;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.dataDictionaryPackages == null || this.dataDictionaryPackages.isEmpty()) {
            throw new ConfigurationException("dataDictionaryPackages empty when initializing DataDictionaryLocation bean.");
        }
        if (this.dataDictionaryService != null) {
            this.dataDictionaryService.addDataDictionaryLocations(this.getDataDictionaryPackages());
        } else {
            KNSServiceLocator.getDataDictionaryService().addDataDictionaryLocations(this.getDataDictionaryPackages());
        }
    }

    public List<String> getDataDictionaryPackages() {
        return this.dataDictionaryPackages;
    }

    public void setDataDictionaryPackages(List<String> dataDictionaryPackages) {
        this.dataDictionaryPackages = dataDictionaryPackages;
    }
}

