/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.krad.datadictionary.validation;

import java.util.List;
import org.kuali.kfs.krad.datadictionary.exception.AttributeValidationException;
import org.kuali.kfs.krad.datadictionary.validation.AttributeValueReader;
import org.kuali.kfs.krad.util.DataTypeUtil;
import org.kuali.rice.core.framework.persistence.jdbc.sql.SQLUtils;

public abstract class BaseAttributeValueReader
implements AttributeValueReader {
    protected String entryName;
    protected String attributeName;

    @Override
    public List<String> getCleanSearchableValues(String attributeKey) throws AttributeValidationException {
        Class<?> attributeType = this.getType(attributeKey);
        Object rawValue = this.getValue(attributeKey);
        String attributeInValue = rawValue != null ? rawValue.toString() : "";
        String attributeDataType = DataTypeUtil.determineDataType(attributeType);
        return SQLUtils.getCleanedSearchableValues((String)attributeInValue, (String)attributeDataType);
    }

    @Override
    public String getAttributeName() {
        return this.attributeName;
    }

    @Override
    public void setAttributeName(String currentName) {
        this.attributeName = currentName;
    }

    @Override
    public String getEntryName() {
        return this.entryName;
    }

    @Override
    public abstract AttributeValueReader clone();
}

