/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.krad.datadictionary.validation.processor;

import org.kuali.kfs.krad.datadictionary.exception.AttributeValidationException;
import org.kuali.kfs.krad.datadictionary.validation.AttributeValueReader;
import org.kuali.kfs.krad.datadictionary.validation.ValidationUtils;
import org.kuali.kfs.krad.datadictionary.validation.constraint.Constraint;
import org.kuali.kfs.krad.datadictionary.validation.constraint.DataTypeConstraint;
import org.kuali.kfs.krad.datadictionary.validation.processor.MandatoryElementConstraintProcessor;
import org.kuali.kfs.krad.datadictionary.validation.result.ConstraintValidationResult;
import org.kuali.kfs.krad.datadictionary.validation.result.DictionaryValidationResult;
import org.kuali.kfs.krad.datadictionary.validation.result.ProcessorResult;
import org.kuali.rice.core.api.data.DataType;

public class DataTypeConstraintProcessor
extends MandatoryElementConstraintProcessor<DataTypeConstraint> {
    private static final String CONSTRAINT_NAME = "data type constraint";

    @Override
    public ProcessorResult process(DictionaryValidationResult result, Object value, DataTypeConstraint constraint, AttributeValueReader attributeValueReader) throws AttributeValidationException {
        DataType dataType = constraint.getDataType();
        return new ProcessorResult(this.processDataTypeConstraint(result, dataType, value, attributeValueReader));
    }

    @Override
    public String getName() {
        return CONSTRAINT_NAME;
    }

    @Override
    public Class<? extends Constraint> getConstraintType() {
        return DataTypeConstraint.class;
    }

    protected ConstraintValidationResult processDataTypeConstraint(DictionaryValidationResult result, DataType dataType, Object value, AttributeValueReader attributeValueReader) {
        if (dataType == null) {
            return result.addNoConstraint(attributeValueReader, CONSTRAINT_NAME);
        }
        if (ValidationUtils.isNullOrEmpty(value)) {
            return result.addSkipped(attributeValueReader, CONSTRAINT_NAME);
        }
        try {
            ValidationUtils.convertToDataType(value, dataType, this.dateTimeService);
        }
        catch (Exception e) {
            switch (dataType) {
                case BOOLEAN: {
                    return result.addError(attributeValueReader, CONSTRAINT_NAME, "error.invalidBoolean", new String[0]);
                }
                case INTEGER: {
                    return result.addError(attributeValueReader, CONSTRAINT_NAME, "error.integer", new String[0]);
                }
                case LONG: {
                    return result.addError(attributeValueReader, CONSTRAINT_NAME, "error.long", new String[0]);
                }
                case DOUBLE: {
                    return result.addError(attributeValueReader, CONSTRAINT_NAME, "error.bigDecimal", new String[0]);
                }
                case FLOAT: {
                    return result.addError(attributeValueReader, CONSTRAINT_NAME, "error.bigDecimal", new String[0]);
                }
                case TRUNCATED_DATE: 
                case DATE: {
                    return result.addError(attributeValueReader, CONSTRAINT_NAME, "error.bigDecimal", new String[0]);
                }
            }
        }
        return result.addSuccess(attributeValueReader, CONSTRAINT_NAME);
    }
}

