/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.krad.document;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.MappedSuperclass;
import javax.persistence.OneToOne;
import javax.persistence.Transient;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.kfs.kns.datadictionary.DocumentEntry;
import org.kuali.kfs.kns.service.KNSServiceLocator;
import org.kuali.kfs.krad.bo.AdHocRoutePerson;
import org.kuali.kfs.krad.bo.AdHocRouteWorkgroup;
import org.kuali.kfs.krad.bo.DocumentHeader;
import org.kuali.kfs.krad.bo.Note;
import org.kuali.kfs.krad.bo.PersistableBusinessObject;
import org.kuali.kfs.krad.bo.PersistableBusinessObjectBase;
import org.kuali.kfs.krad.datadictionary.WorkflowAttributes;
import org.kuali.kfs.krad.datadictionary.WorkflowProperties;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.krad.document.TransactionalDocument;
import org.kuali.kfs.krad.exception.ValidationException;
import org.kuali.kfs.krad.rules.rule.event.KualiDocumentEvent;
import org.kuali.kfs.krad.service.AttachmentService;
import org.kuali.kfs.krad.service.DocumentSerializerService;
import org.kuali.kfs.krad.service.KRADServiceLocator;
import org.kuali.kfs.krad.service.KRADServiceLocatorWeb;
import org.kuali.kfs.krad.service.NoteService;
import org.kuali.kfs.krad.util.ErrorMessage;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.krad.util.NoteType;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.krad.util.documentserializer.AlwaysFalsePropertySerializabilityEvaluator;
import org.kuali.kfs.krad.util.documentserializer.AlwaysTruePropertySerializibilityEvaluator;
import org.kuali.kfs.krad.util.documentserializer.BusinessObjectPropertySerializibilityEvaluator;
import org.kuali.kfs.krad.util.documentserializer.PropertySerializabilityEvaluator;
import org.kuali.kfs.krad.workflow.DocumentInitiator;
import org.kuali.kfs.krad.workflow.KualiDocumentXmlMaterializer;
import org.kuali.kfs.krad.workflow.KualiTransactionalDocumentInformation;
import org.kuali.rice.kew.api.KewApiServiceLocator;
import org.kuali.rice.kew.api.action.ActionType;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.kuali.rice.kew.framework.postprocessor.ActionTakenEvent;
import org.kuali.rice.kew.framework.postprocessor.DocumentRouteLevelChange;
import org.kuali.rice.kew.framework.postprocessor.DocumentRouteStatusChange;
import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.kim.api.services.KimApiServiceLocator;
import org.springframework.util.AutoPopulatingList;
import org.springframework.util.CollectionUtils;

@MappedSuperclass
public abstract class DocumentBase
extends PersistableBusinessObjectBase
implements Document {
    private static final Logger LOG = LogManager.getLogger(DocumentBase.class);
    @Id
    @Column(name="DOC_HDR_ID")
    protected String documentNumber;
    @OneToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    @JoinColumn(name="DOC_HDR_ID", insertable=false, updatable=false)
    protected DocumentHeader documentHeader;
    @Transient
    private List<AdHocRoutePerson> adHocRoutePersons;
    @Transient
    private List<AdHocRouteWorkgroup> adHocRouteWorkgroups;
    @Transient
    private List<Note> notes;
    private transient NoteService noteService;
    private transient AttachmentService attachmentService;

    public DocumentBase() {
        try {
            Class<? extends DocumentHeader> documentHeaderClass = KRADServiceLocatorWeb.getDocumentHeaderService().getDocumentHeaderBaseClass();
            this.setDocumentHeader(documentHeaderClass.newInstance());
            this.adHocRoutePersons = new ArrayList<AdHocRoutePerson>();
            this.adHocRouteWorkgroups = new ArrayList<AdHocRouteWorkgroup>();
            this.notes = new ArrayList<Note>();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new RuntimeException("Error instantiating DocumentHeader", e);
        }
    }

    @Override
    public boolean getAllowsCopy() {
        return false;
    }

    @Override
    public String getDocumentTitle() {
        String description;
        String documentTypeLabel = KewApiServiceLocator.getDocumentTypeService().getDocumentTypeByName(this.getDocumentHeader().getWorkflowDocument().getDocumentTypeName()).getLabel();
        if (null == documentTypeLabel) {
            documentTypeLabel = "";
        }
        if (null == (description = this.getDocumentHeader().getDocumentDescription())) {
            description = "";
        }
        return documentTypeLabel + " - " + description;
    }

    @Override
    public void refresh() {
        KRADServiceLocator.getPersistenceService().retrieveNonKeyFields(this);
    }

    public void refreshIfEmpty() {
        if (null == this.getDocumentHeader()) {
            this.refresh();
        } else if (StringUtils.isEmpty((CharSequence)this.getDocumentHeader().getObjectId())) {
            this.refresh();
        }
    }

    @Override
    public void refreshReferenceObject(String referenceObjectName) {
        KRADServiceLocator.getPersistenceService().retrieveReferenceObject(this, referenceObjectName);
    }

    @Override
    public void prepareForSave() {
    }

    @Override
    public void prepareForSave(KualiDocumentEvent event) {
    }

    @Override
    public void processAfterRetrieve() {
    }

    @Override
    public void doRouteLevelChange(DocumentRouteLevelChange levelChangeEvent) {
    }

    @Override
    public void doActionTaken(ActionTakenEvent event) {
    }

    @Override
    public void afterActionTaken(ActionType performed, ActionTakenEvent event) {
    }

    protected List<String> getNonLockingActionTakenCodes() {
        ArrayList<String> actionTakenStatusCodes = new ArrayList<String>();
        actionTakenStatusCodes.add("S");
        actionTakenStatusCodes.add("K");
        actionTakenStatusCodes.add("F");
        actionTakenStatusCodes.add("D");
        actionTakenStatusCodes.add("X");
        actionTakenStatusCodes.add("R");
        return actionTakenStatusCodes;
    }

    @Override
    public void afterWorkflowEngineProcess(boolean successfullyProcessed) {
    }

    @Override
    public void beforeWorkflowEngineProcess() {
    }

    @Override
    public List<String> getWorkflowEngineDocumentIdsToLock() {
        return null;
    }

    public void toCopy() throws WorkflowException, IllegalStateException {
        if (!this.getAllowsCopy()) {
            throw new IllegalStateException(this.getClass().getName() + " does not support document-level copying");
        }
        String sourceDocumentHeaderId = this.getDocumentNumber();
        this.setNewDocumentHeader();
        this.getDocumentHeader().setDocumentTemplateNumber(sourceDocumentHeaderId);
        this.notes.clear();
        this.addCopyErrorDocumentNote("copied from document " + sourceDocumentHeaderId);
    }

    protected void setNewDocumentHeader() throws WorkflowException {
        TransactionalDocument newDoc = (TransactionalDocument)KRADServiceLocatorWeb.getDocumentService().getNewDocument(this.getDocumentHeader().getWorkflowDocument().getDocumentTypeName());
        newDoc.getDocumentHeader().setDocumentDescription(this.getDocumentHeader().getDocumentDescription());
        newDoc.getDocumentHeader().setOrganizationDocumentNumber(this.getDocumentHeader().getOrganizationDocumentNumber());
        try {
            ObjectUtils.setObjectPropertyDeep(this, "documentNumber", this.documentNumber.getClass(), newDoc.getDocumentNumber());
        }
        catch (Exception e) {
            LOG.error("Unable to set document number property in copied document " + e.getMessage(), (Throwable)e);
            throw new RuntimeException("Unable to set document number property in copied document " + e.getMessage(), e);
        }
        this.setDocumentHeader(newDoc.getDocumentHeader());
    }

    protected void addCopyErrorDocumentNote(String noteText) {
        Note note;
        try {
            note = KRADServiceLocatorWeb.getDocumentService().createNoteFromDocument(this, noteText);
        }
        catch (Exception e) {
            this.logErrors();
            throw new RuntimeException("Couldn't create note on copy or error", e);
        }
        this.addNote(note);
    }

    @Override
    public String getXmlForRouteReport() {
        this.prepareForSave();
        this.populateDocumentForRouting();
        return this.getDocumentHeader().getWorkflowDocument().getApplicationContent();
    }

    @Override
    public void populateDocumentForRouting() {
        this.getDocumentHeader().getWorkflowDocument().setApplicationContent(this.serializeDocumentToXml());
    }

    @Override
    public String serializeDocumentToXml() {
        DocumentSerializerService documentSerializerService = KRADServiceLocatorWeb.getDocumentSerializerService();
        return documentSerializerService.serializeDocumentToXmlForRouting(this);
    }

    @Override
    public KualiDocumentXmlMaterializer wrapDocumentWithMetadataForXmlSerialization() {
        KualiTransactionalDocumentInformation transInfo = new KualiTransactionalDocumentInformation();
        DocumentInitiator initiator = new DocumentInitiator();
        String initiatorPrincipalId = this.getDocumentHeader().getWorkflowDocument().getDocument().getInitiatorPrincipalId();
        Person initiatorUser = KimApiServiceLocator.getPersonService().getPerson(initiatorPrincipalId);
        initiator.setPerson(initiatorUser);
        transInfo.setDocumentInitiator(initiator);
        KualiDocumentXmlMaterializer xmlWrapper = new KualiDocumentXmlMaterializer();
        xmlWrapper.setDocument(this);
        xmlWrapper.setKualiTransactionalDocumentInformation(transInfo);
        return xmlWrapper;
    }

    @Override
    public PropertySerializabilityEvaluator getDocumentPropertySerizabilityEvaluator() {
        String docTypeName = this.getDocumentHeader().getWorkflowDocument().getDocumentTypeName();
        DocumentEntry documentEntry = KNSServiceLocator.getDataDictionaryService().getDataDictionary().getDocumentEntry(docTypeName);
        WorkflowProperties workflowProperties = documentEntry.getWorkflowProperties();
        WorkflowAttributes workflowAttributes = documentEntry.getWorkflowAttributes();
        return this.createPropertySerializabilityEvaluator(workflowProperties, workflowAttributes);
    }

    protected PropertySerializabilityEvaluator createPropertySerializabilityEvaluator(WorkflowProperties workflowProperties, WorkflowAttributes workflowAttributes) {
        if (workflowAttributes != null) {
            return new AlwaysFalsePropertySerializabilityEvaluator();
        }
        if (workflowProperties == null) {
            return new AlwaysTruePropertySerializibilityEvaluator();
        }
        BusinessObjectPropertySerializibilityEvaluator evaluator = new BusinessObjectPropertySerializibilityEvaluator();
        evaluator.initializeEvaluatorForDocument(this);
        return evaluator;
    }

    @Override
    public String getBasePathToDocumentDuringSerialization() {
        return "document";
    }

    @Override
    public DocumentHeader getDocumentHeader() {
        return this.documentHeader;
    }

    @Override
    public void setDocumentHeader(DocumentHeader documentHeader) {
        this.documentHeader = documentHeader;
    }

    @Override
    public String getDocumentNumber() {
        return this.documentNumber;
    }

    @Override
    public void setDocumentNumber(String documentNumber) {
        this.documentNumber = documentNumber;
    }

    @Override
    public List<AdHocRoutePerson> getAdHocRoutePersons() {
        return this.adHocRoutePersons;
    }

    @Override
    public void setAdHocRoutePersons(List<AdHocRoutePerson> adHocRoutePersons) {
        this.adHocRoutePersons = adHocRoutePersons;
    }

    @Override
    public List<AdHocRouteWorkgroup> getAdHocRouteWorkgroups() {
        return this.adHocRouteWorkgroups;
    }

    @Override
    public void setAdHocRouteWorkgroups(List<AdHocRouteWorkgroup> adHocRouteWorkgroups) {
        this.adHocRouteWorkgroups = adHocRouteWorkgroups;
    }

    @Override
    public void postProcessSave(KualiDocumentEvent event) {
    }

    @Override
    public void validateBusinessRules(KualiDocumentEvent event) {
        if (GlobalVariables.getMessageMap().hasErrors()) {
            this.logErrors();
            throw new ValidationException("errors occurred before business rule");
        }
        LOG.info("invoking rules engine on document " + this.getDocumentNumber());
        boolean isValid = KRADServiceLocatorWeb.getKualiRuleService().applyRules(event);
        if (!isValid) {
            this.logErrors();
            throw new ValidationException("business rule evaluation failed");
        }
        if (GlobalVariables.getMessageMap().hasErrors()) {
            this.logErrors();
            throw new ValidationException("Unreported errors occurred during business rule evaluation (rule developer needs to put meaningful error messages into global ErrorMap)");
        }
        LOG.debug("validation completed");
    }

    public void logErrors() {
        if (LOG.isInfoEnabled() && GlobalVariables.getMessageMap().hasErrors()) {
            for (Map.Entry<String, AutoPopulatingList<ErrorMessage>> e : GlobalVariables.getMessageMap().getAllPropertiesAndErrors()) {
                StringBuffer logMessage = new StringBuffer();
                logMessage.append("[").append(e.getKey()).append("] ");
                boolean first = true;
                AutoPopulatingList<ErrorMessage> errorList = e.getValue();
                for (ErrorMessage em : errorList) {
                    if (first) {
                        first = false;
                    } else {
                        logMessage.append(";");
                    }
                    logMessage.append(em);
                }
                LOG.info((CharSequence)logMessage);
            }
        }
    }

    @Override
    public List<KualiDocumentEvent> generateSaveEvents() {
        return new ArrayList<KualiDocumentEvent>();
    }

    @Override
    public void doRouteStatusChange(DocumentRouteStatusChange statusChangeEvent) {
    }

    @Override
    public PersistableBusinessObject getNoteTarget() {
        return this.getDocumentHeader();
    }

    @Override
    public NoteType getNoteType() {
        return NoteType.DOCUMENT_HEADER;
    }

    @Override
    public void addNote(Note note) {
        if (note == null) {
            throw new IllegalArgumentException("Note cannot be null.");
        }
        this.notes.add(note);
    }

    @Override
    public boolean removeNote(Note note) {
        if (note == null) {
            throw new IllegalArgumentException("Note cannot be null.");
        }
        return this.notes.remove(note);
    }

    @Override
    public Note getNote(int index) {
        return this.notes.get(index);
    }

    @Override
    public List<Note> getNotes() {
        if (CollectionUtils.isEmpty(this.notes) && this.getNoteType().equals((Object)NoteType.BUSINESS_OBJECT) && StringUtils.isNotBlank((CharSequence)this.getNoteTarget().getObjectId())) {
            this.notes = this.getNoteService().getByRemoteObjectId(this.getNoteTarget().getObjectId());
        }
        return this.notes;
    }

    @Override
    public void setNotes(List<Note> notes) {
        if (notes == null) {
            throw new IllegalArgumentException("List of notes must be non-null.");
        }
        this.notes = notes;
    }

    @Override
    protected void postLoad() {
        super.postLoad();
    }

    @Override
    public List<String> getLockClearningMethodNames() {
        ArrayList<String> methodToCalls = new ArrayList<String>();
        methodToCalls.add("close");
        methodToCalls.add("cancel");
        methodToCalls.add("route");
        methodToCalls.add("approve");
        methodToCalls.add("disapprove");
        methodToCalls.add("acknowledge");
        return methodToCalls;
    }

    protected AttachmentService getAttachmentService() {
        if (this.attachmentService == null) {
            this.attachmentService = KRADServiceLocator.getAttachmentService();
        }
        return this.attachmentService;
    }

    protected NoteService getNoteService() {
        if (this.noteService == null) {
            this.noteService = KRADServiceLocator.getNoteService();
        }
        return this.noteService;
    }
}

