/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.krad.service.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import org.kuali.kfs.coreservice.api.CoreServiceApiServiceLocator;
import org.kuali.kfs.coreservice.api.namespace.Namespace;
import org.kuali.kfs.coreservice.framework.parameter.ParameterConstants;
import org.kuali.kfs.kns.bo.Step;
import org.kuali.kfs.krad.document.TransactionalDocument;
import org.kuali.kfs.krad.service.KualiModuleService;
import org.kuali.kfs.krad.service.ModuleService;
import org.kuali.kfs.krad.service.ModuleServiceNotFoundException;
import org.kuali.kfs.krad.service.impl.QuinoaModuleServiceAdapter;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.rice.core.api.resourceloader.GlobalResourceLoader;
import org.kuali.rice.krad.bo.BusinessObject;
import org.kuali.rice.krad.bo.ExternalizableBusinessObject;
import org.kuali.rice.krad.service.KRADServiceLocatorWeb;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class KualiModuleServiceImpl
implements KualiModuleService,
InitializingBean,
ApplicationContextAware {
    private List<ModuleService> installedModuleServices = new ArrayList<ModuleService>();
    private boolean loadRiceInstalledModuleServices;
    private ApplicationContext applicationContext;
    private ConcurrentHashMap<Class, ModuleService> responsibleModuleServices = new ConcurrentHashMap();

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    @Override
    public List<ModuleService> getInstalledModuleServices() {
        return this.installedModuleServices;
    }

    @Override
    public ModuleService getModuleService(String moduleId) {
        for (ModuleService moduleService : this.installedModuleServices) {
            if (!moduleService.getModuleConfiguration().getNamespaceCode().equals(moduleId)) continue;
            return moduleService;
        }
        return this.getQuinoaModuleService(kualiModuleService -> kualiModuleService.getModuleService(moduleId));
    }

    @Override
    public ModuleService getModuleServiceByNamespaceCode(String namespaceCode) {
        for (ModuleService moduleService : this.installedModuleServices) {
            if (!moduleService.getModuleConfiguration().getNamespaceCode().equals(namespaceCode)) continue;
            return moduleService;
        }
        return this.getQuinoaModuleService(kualiModuleService -> kualiModuleService.getModuleServiceByNamespaceCode(namespaceCode));
    }

    @Override
    public boolean isModuleServiceInstalled(String namespaceCode) {
        for (ModuleService moduleService : this.installedModuleServices) {
            if (!moduleService.getModuleConfiguration().getNamespaceCode().equals(namespaceCode)) continue;
            return true;
        }
        org.kuali.rice.krad.service.KualiModuleService quinoaKualiModuleService = KRADServiceLocatorWeb.getKualiModuleService();
        return quinoaKualiModuleService.isModuleServiceInstalled(namespaceCode);
    }

    @Override
    public ModuleService getResponsibleModuleService(Class boClass) {
        if (boClass == null) {
            return null;
        }
        if (this.responsibleModuleServices.containsKey(boClass)) {
            return this.responsibleModuleServices.get(boClass);
        }
        for (ModuleService moduleService : this.installedModuleServices) {
            if (!moduleService.isResponsibleFor(boClass)) continue;
            this.responsibleModuleServices.put(boClass, moduleService);
            return moduleService;
        }
        ModuleService allBranTranslatedModuleService = this.getQuinoaModuleService(kualiModuleService -> {
            org.kuali.rice.krad.service.ModuleService moduleService = null;
            try {
                moduleService = kualiModuleService.getResponsibleModuleService(boClass);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return moduleService;
        });
        if (!ObjectUtils.isNull(allBranTranslatedModuleService)) {
            return allBranTranslatedModuleService;
        }
        if (ExternalizableBusinessObject.class.isAssignableFrom(boClass)) {
            String message = !boClass.isInterface() ? "There is no responsible module for the externalized business object class: " + boClass : "There is no responsible module for the externalized business object interface: " + boClass;
            throw new ModuleServiceNotFoundException(message);
        }
        return null;
    }

    protected ModuleService getQuinoaModuleService(Function<org.kuali.rice.krad.service.KualiModuleService, org.kuali.rice.krad.service.ModuleService> action) {
        org.kuali.rice.krad.service.KualiModuleService quinoaKualiModuleService = KRADServiceLocatorWeb.getKualiModuleService();
        org.kuali.rice.krad.service.ModuleService quinoaModuleService = action.apply(quinoaKualiModuleService);
        if (!ObjectUtils.isNull(quinoaModuleService)) {
            return new QuinoaModuleServiceAdapter(quinoaModuleService);
        }
        return null;
    }

    @Override
    public ModuleService getResponsibleModuleServiceForJob(String jobName) {
        for (ModuleService moduleService : this.installedModuleServices) {
            if (!moduleService.isResponsibleForJob(jobName)) continue;
            return moduleService;
        }
        return null;
    }

    @Override
    public void setInstalledModuleServices(List<ModuleService> installedModuleServices) {
        this.installedModuleServices = installedModuleServices;
    }

    @Override
    public List<String> getDataDictionaryPackages() {
        ArrayList<String> packages = new ArrayList<String>();
        for (ModuleService moduleService : this.installedModuleServices) {
            if (moduleService.getModuleConfiguration().getDataDictionaryPackages() == null) continue;
            packages.addAll(moduleService.getModuleConfiguration().getDataDictionaryPackages());
        }
        return packages;
    }

    @Override
    public String getNamespaceName(String namespaceCode) {
        Namespace parameterNamespace = CoreServiceApiServiceLocator.getNamespaceService().getNamespace(namespaceCode);
        return parameterNamespace == null ? "" : parameterNamespace.getName();
    }

    public void setLoadRiceInstalledModuleServices(boolean loadRiceInstalledModuleServices) {
        this.loadRiceInstalledModuleServices = loadRiceInstalledModuleServices;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.loadRiceInstalledModuleServices) {
            try {
                this.installedModuleServices.addAll(((KualiModuleService)GlobalResourceLoader.getService((String)(KualiModuleService.class.getSimpleName().substring(0, 1).toLowerCase() + KualiModuleService.class.getSimpleName().substring(1)))).getInstalledModuleServices());
            }
            catch (NoSuchBeanDefinitionException ex) {
                this.installedModuleServices.addAll(((KualiModuleService)this.applicationContext.getBean("cf.kualiModuleService")).getInstalledModuleServices());
            }
        }
    }

    @Override
    public String getNamespaceCode(Class<?> documentClass) {
        if (documentClass == null) {
            throw new IllegalArgumentException("documentClass must not be null");
        }
        if (documentClass.isAnnotationPresent(ParameterConstants.NAMESPACE.class)) {
            return documentClass.getAnnotation(ParameterConstants.NAMESPACE.class).namespace();
        }
        ModuleService moduleService = this.getResponsibleModuleService(documentClass);
        if (moduleService != null) {
            return moduleService.getModuleConfiguration().getNamespaceCode();
        }
        if (documentClass.getName().startsWith("org.kuali.rice.krad")) {
            return "KR-NS";
        }
        if (documentClass.getName().startsWith("org.kuali.rice.edl")) {
            return "KR-EDL";
        }
        if (documentClass.getName().startsWith("org.kuali.rice.kew")) {
            return "KR-WKFLW";
        }
        if (documentClass.getName().startsWith("org.kuali.rice.edl")) {
            return "KR-WKFLW";
        }
        if (documentClass.getName().startsWith("org.kuali.rice.kim")) {
            return "KR-IDM";
        }
        if (documentClass.getName().startsWith("org.kuali.rice.core")) {
            return "KR-CORE";
        }
        throw new IllegalArgumentException("Unable to determine the namespace code for documentClass " + documentClass.getName());
    }

    @Override
    public String getComponentCode(Class<?> documentClass) {
        if (documentClass == null) {
            throw new IllegalArgumentException("documentClass must not be null");
        }
        if (documentClass.isAnnotationPresent(ParameterConstants.COMPONENT.class)) {
            return documentClass.getAnnotation(ParameterConstants.COMPONENT.class).component();
        }
        if (TransactionalDocument.class.isAssignableFrom(documentClass)) {
            return documentClass.getSimpleName().replace("Document", "");
        }
        if (BusinessObject.class.isAssignableFrom(documentClass)) {
            return documentClass.getSimpleName();
        }
        if (Step.class.isAssignableFrom(documentClass)) {
            return documentClass.getSimpleName();
        }
        throw new IllegalArgumentException("Unable to determine the component code for documentClass " + documentClass.getName());
    }

    @Override
    public boolean isBusinessObjectExternal(String boClassName) {
        if (boClassName == null) {
            return false;
        }
        if (boClassName.startsWith("org.kuali.rice")) {
            return true;
        }
        try {
            Class<?> boClass = Class.forName(boClassName);
            return this.getResponsibleModuleService(boClass).isExternal(boClass);
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }
}

