/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.kns.service.impl;

import org.apache.commons.lang3.StringUtils;
import org.kuali.kfs.kns.datadictionary.DocumentEntry;
import org.kuali.kfs.kns.datadictionary.MaintenanceDocumentEntry;
import org.kuali.kfs.kns.datadictionary.TransactionalDocumentEntry;
import org.kuali.kfs.kns.document.authorization.DocumentAuthorizer;
import org.kuali.kfs.kns.document.authorization.DocumentAuthorizerBase;
import org.kuali.kfs.kns.document.authorization.MaintenanceDocumentAuthorizerBase;
import org.kuali.kfs.kns.document.authorization.MaintenanceDocumentPresentationControllerBase;
import org.kuali.kfs.kns.document.authorization.TransactionalDocumentAuthorizerBase;
import org.kuali.kfs.kns.document.authorization.TransactionalDocumentPresentationControllerBase;
import org.kuali.kfs.kns.service.DocumentHelperService;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.krad.document.DocumentPresentationController;
import org.kuali.kfs.krad.document.DocumentPresentationControllerBase;
import org.kuali.kfs.krad.service.DocumentDictionaryService;
import org.kuali.kfs.krad.service.KRADServiceLocatorWeb;

public class DocumentHelperServiceImpl
implements DocumentHelperService {
    @Override
    public DocumentAuthorizer getDocumentAuthorizer(String documentType) {
        DocumentAuthorizer documentAuthorizer;
        if (StringUtils.isBlank((CharSequence)documentType)) {
            throw new IllegalArgumentException("invalid (blank) documentType");
        }
        DocumentEntry documentEntry = this.getDocumentDictionaryService().getDocumentEntry(documentType);
        if (documentEntry == null) {
            throw new IllegalArgumentException("unknown documentType '" + documentType + "'");
        }
        Class<? extends org.kuali.kfs.krad.document.DocumentAuthorizer> documentAuthorizerClass = documentEntry.getDocumentAuthorizerClass();
        try {
            documentAuthorizer = documentAuthorizerClass != null ? (DocumentAuthorizer)documentAuthorizerClass.newInstance() : (documentEntry instanceof MaintenanceDocumentEntry ? new MaintenanceDocumentAuthorizerBase() : (documentEntry instanceof TransactionalDocumentEntry ? new TransactionalDocumentAuthorizerBase() : new DocumentAuthorizerBase()));
        }
        catch (Exception e) {
            throw new RuntimeException("unable to instantiate documentAuthorizer '" + documentAuthorizerClass.getName() + "' for doctype '" + documentType + "'", e);
        }
        return documentAuthorizer;
    }

    @Override
    public DocumentAuthorizer getDocumentAuthorizer(Document document) {
        if (document == null) {
            throw new IllegalArgumentException("invalid (null) document");
        }
        if (document.getDocumentHeader() == null) {
            throw new IllegalArgumentException("invalid (null) document.documentHeader");
        }
        if (!document.getDocumentHeader().hasWorkflowDocument()) {
            throw new IllegalArgumentException("invalid (null) document.documentHeader.workflowDocument");
        }
        String documentType = document.getDocumentHeader().getWorkflowDocument().getDocumentTypeName();
        return this.getDocumentAuthorizer(documentType);
    }

    @Override
    public DocumentPresentationController getDocumentPresentationController(String documentType) {
        DocumentPresentationController documentPresentationController;
        if (StringUtils.isBlank((CharSequence)documentType)) {
            throw new IllegalArgumentException("invalid (blank) documentType");
        }
        DocumentEntry documentEntry = this.getDocumentDictionaryService().getDocumentEntry(documentType);
        if (documentEntry == null) {
            throw new IllegalArgumentException("unknown documentType '" + documentType + "'");
        }
        Class<? extends DocumentPresentationController> documentPresentationControllerClass = null;
        try {
            DocumentEntry doc;
            documentPresentationControllerClass = documentEntry.getDocumentPresentationControllerClass();
            documentPresentationController = documentPresentationControllerClass != null ? documentPresentationControllerClass.newInstance() : ((doc = this.getDocumentDictionaryService().getDocumentEntry(documentType)) instanceof TransactionalDocumentEntry ? new TransactionalDocumentPresentationControllerBase() : (doc instanceof MaintenanceDocumentEntry ? new MaintenanceDocumentPresentationControllerBase() : new DocumentPresentationControllerBase()));
        }
        catch (Exception e) {
            throw new RuntimeException("unable to instantiate documentPresentationController '" + documentPresentationControllerClass.getName() + "' for doctype '" + documentType + "'", e);
        }
        return documentPresentationController;
    }

    @Override
    public DocumentPresentationController getDocumentPresentationController(Document document) {
        if (document == null) {
            throw new IllegalArgumentException("invalid (null) document");
        }
        if (document.getDocumentHeader() == null) {
            throw new IllegalArgumentException("invalid (null) document.documentHeader");
        }
        if (!document.getDocumentHeader().hasWorkflowDocument()) {
            throw new IllegalArgumentException("invalid (null) document.documentHeader.workflowDocument");
        }
        String documentType = document.getDocumentHeader().getWorkflowDocument().getDocumentTypeName();
        return this.getDocumentPresentationController(documentType);
    }

    public DocumentDictionaryService getDocumentDictionaryService() {
        return KRADServiceLocatorWeb.getDocumentDictionaryService();
    }
}

