/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.kns.util;

import java.util.Arrays;
import java.util.Optional;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;

public class CookieUtils {
    public static final String AUTH_TOKEN_COOKIE_NAME = "authToken";
    public static final String FIN_AUTH_TOKEN_COOKIE_NAME = "financialsAuthToken";

    public Cookie createCookie(HttpServletRequest request, String name, String value, String path) {
        Cookie cookie = new Cookie(name, value);
        cookie.setSecure(request.isSecure());
        cookie.setPath(path);
        return cookie;
    }

    public Cookie createFinancialsAuthCookie(HttpServletRequest request, String tokenValue, String path) {
        return this.createCookie(request, FIN_AUTH_TOKEN_COOKIE_NAME, tokenValue, path);
    }

    public Cookie createExpiringCookie(HttpServletRequest request, String name, String path) {
        Cookie emptyCookie = this.createCookie(request, name, "", path);
        emptyCookie.setMaxAge(0);
        return emptyCookie;
    }

    public Cookie createExpiringFinanicialsAuthCookie(HttpServletRequest httpRequest) {
        return this.createExpiringCookie(httpRequest, FIN_AUTH_TOKEN_COOKIE_NAME, httpRequest.getContextPath());
    }

    public Cookie createExpiringAuthCookie(HttpServletRequest httpRequest) {
        Cookie cookie = this.createExpiringCookie(httpRequest, AUTH_TOKEN_COOKIE_NAME, "/");
        cookie.setDomain("kuali.co");
        return cookie;
    }

    public Optional<String> getFinancialsAuthToken(HttpServletRequest httpRequest) {
        return this.getCookieValue(httpRequest, FIN_AUTH_TOKEN_COOKIE_NAME);
    }

    public Optional<String> getCoreAuthToken(HttpServletRequest httpRequest) {
        return this.getCookieValue(httpRequest, AUTH_TOKEN_COOKIE_NAME);
    }

    public Optional<String> getCookieValue(HttpServletRequest httpRequest, String name) {
        Cookie[] cookies = httpRequest.getCookies();
        return cookies != null ? Arrays.stream(cookies).filter(cookie -> cookie.getName().equals(name)).findFirst().map(Cookie::getValue) : Optional.empty();
    }
}

