/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.kns.web.struts.form;

import java.lang.reflect.Constructor;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.kfs.kns.datadictionary.BusinessObjectEntry;
import org.kuali.kfs.kns.inquiry.Inquirable;
import org.kuali.kfs.kns.service.BusinessObjectAuthorizationService;
import org.kuali.kfs.kns.service.BusinessObjectMetaDataService;
import org.kuali.kfs.kns.service.DataDictionaryService;
import org.kuali.kfs.kns.service.KNSServiceLocator;
import org.kuali.kfs.kns.web.struts.form.KualiForm;
import org.kuali.kfs.krad.bo.Exporter;
import org.kuali.kfs.krad.datadictionary.exception.UnknownBusinessClassAttributeException;
import org.kuali.kfs.krad.service.KRADServiceLocatorWeb;
import org.kuali.kfs.krad.service.KualiModuleService;
import org.kuali.kfs.krad.service.ModuleService;
import org.kuali.rice.core.api.CoreApiServiceLocator;
import org.kuali.rice.core.api.encryption.EncryptionService;

public class InquiryForm
extends KualiForm {
    private static final Logger LOG = LogManager.getLogger(InquiryForm.class);
    private static final long serialVersionUID = 1L;
    private String fieldConversions;
    private List sections;
    private String businessObjectClassName;
    private Map<String, String> editingMode = new HashMap<String, String>();
    private String formKey;
    private boolean canExport;
    private Map<String, String> inquiryPrimaryKeys;
    private Map<String, String> inquiryDecryptedPrimaryKeys;
    private Inquirable inquirable;

    public InquiryForm() {
        this.editingMode.put("viewOnly", "TRUE");
    }

    @Override
    public void addRequiredNonEditableProperties() {
        super.addRequiredNonEditableProperties();
        this.registerRequiredNonEditableProperty("businessObjectClassName");
        this.registerRequiredNonEditableProperty("methodToCall");
        this.registerRequiredNonEditableProperty("docFormKey");
        this.registerRequiredNonEditableProperty("formKey");
        this.registerRequiredNonEditableProperty("fieldConversions");
        this.registerRequiredNonEditableProperty("backLocation");
    }

    @Override
    public void populate(HttpServletRequest request) {
        this.inquirable = null;
        super.populate(request);
        if (request.getParameter("returnLocation") != null) {
            this.setBackLocation(request.getParameter("returnLocation"));
        }
        if (request.getParameter("docFormKey") != null) {
            this.setFormKey(request.getParameter("docFormKey"));
        }
        if (!"downloadBOAttachment".equals(this.getMethodToCall())) {
            this.inquirable = this.getInquirable(this.getBusinessObjectClassName());
            boolean passedFromPreviousInquiry = !"start".equals(this.getMethodToCall()) && !"continueWithInquiry".equals(this.getMethodToCall()) && !"downloadCustomBOAttachment".equals(this.getMethodToCall());
            this.inquiryPrimaryKeys = new HashMap<String, String>();
            this.inquiryDecryptedPrimaryKeys = new HashMap<String, String>();
            this.populatePKFieldValues(request, this.getBusinessObjectClassName(), passedFromPreviousInquiry);
            this.populateInactiveRecordsInIntoInquirable(this.inquirable, request);
            this.populateExportCapabilities(request, this.getBusinessObjectClassName());
        }
    }

    public Inquirable getInquirable() {
        return this.inquirable;
    }

    protected Inquirable getInquirable(String boClassName) {
        try {
            Class<? extends Inquirable> customInquirableClass = null;
            try {
                BusinessObjectEntry entry = this.getBusinessObjectEntry(boClassName);
                customInquirableClass = entry.getInquiryDefinition().getInquirableClass();
            }
            catch (Exception e) {
                LOG.error("Unable to correlate business object class with maintenance document entry");
            }
            Inquirable kualiInquirable = KNSServiceLocator.getKualiInquirable();
            if (customInquirableClass != null) {
                Class[] defaultConstructor = new Class[]{};
                Constructor<? extends Inquirable> cons = customInquirableClass.getConstructor(defaultConstructor);
                kualiInquirable = cons.newInstance(new Object[0]);
            }
            kualiInquirable.setBusinessObjectClass(Class.forName(boClassName));
            return kualiInquirable;
        }
        catch (Exception e) {
            LOG.error("Error attempting to retrieve inquirable.", (Throwable)e);
            throw new RuntimeException("Error attempting to retrieve inquirable.");
        }
    }

    private List<List<String>> getAltkeys(Class<?> clazz) {
        KualiModuleService kualiModuleService = KRADServiceLocatorWeb.getKualiModuleService();
        ModuleService moduleService = kualiModuleService.getResponsibleModuleService(clazz);
        ArrayList altKeys = null;
        if (moduleService != null) {
            altKeys = moduleService.listAlternatePrimaryKeyFieldNames(clazz);
        }
        return altKeys != null ? altKeys : new ArrayList();
    }

    protected void populatePKFieldValues(HttpServletRequest request, String boClassName, boolean passedFromPreviousInquiry) {
        try {
            EncryptionService encryptionService = CoreApiServiceLocator.getEncryptionService();
            DataDictionaryService dataDictionaryService = KNSServiceLocator.getDataDictionaryService();
            BusinessObjectAuthorizationService businessObjectAuthorizationService = KNSServiceLocator.getBusinessObjectAuthorizationService();
            BusinessObjectMetaDataService businessObjectMetaDataService = KNSServiceLocator.getBusinessObjectMetaDataService();
            Class<?> businessObjectClass = Class.forName(boClassName);
            List<String> boPKeys = businessObjectMetaDataService.listPrimaryKeyFieldNames(businessObjectClass);
            List<List<String>> altKeys = this.getAltkeys(businessObjectClass);
            altKeys.add(boPKeys);
            boolean bFound = false;
            for (List<String> boKeys : altKeys) {
                if (bFound) break;
                int keyCount = boKeys.size();
                int foundCount = 0;
                Iterator<String> iterator = boKeys.iterator();
                while (iterator.hasNext()) {
                    String boKey;
                    String pkParamName = boKey = iterator.next();
                    if (passedFromPreviousInquiry) {
                        pkParamName = "previousPkValue_" + pkParamName;
                    }
                    if (request.getParameter(pkParamName) == null) continue;
                    ++foundCount;
                    String parameter = request.getParameter(pkParamName);
                    Boolean forceUppercase = Boolean.FALSE;
                    try {
                        forceUppercase = dataDictionaryService.getAttributeForceUppercase(businessObjectClass, boKey);
                    }
                    catch (UnknownBusinessClassAttributeException ex) {
                        LOG.warn("BO class " + this.businessObjectClassName + " property " + boKey + " should probably have a DD definition.", (Throwable)ex);
                    }
                    String parameterCopy = parameter;
                    if (forceUppercase.booleanValue()) {
                        parameter = parameter.toUpperCase();
                    }
                    this.inquiryPrimaryKeys.put(boKey, parameter);
                    if (businessObjectAuthorizationService.attributeValueNeedsToBeEncryptedOnFormsAndLinks(businessObjectClass, boKey)) {
                        try {
                            if (!CoreApiServiceLocator.getEncryptionService().isEnabled()) continue;
                            this.inquiryDecryptedPrimaryKeys.put(boKey, encryptionService.decrypt(parameterCopy));
                            continue;
                        }
                        catch (GeneralSecurityException e) {
                            LOG.error("BO class " + this.businessObjectClassName + " property " + boKey + " should have been encrypted, but there was a problem decrypting it.");
                            throw e;
                        }
                    }
                    this.inquiryDecryptedPrimaryKeys.put(boKey, parameter);
                }
                if (foundCount != keyCount) continue;
                bFound = true;
            }
            if (!bFound) {
                LOG.error("All keys not given to lookup for bo class name " + businessObjectClass.getName());
                throw new RuntimeException("All keys not given to lookup for bo class name " + businessObjectClass.getName());
            }
        }
        catch (ClassNotFoundException e) {
            LOG.error("Can't instantiate class: " + boClassName, (Throwable)e);
            throw new RuntimeException("Can't instantiate class: " + boClassName);
        }
        catch (GeneralSecurityException e) {
            LOG.error("Can't decrypt value", (Throwable)e);
            throw new RuntimeException("Can't decrypt value");
        }
    }

    protected void populateExportCapabilities(HttpServletRequest request, String boClassName) {
        this.setCanExport(false);
        BusinessObjectEntry businessObjectEntry = this.getBusinessObjectEntry(boClassName);
        Class<? extends Exporter> exporterClass = businessObjectEntry.getExporterClass();
        if (exporterClass != null) {
            try {
                Exporter exporter = exporterClass.newInstance();
                if (exporter.getSupportedFormats(businessObjectEntry.getBusinessObjectClass()).contains("xml")) {
                    this.setCanExport(true);
                }
            }
            catch (Exception e) {
                LOG.error("Failed to locate or create exporter class: " + exporterClass, (Throwable)e);
                throw new RuntimeException("Failed to locate or create exporter class: " + exporterClass);
            }
        }
    }

    private BusinessObjectEntry getBusinessObjectEntry(String boClassName) {
        return KNSServiceLocator.getBusinessObjectDictionaryService().getBusinessObjectEntry(boClassName);
    }

    public String getFieldConversions() {
        return this.fieldConversions;
    }

    public void setFieldConversions(String fieldConversions) {
        this.fieldConversions = fieldConversions;
    }

    public List getSections() {
        return this.sections;
    }

    public void setSections(List sections) {
        this.sections = sections;
    }

    public String getBusinessObjectClassName() {
        return this.businessObjectClassName;
    }

    public void setBusinessObjectClassName(String businessObjectClassName) {
        this.businessObjectClassName = businessObjectClassName;
    }

    public Map getEditingMode() {
        return this.editingMode;
    }

    public Map<String, String> getInquiryPrimaryKeys() {
        return this.inquiryPrimaryKeys;
    }

    public Map<String, String> retrieveInquiryDecryptedPrimaryKeys() {
        return this.inquiryDecryptedPrimaryKeys;
    }

    public void setInquiryPrimaryKeys(Map<String, String> inquiryPrimaryKeys) {
        this.inquiryPrimaryKeys = inquiryPrimaryKeys;
    }

    public Map<String, Boolean> getInactiveRecordDisplay() {
        return this.getInquirable().getInactiveRecordDisplay();
    }

    protected void populateInactiveRecordsInIntoInquirable(Inquirable inquirable, HttpServletRequest request) {
        Enumeration e = request.getParameterNames();
        while (e.hasMoreElements()) {
            String paramName = (String)e.nextElement();
            if (!paramName.startsWith("inactiveRecordDisplay_")) continue;
            String collectionName = StringUtils.substringAfter((String)paramName, (String)"inactiveRecordDisplay_");
            boolean showInactive = Boolean.parseBoolean(request.getParameter(paramName));
            inquirable.setShowInactiveRecords(collectionName, showInactive);
        }
    }

    public String getFormKey() {
        return this.formKey;
    }

    public void setFormKey(String formKey) {
        this.formKey = formKey;
    }

    public boolean isCanExport() {
        return this.canExport;
    }

    public void setCanExport(boolean canExport) {
        this.canExport = canExport;
    }
}

