/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.krad.datadictionary;

import org.apache.commons.lang3.StringUtils;
import org.kuali.kfs.krad.datadictionary.DataDictionaryDefinition;
import org.kuali.kfs.krad.datadictionary.exception.AttributeValidationException;

public class PrimitiveAttributeDefinition
extends DataDictionaryDefinition {
    private static final long serialVersionUID = -715128943756700821L;
    protected String sourceName;
    protected String targetName;

    public String getSourceName() {
        return this.sourceName;
    }

    public void setSourceName(String sourceName) {
        if (StringUtils.isBlank((CharSequence)sourceName)) {
            throw new IllegalArgumentException("invalid (blank) sourceName");
        }
        this.sourceName = sourceName;
    }

    public String getTargetName() {
        return this.targetName;
    }

    public void setTargetName(String targetName) {
        if (StringUtils.isBlank((CharSequence)targetName)) {
            throw new IllegalArgumentException("invalid (blank) targetName");
        }
        this.targetName = targetName;
    }

    public void completeValidation(Class rootBusinessObjectClass, Class otherBusinessObjectClass) {
        if (!this.businessObjectDictionaryService.isPropertyOf(rootBusinessObjectClass, this.sourceName)) {
            throw new AttributeValidationException("unable to find attribute '" + this.sourceName + "' in relationship class '" + rootBusinessObjectClass + "' ()");
        }
        if (!this.businessObjectDictionaryService.isPropertyOf(otherBusinessObjectClass, this.targetName)) {
            throw new AttributeValidationException("unable to find attribute '" + this.targetName + "' in related class '" + otherBusinessObjectClass.getName() + "' ()");
        }
        Class sourceClass = this.businessObjectDictionaryService.getAttributeClass(rootBusinessObjectClass, this.sourceName);
        Class targetClass = this.businessObjectDictionaryService.getAttributeClass(otherBusinessObjectClass, this.targetName);
        if (null == sourceClass && null != targetClass || null != sourceClass && null == targetClass || !StringUtils.equals((CharSequence)sourceClass.getName(), (CharSequence)targetClass.getName())) {
            String sourceClassName = rootBusinessObjectClass.getName();
            String targetClassName = otherBusinessObjectClass.getName();
            String sourcePath = sourceClassName + "." + this.sourceName;
            String targetPath = targetClassName + "." + this.targetName;
            if (sourcePath != null && !StringUtils.contains((CharSequence)sourcePath, (CharSequence)".principalId") && targetPath != null && !StringUtils.contains((CharSequence)targetPath, (CharSequence)".principalId")) {
                throw new AttributeValidationException("source attribute '" + sourcePath + "' (" + sourceClass + ") and target attribute '" + targetPath + "' (" + targetClass + ") are of differing types ()");
            }
        }
    }

    public String toString() {
        return "PrimitiveAttributeDefinition (" + this.getSourceName() + "," + this.getTargetName() + ")";
    }
}

