/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.krad.datadictionary;

import org.apache.commons.lang3.StringUtils;
import org.kuali.kfs.krad.datadictionary.DataDictionaryDefinition;
import org.kuali.kfs.krad.datadictionary.exception.AttributeValidationException;
import org.kuali.rice.krad.bo.BusinessObject;

public class ReferenceDefinition
extends DataDictionaryDefinition {
    private static final long serialVersionUID = 1737968024207302931L;
    protected String attributeName;
    protected String attributeToHighlightOnFail;
    protected String displayFieldName;
    protected String collection;
    protected Class<? extends BusinessObject> collectionBusinessObjectClass;
    protected Class<? extends BusinessObject> businessObjectClass;

    public String getAttributeName() {
        return this.attributeName;
    }

    public void setAttributeName(String attributeName) {
        if (StringUtils.isBlank((CharSequence)attributeName)) {
            throw new IllegalArgumentException("invalid (blank) attributeName");
        }
        this.attributeName = attributeName;
    }

    public String getAttributeToHighlightOnFail() {
        return this.attributeToHighlightOnFail;
    }

    public void setAttributeToHighlightOnFail(String attributeToHighlightOnFail) {
        if (StringUtils.isBlank((CharSequence)attributeToHighlightOnFail)) {
            throw new IllegalArgumentException("invalid (blank) attributeToHighlightOnFail");
        }
        this.attributeToHighlightOnFail = attributeToHighlightOnFail;
    }

    public String getDisplayFieldName() {
        return this.displayFieldName;
    }

    public void setDisplayFieldName(String displayFieldName) {
        this.displayFieldName = displayFieldName;
    }

    public boolean isDisplayFieldNameSet() {
        return StringUtils.isNotBlank((CharSequence)this.displayFieldName);
    }

    public String getCollection() {
        return this.collection;
    }

    public void setCollection(String collection) {
        this.collection = collection;
    }

    public boolean isCollectionReference() {
        return StringUtils.isNotBlank((CharSequence)this.getCollection());
    }

    public Class<? extends BusinessObject> getCollectionBusinessObjectClass() {
        if (this.collectionBusinessObjectClass == null && this.isCollectionReference()) {
            this.collectionBusinessObjectClass = this.businessObjectDictionaryService.getCollectionElementClass(this.businessObjectClass, this.collection);
        }
        return this.collectionBusinessObjectClass;
    }

    public void setCollectionBusinessObjectClass(Class<? extends BusinessObject> collectionBusinessObjectClass) {
        this.collectionBusinessObjectClass = collectionBusinessObjectClass;
    }

    public void completeValidation(Class rootBusinessObjectClass, Class otherBusinessObjectClass) {
        String tmpAttributeName;
        String string = tmpAttributeName = this.isCollectionReference() ? this.collection : this.attributeName;
        if (!this.businessObjectDictionaryService.isPropertyOf(rootBusinessObjectClass, tmpAttributeName)) {
            throw new AttributeValidationException("unable to find attribute '" + tmpAttributeName + "' in rootBusinessObjectClass '" + rootBusinessObjectClass.getName() + "' ()");
        }
        if (this.isCollectionReference()) {
            this.getCollectionBusinessObjectClass();
            if (this.collectionBusinessObjectClass == null) {
                throw new AttributeValidationException("Unable to determine collectionBusinessObjectClass for collection '" + this.businessObjectClass.getName() + "." + this.collection + "'");
            }
            if (!this.businessObjectDictionaryService.isPropertyOf(this.collectionBusinessObjectClass, this.attributeToHighlightOnFail)) {
                throw new AttributeValidationException("unable to find attribute '" + this.attributeToHighlightOnFail + "' in collectionBusinessObjectClass '" + this.collectionBusinessObjectClass.getName() + "' ()");
            }
        } else if (!this.businessObjectDictionaryService.isPropertyOf(rootBusinessObjectClass, this.attributeToHighlightOnFail)) {
            throw new AttributeValidationException("unable to find attribute '" + this.attributeToHighlightOnFail + "' in rootBusinessObjectClass '" + rootBusinessObjectClass.getName() + "' ()");
        }
    }

    public String toString() {
        return "ReferenceDefinition for attribute " + this.getAttributeName();
    }

    public Class<? extends BusinessObject> getBusinessObjectClass() {
        return this.businessObjectClass;
    }

    public void setBusinessObjectClass(Class<? extends BusinessObject> businessObjectClass) {
        this.businessObjectClass = businessObjectClass;
    }
}

