/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.krad.datadictionary.validation.processor;

import java.util.ArrayList;
import java.util.List;
import org.kuali.kfs.kns.service.KNSServiceLocator;
import org.kuali.kfs.krad.datadictionary.DataDictionaryEntry;
import org.kuali.kfs.krad.datadictionary.exception.AttributeValidationException;
import org.kuali.kfs.krad.datadictionary.validation.AttributeValueReader;
import org.kuali.kfs.krad.datadictionary.validation.DictionaryObjectAttributeValueReader;
import org.kuali.kfs.krad.datadictionary.validation.ValidationUtils;
import org.kuali.kfs.krad.datadictionary.validation.capability.Constrainable;
import org.kuali.kfs.krad.datadictionary.validation.capability.HierarchicallyConstrainable;
import org.kuali.kfs.krad.datadictionary.validation.constraint.CaseConstraint;
import org.kuali.kfs.krad.datadictionary.validation.constraint.Constraint;
import org.kuali.kfs.krad.datadictionary.validation.constraint.DataTypeConstraint;
import org.kuali.kfs.krad.datadictionary.validation.constraint.WhenConstraint;
import org.kuali.kfs.krad.datadictionary.validation.processor.MandatoryElementConstraintProcessor;
import org.kuali.kfs.krad.datadictionary.validation.result.DictionaryValidationResult;
import org.kuali.kfs.krad.datadictionary.validation.result.ProcessorResult;
import org.kuali.rice.core.api.data.DataType;

public class CaseConstraintProcessor
extends MandatoryElementConstraintProcessor<CaseConstraint> {
    private static final String CONSTRAINT_NAME = "case constraint";

    @Override
    public ProcessorResult process(DictionaryValidationResult result, Object value, CaseConstraint caseConstraint, AttributeValueReader attributeValueReader) throws AttributeValidationException {
        DataType fieldDataType;
        if (null == caseConstraint) {
            return new ProcessorResult(result.addNoConstraint(attributeValueReader, CONSTRAINT_NAME));
        }
        AttributeValueReader constraintAttributeReader = attributeValueReader.clone();
        String operator = ValidationUtils.hasText(caseConstraint.getOperator()) ? caseConstraint.getOperator() : "EQUALS";
        AttributeValueReader fieldPathReader = ValidationUtils.hasText(caseConstraint.getPropertyName()) ? this.getChildAttributeValueReader(caseConstraint.getPropertyName(), attributeValueReader) : attributeValueReader;
        Constrainable caseField = null != fieldPathReader ? fieldPathReader.getDefinition(fieldPathReader.getAttributeName()) : null;
        Object fieldValue = null != fieldPathReader ? fieldPathReader.getValue(fieldPathReader.getAttributeName()) : value;
        DataType dataType = fieldDataType = caseField instanceof DataTypeConstraint ? ((DataTypeConstraint)((Object)caseField)).getDataType() : null;
        if (fieldDataType == null) {
            fieldDataType = DataType.STRING;
        }
        if (null == fieldValue) {
            return new ProcessorResult(result.addSkipped(attributeValueReader, CONSTRAINT_NAME), caseField, fieldPathReader, new Constraint[0]);
        }
        ArrayList<Constraint> constraints = new ArrayList<Constraint>();
        for (WhenConstraint wc : caseConstraint.getWhenConstraint()) {
            this.evaluateWhenConstraint(fieldValue, fieldDataType, operator, caseConstraint, wc, attributeValueReader, constraints);
        }
        if (!constraints.isEmpty()) {
            return new ProcessorResult(result.addSuccess(attributeValueReader, CONSTRAINT_NAME), null, constraintAttributeReader, constraints);
        }
        return new ProcessorResult(result.addSkipped(attributeValueReader, CONSTRAINT_NAME));
    }

    private void evaluateWhenConstraint(Object fieldValue, DataType fieldDataType, String operator, CaseConstraint caseConstraint, WhenConstraint wc, AttributeValueReader attributeValueReader, List<Constraint> constraints) {
        block2: {
            block1: {
                if (!ValidationUtils.hasText(wc.getValuePath())) break block1;
                AttributeValueReader whenValueReader = this.getChildAttributeValueReader(wc.getValuePath(), attributeValueReader);
                Object whenValue = whenValueReader.getValue(whenValueReader.getAttributeName());
                if (!ValidationUtils.compareValues(fieldValue, whenValue, fieldDataType, operator, caseConstraint.isCaseSensitive(), this.dateTimeService) || null == wc.getConstraint()) break block2;
                constraints.add(wc.getConstraint());
                break block2;
            }
            List<Object> whenValueList = wc.getValues();
            for (Object whenValue : whenValueList) {
                if (!ValidationUtils.compareValues(fieldValue, whenValue, fieldDataType, operator, caseConstraint.isCaseSensitive(), this.dateTimeService) || null == wc.getConstraint()) continue;
                constraints.add(wc.getConstraint());
                break;
            }
        }
    }

    @Override
    public String getName() {
        return CONSTRAINT_NAME;
    }

    @Override
    public Class<? extends Constraint> getConstraintType() {
        return CaseConstraint.class;
    }

    private AttributeValueReader getChildAttributeValueReader(String key, AttributeValueReader attributeValueReader) throws AttributeValidationException {
        String[] lookupPathTokens = ValidationUtils.getPathTokens(key);
        AttributeValueReader localAttributeValueReader = attributeValueReader;
        block0: for (int i = 0; i < lookupPathTokens.length; ++i) {
            for (Constrainable definition : localAttributeValueReader.getDefinitions()) {
                String attributeName = definition.getName();
                if (!attributeName.equals(lookupPathTokens[i])) continue;
                if (i == lookupPathTokens.length - 1) {
                    localAttributeValueReader.setAttributeName(attributeName);
                    return localAttributeValueReader;
                }
                if (!(definition instanceof HierarchicallyConstrainable)) continue block0;
                String childEntryName = ((HierarchicallyConstrainable)definition).getChildEntryName();
                DataDictionaryEntry entry = KNSServiceLocator.getDataDictionaryService().getDictionaryObjectEntry(childEntryName);
                Object value = attributeValueReader.getValue(attributeName);
                attributeValueReader.setAttributeName(attributeName);
                String attributePath = attributeValueReader.getPath();
                localAttributeValueReader = new DictionaryObjectAttributeValueReader(value, childEntryName, entry, attributePath);
                continue block0;
            }
        }
        return null;
    }
}

