/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.krad.service;

import java.beans.PropertyDescriptor;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang3.StringUtils;
import org.kuali.kfs.krad.bo.DataObjectRelationship;
import org.kuali.kfs.krad.bo.PersistableBusinessObject;
import org.kuali.kfs.krad.dao.BusinessObjectDao;
import org.kuali.kfs.krad.exception.ObjectNotABusinessObjectRuntimeException;
import org.kuali.kfs.krad.exception.ReferenceAttributeDoesntExistException;
import org.kuali.kfs.krad.service.DataObjectMetaDataService;
import org.kuali.kfs.krad.service.KRADServiceLocatorWeb;
import org.kuali.kfs.krad.service.ModuleService;
import org.kuali.kfs.krad.service.PersistenceService;
import org.kuali.kfs.krad.service.PersistenceStructureService;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.rice.core.api.config.property.ConfigContext;
import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.kim.api.identity.PersonService;
import org.kuali.rice.kim.api.services.KimApiServiceLocator;
import org.kuali.rice.krad.bo.BusinessObject;
import org.kuali.rice.krad.bo.ExternalizableBusinessObject;
import org.springframework.transaction.annotation.Transactional;

public class BusinessObjectService {
    private PersistenceService persistenceService;
    private PersistenceStructureService persistenceStructureService;
    private BusinessObjectDao businessObjectDao;
    private PersonService personService;
    private DataObjectMetaDataService dataObjectMetaDataService;
    private boolean illegalBusinessObjectsForSaveInitialized;
    private final Set<String> illegalBusinessObjectsForSave = new HashSet<String>();

    @Transactional
    public <T extends PersistableBusinessObject> T save(T bo) throws IllegalArgumentException {
        this.validateBusinessObjectForSave(bo);
        return (T)this.businessObjectDao.save(bo);
    }

    @Transactional
    public List<? extends PersistableBusinessObject> save(List<? extends PersistableBusinessObject> businessObjects) throws IllegalArgumentException {
        this.validateBusinessObjectForSave(businessObjects);
        return this.businessObjectDao.save(businessObjects);
    }

    @Transactional
    public void linkAndSave(PersistableBusinessObject bo) throws IllegalArgumentException {
        this.validateBusinessObjectForSave(bo);
        this.persistenceService.linkObjects(bo);
        this.businessObjectDao.save(bo);
    }

    private void validateBusinessObjectForSave(PersistableBusinessObject bo) {
        if (bo == null) {
            throw new IllegalArgumentException("Object to be validated is null");
        }
        if (this.doesBusinessObjectPreventSave(bo)) {
            throw new IllegalArgumentException("Object passed in is a BusinessObject but has been restricted from save operations according to configuration parameter 'rice.krad.illegalBusinessObjectsForSave  Passed in type was '" + bo.getClass().getName() + "'.");
        }
    }

    private void validateBusinessObjectForSave(List<? extends PersistableBusinessObject> businessObjects) {
        for (PersistableBusinessObject persistableBusinessObject : businessObjects) {
            this.validateBusinessObjectForSave(persistableBusinessObject);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean doesBusinessObjectPreventSave(PersistableBusinessObject bo) {
        if (!this.illegalBusinessObjectsForSaveInitialized) {
            BusinessObjectService businessObjectService = this;
            synchronized (businessObjectService) {
                String illegalBos;
                boolean applyCheck = true;
                String applyCheckValue = ConfigContext.getCurrentContextConfig().getProperty("rice.krad.illegalBusinessObjectsForSave.applyCheck");
                if (!StringUtils.isEmpty((CharSequence)applyCheckValue)) {
                    applyCheck = Boolean.valueOf(applyCheckValue);
                }
                if (applyCheck && !StringUtils.isEmpty((CharSequence)(illegalBos = ConfigContext.getCurrentContextConfig().getProperty("rice.krad.illegalBusinessObjectsForSave")))) {
                    String[] illegalBosSplit;
                    for (String illegalBo : illegalBosSplit = illegalBos.split(",")) {
                        this.illegalBusinessObjectsForSave.add(illegalBo.trim());
                    }
                }
            }
            this.illegalBusinessObjectsForSaveInitialized = true;
        }
        return this.illegalBusinessObjectsForSave.contains(bo.getClass().getName());
    }

    public <T extends BusinessObject> T findBySinglePrimaryKey(Class<T> clazz, Object primaryKey) {
        return this.businessObjectDao.findBySinglePrimaryKey(clazz, primaryKey);
    }

    public <T extends BusinessObject> T findByPrimaryKey(Class<T> clazz, Map<String, ?> primaryKeys) {
        return this.businessObjectDao.findByPrimaryKey(clazz, primaryKeys);
    }

    public PersistableBusinessObject retrieve(PersistableBusinessObject object) {
        return this.businessObjectDao.retrieve(object);
    }

    public <T extends BusinessObject> Collection<T> findAll(Class<T> clazz) {
        return this.businessObjectDao.findAll(clazz);
    }

    public <T extends BusinessObject> Collection<T> findAllOrderBy(Class<T> clazz, String sortField, boolean sortAscending) {
        return this.businessObjectDao.findMatchingOrderBy(clazz, Collections.emptyMap(), sortField, sortAscending);
    }

    public <T extends BusinessObject> Collection<T> findMatching(Class<T> clazz, Map<String, ?> fieldValues) {
        return this.businessObjectDao.findMatching(clazz, fieldValues);
    }

    public int countMatching(Class clazz, Map<String, ?> fieldValues) {
        return this.businessObjectDao.countMatching(clazz, fieldValues, null, null);
    }

    public int countMatching(Class clazz, Map<String, ?> positiveFieldValues, Map<String, ?> negativeFieldValues) {
        return this.businessObjectDao.countMatching(clazz, positiveFieldValues, negativeFieldValues);
    }

    public <T extends BusinessObject> Collection<T> findMatchingOrderBy(Class<T> clazz, Map<String, ?> fieldValues, String sortField, boolean sortAscending) {
        return this.businessObjectDao.findMatchingOrderBy(clazz, fieldValues, sortField, sortAscending);
    }

    @Transactional
    public void delete(PersistableBusinessObject bo) {
        this.businessObjectDao.delete(bo);
    }

    @Transactional
    public void delete(List<? extends PersistableBusinessObject> boList) {
        this.businessObjectDao.delete(boList);
    }

    @Transactional
    public void deleteMatching(Class clazz, Map<String, ?> fieldValues) {
        this.businessObjectDao.deleteMatching(clazz, fieldValues);
    }

    public BusinessObject getReferenceIfExists(BusinessObject bo, String referenceName) {
        PropertyDescriptor propertyDescriptor;
        if (ObjectUtils.isNull(bo)) {
            throw new IllegalArgumentException("Passed in BusinessObject was null. No processing can be done.");
        }
        if (StringUtils.isEmpty((CharSequence)referenceName)) {
            throw new IllegalArgumentException("Passed in referenceName was empty or null. No processing can be done.");
        }
        try {
            propertyDescriptor = PropertyUtils.getPropertyDescriptor((Object)bo, (String)referenceName);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (propertyDescriptor == null) {
            throw new ReferenceAttributeDoesntExistException("Requested attribute: '" + referenceName + "' does not exist on class: '" + bo.getClass().getName() + "'. GFK");
        }
        Class referenceClass = null;
        if (bo instanceof PersistableBusinessObject) {
            referenceClass = this.persistenceStructureService.getBusinessObjectAttributeClass(((PersistableBusinessObject)bo).getClass(), referenceName);
        }
        if (referenceClass == null) {
            referenceClass = ObjectUtils.getPropertyType(bo, referenceName, this.persistenceStructureService);
        }
        if (referenceClass == null) {
            referenceClass = propertyDescriptor.getPropertyType();
        }
        if (ExternalizableBusinessObject.class.isAssignableFrom(referenceClass)) {
            try {
                BusinessObject referenceBoExternalizable = (BusinessObject)PropertyUtils.getProperty((Object)bo, (String)referenceName);
                if (referenceBoExternalizable != null) {
                    return referenceBoExternalizable;
                }
            }
            catch (Exception referenceBoExternalizable) {
                // empty catch block
            }
        }
        if (!ExternalizableBusinessObject.class.isAssignableFrom(referenceClass) && !PersistableBusinessObject.class.isAssignableFrom(referenceClass)) {
            throw new ObjectNotABusinessObjectRuntimeException("Attribute requested (" + referenceName + ") is of class: '" + referenceClass.getName() + "' and is not a descendant of PersistableBusinessObject. Only descendents of PersistableBusinessObject can be used.");
        }
        DataObjectRelationship boRel = this.dataObjectMetaDataService.getDataObjectRelationship(bo, bo.getClass(), referenceName, "", true, false, false);
        Map<Object, Object> fkMap = boRel != null ? boRel.getParentToChildReferences() : Collections.emptyMap();
        boolean allFkeysHaveValues = true;
        HashMap<String, Object> pkMap = new HashMap<String, Object>();
        for (Map.Entry<Object, Object> entry : fkMap.entrySet()) {
            Object fkFieldValue;
            String fkFieldName = (String)entry.getKey();
            String pkFieldName = (String)entry.getValue();
            try {
                fkFieldValue = PropertyUtils.getProperty((Object)bo, (String)fkFieldName);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            if (ObjectUtils.isNull(fkFieldValue)) {
                allFkeysHaveValues = false;
                break;
            }
            if (String.class.isAssignableFrom(fkFieldValue.getClass())) {
                if (StringUtils.isEmpty((CharSequence)((String)fkFieldValue))) {
                    allFkeysHaveValues = false;
                    break;
                }
                pkMap.put(pkFieldName, fkFieldValue);
                continue;
            }
            pkMap.put(pkFieldName, fkFieldValue);
        }
        BusinessObject referenceBo = null;
        if (allFkeysHaveValues) {
            if (ExternalizableBusinessObject.class.isAssignableFrom(referenceClass)) {
                ModuleService responsibleModuleService = KRADServiceLocatorWeb.getKualiModuleService().getResponsibleModuleService(referenceClass);
                if (responsibleModuleService != null) {
                    return responsibleModuleService.getExternalizableBusinessObject(referenceClass, pkMap);
                }
            } else {
                referenceBo = (BusinessObject)this.findByPrimaryKey(referenceClass, pkMap);
            }
        }
        return referenceBo;
    }

    public void linkUserFields(PersistableBusinessObject bo) {
        if (bo == null) {
            throw new IllegalArgumentException("bo passed in was null");
        }
        bo.linkEditableUserFields();
        this.linkUserFields(Collections.singletonList(bo));
    }

    public void linkUserFields(List<PersistableBusinessObject> bos) {
        if (bos == null) {
            throw new IllegalArgumentException("List of bos passed in was null");
        }
        if (bos.isEmpty()) {
            return;
        }
        for (PersistableBusinessObject bo : bos) {
            Person person;
            List<DataObjectRelationship> relationships = this.dataObjectMetaDataService.getDataObjectRelationships(bo.getClass());
            block1: for (DataObjectRelationship rel : relationships) {
                if (!Person.class.isAssignableFrom(rel.getRelatedClass()) || (person = (Person)ObjectUtils.getPropertyValue(bo, rel.getParentAttributeName())) == null) continue;
                for (Map.Entry<String, String> entry : rel.getParentToChildReferences().entrySet()) {
                    if (!"principalId".equals(entry.getValue())) continue;
                    this.linkUserReference(bo, person, entry.getKey());
                    continue block1;
                }
            }
            if (!this.persistenceStructureService.isPersistable(bo.getClass())) continue;
            Map<String, Class> references = this.persistenceStructureService.listReferenceObjectFields(bo);
            for (Map.Entry<String, Class> entry : references.entrySet()) {
                if (!Person.class.isAssignableFrom(entry.getValue()) || (person = (Person)ObjectUtils.getPropertyValue(bo, entry.getKey())) == null) continue;
                String fkFieldName = this.persistenceStructureService.getForeignKeyFieldName(bo.getClass(), entry.getKey(), "principalId");
                this.linkUserReference(bo, person, fkFieldName);
            }
        }
    }

    private void linkUserReference(PersistableBusinessObject bo, Person user, String fieldName) {
        if (StringUtils.isBlank((CharSequence)user.getPrincipalName())) {
            return;
        }
        Person userFromService = this.getPersonService().getPersonByPrincipalName(user.getPrincipalName());
        if (userFromService == null) {
            return;
        }
        this.setBoField(bo, fieldName, userFromService.getPrincipalId());
    }

    private void setBoField(PersistableBusinessObject bo, String fieldName, Object fieldValue) {
        try {
            ObjectUtils.setObjectProperty(bo, fieldName, fieldValue.getClass(), fieldValue);
        }
        catch (Exception e) {
            throw new RuntimeException("Could not set field [" + fieldName + "] on BO to value: " + fieldValue.toString() + " (see nested exception for details).", e);
        }
    }

    protected BusinessObjectDao getBusinessObjectDao() {
        return this.businessObjectDao;
    }

    public void setBusinessObjectDao(BusinessObjectDao businessObjectDao) {
        this.businessObjectDao = businessObjectDao;
    }

    public void setPersistenceStructureService(PersistenceStructureService persistenceStructureService) {
        this.persistenceStructureService = persistenceStructureService;
    }

    public final void setPersonService(PersonService personService) {
        this.personService = personService;
    }

    protected PersonService getPersonService() {
        if (this.personService == null) {
            this.personService = KimApiServiceLocator.getPersonService();
        }
        return this.personService;
    }

    public final void setPersistenceService(PersistenceService persistenceService) {
        this.persistenceService = persistenceService;
    }

    protected DataObjectMetaDataService getDataObjectMetaDataService() {
        return this.dataObjectMetaDataService;
    }

    public void setDataObjectMetaDataService(DataObjectMetaDataService dataObjectMetadataService) {
        this.dataObjectMetaDataService = dataObjectMetadataService;
    }
}

