/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.krad.service.impl;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.kuali.kfs.coreservice.framework.CoreFrameworkServiceLocator;
import org.kuali.kfs.coreservice.framework.parameter.ParameterService;
import org.kuali.kfs.krad.service.CsrfService;
import org.kuali.kfs.krad.util.CsrfValidator;
import org.kuali.rice.core.api.CoreApiServiceLocator;
import org.kuali.rice.core.api.config.property.ConfigurationService;

public class CsrfServiceImpl
implements CsrfService {
    private ConfigurationService configurationService;
    private ParameterService parameterService;

    @Override
    public boolean validateCsrfIfNecessary(HttpServletRequest request, HttpServletResponse response) {
        if (request == null || response == null) {
            throw new IllegalArgumentException("request and response must not be null");
        }
        return !this.isEnabled() || this.isExemptPath(request) || CsrfValidator.validateCsrf(request, response);
    }

    protected boolean isExemptPath(HttpServletRequest request) {
        String requestURI = request.getRequestURI();
        String[] exemptPaths = this.exemptPaths();
        if (exemptPaths != null) {
            for (String path : exemptPaths) {
                if (!requestURI.contains(path)) continue;
                return true;
            }
        }
        return false;
    }

    protected String[] exemptPaths() {
        String exemptPaths = this.getParameterService().getParameterValueAsString("KR-SYS", "All", "CSRF_EXEMPT_PATHS");
        if (exemptPaths == null) {
            exemptPaths = this.getConfigurationService().getPropertyValueAsString("csrf.exempt.paths");
        }
        if (StringUtils.isBlank((CharSequence)exemptPaths)) {
            return null;
        }
        return exemptPaths.split(",");
    }

    protected boolean isEnabled() {
        Boolean csrfEnabled = this.getParameterService().getParameterValueAsBoolean("KR-SYS", "All", "CSRF_ENABLED_IND");
        if (csrfEnabled == null) {
            csrfEnabled = this.getConfigurationService().getPropertyValueAsBoolean("csrf.enabled", true);
        }
        return csrfEnabled;
    }

    @Override
    public String getSessionToken(HttpServletRequest request) {
        return CsrfValidator.getSessionToken(request);
    }

    public ConfigurationService getConfigurationService() {
        if (this.configurationService == null) {
            this.configurationService = CoreApiServiceLocator.getKualiConfigurationService();
        }
        return this.configurationService;
    }

    public void setConfigurationService(ConfigurationService configurationService) {
        this.configurationService = configurationService;
    }

    public ParameterService getParameterService() {
        if (this.parameterService == null) {
            this.parameterService = CoreFrameworkServiceLocator.getParameterService();
        }
        return this.parameterService;
    }

    public void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }
}

