/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.krad.workflow.attribute;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.kuali.kfs.kns.datadictionary.DocumentEntry;
import org.kuali.kfs.krad.datadictionary.RoutingTypeDefinition;
import org.kuali.kfs.krad.datadictionary.WorkflowAttributes;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.krad.service.KRADServiceLocatorInternal;
import org.kuali.kfs.krad.service.KRADServiceLocatorWeb;
import org.kuali.kfs.krad.workflow.attribute.QualifierResolverBase;
import org.kuali.rice.kew.engine.RouteContext;

public class DataDictionaryQualifierResolver
extends QualifierResolverBase {
    public List<Map<String, String>> resolve(RouteContext context) {
        List<Object> qualifiers;
        String routeLevel = context.getNodeInstance().getName();
        DocumentEntry documentEntry = this.getDocumentEntry(context);
        RoutingTypeDefinition routingTypeDefinition = this.getWorkflowAttributeDefintion(documentEntry, routeLevel);
        Document document = this.getDocument(context);
        if (document != null && routingTypeDefinition != null) {
            qualifiers = KRADServiceLocatorInternal.getWorkflowAttributePropertyResolutionService().resolveRoutingTypeQualifiers(document, routingTypeDefinition);
        } else {
            qualifiers = new ArrayList();
            HashMap basicQualifier = new HashMap();
            qualifiers.add(basicQualifier);
        }
        this.decorateWithCommonQualifiers(qualifiers, document, documentEntry, routeLevel);
        return qualifiers;
    }

    protected DocumentEntry getDocumentEntry(RouteContext context) {
        return KRADServiceLocatorWeb.getDocumentDictionaryService().getDocumentEntry(context.getDocument().getDocumentType().getName());
    }

    protected RoutingTypeDefinition getWorkflowAttributeDefintion(DocumentEntry documentEntry, String routeLevelName) {
        WorkflowAttributes workflowAttributes = documentEntry.getWorkflowAttributes();
        if (workflowAttributes == null) {
            return null;
        }
        Map<String, RoutingTypeDefinition> routingTypeMap = workflowAttributes.getRoutingTypeDefinitions();
        if (routingTypeMap.containsKey(routeLevelName)) {
            return routingTypeMap.get(routeLevelName);
        }
        return null;
    }

    protected void decorateWithCommonQualifiers(List<Map<String, String>> qualifiers, Document document, DocumentEntry documentEntry, String routeLevel) {
        for (Map<String, String> qualifier : qualifiers) {
            this.addCommonQualifiersToMap(qualifier, document, documentEntry, routeLevel);
        }
    }

    protected void addCommonQualifiersToMap(Map<String, String> qualifier, Document document, DocumentEntry documentEntry, String routeLevel) {
        if (document != null) {
            qualifier.put("documentNumber", document.getDocumentNumber());
        }
        if (documentEntry != null) {
            qualifier.put("documentTypeName", documentEntry.getDocumentTypeName());
        }
        qualifier.put("routeNodeName", routeLevel);
    }
}

