/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ld.batch.service.impl;

import java.util.Date;
import org.apache.log4j.Logger;
import org.kuali.kfs.gl.batch.service.PostTransaction;
import org.kuali.kfs.gl.businessobject.Transaction;
import org.kuali.kfs.module.ld.batch.service.LaborAccountingCycleCachingService;
import org.kuali.kfs.module.ld.businessobject.LaborTransaction;
import org.kuali.kfs.module.ld.businessobject.LedgerEntry;
import org.kuali.kfs.sys.service.ReportWriterService;
import org.springframework.transaction.annotation.Transactional;

@Transactional
public class LaborLedgerEntryPoster
implements PostTransaction {
    private static Logger LOG = Logger.getLogger(LaborLedgerEntryPoster.class);
    private LaborAccountingCycleCachingService laborAccountingCycleCachingService;

    public String post(Transaction transaction, int mode, Date postDate, ReportWriterService posterReportWriterService) {
        String operationType = "insert";
        LedgerEntry ledgerEntry = new LedgerEntry((LaborTransaction)transaction);
        try {
            ledgerEntry.setTransactionLedgerEntrySequenceNumber(this.getLaborAccountingCycleCachingService().getMaxLaborSequenceNumber(ledgerEntry) + 1);
            ledgerEntry.setTransactionPostingDate(new java.sql.Date(postDate.getTime()));
            this.getLaborAccountingCycleCachingService().insertLedgerEntry(ledgerEntry);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return operationType;
    }

    public String getDestinationName() {
        return "LD_LDGR_ENTR_T";
    }

    public LaborAccountingCycleCachingService getLaborAccountingCycleCachingService() {
        return this.laborAccountingCycleCachingService;
    }

    public void setLaborAccountingCycleCachingService(LaborAccountingCycleCachingService laborAccountingCycleCachingService) {
        this.laborAccountingCycleCachingService = laborAccountingCycleCachingService;
    }
}

