/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ld.dataaccess.impl;

import java.sql.Date;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.apache.ojb.broker.query.Criteria;
import org.apache.ojb.broker.query.Query;
import org.apache.ojb.broker.query.QueryByCriteria;
import org.apache.ojb.broker.query.QueryFactory;
import org.apache.ojb.broker.query.ReportQueryByCriteria;
import org.kuali.kfs.gl.businessobject.OriginEntryGroup;
import org.kuali.kfs.gl.dataaccess.impl.OriginEntryDaoOjb;
import org.kuali.kfs.module.ld.LaborConstants;
import org.kuali.kfs.module.ld.businessobject.LaborOriginEntry;
import org.kuali.kfs.module.ld.dataaccess.LaborOriginEntryDao;

public class LaborOriginEntryDaoOjb
extends OriginEntryDaoOjb
implements LaborOriginEntryDao {
    private static Logger LOG = Logger.getLogger(LaborOriginEntryDaoOjb.class);
    private static final String DATE = "date";
    private static final String SOURCE_CODE = "sourceCode";
    private static final String PROCESS = "process";
    private static final String VALID = "valid";
    private static final String SCRUB = "scrub";

    @Override
    public Iterator<LaborOriginEntry> getEntriesByGroups(Collection<OriginEntryGroup> groups) {
        LOG.debug((Object)"getEntriesByGroups() started");
        ArrayList<Integer> groupIds = new ArrayList<Integer>();
        for (OriginEntryGroup group : groups) {
            groupIds.add(group.getId());
        }
        Criteria criteria = new Criteria();
        criteria.addIn("entryGroupId", groupIds);
        QueryByCriteria query = QueryFactory.newQuery((Class)this.getEntryClass(), (Criteria)criteria);
        return this.getPersistenceBrokerTemplate().getIteratorByQuery((Query)query);
    }

    @Override
    public int getCountOfEntriesInGroups(Collection<OriginEntryGroup> groups) {
        LOG.debug((Object)"getCountOfEntriesInGroups() started");
        if (groups.size() == 0) {
            return 0;
        }
        ArrayList<Integer> groupIds = new ArrayList<Integer>();
        for (OriginEntryGroup group : groups) {
            groupIds.add(group.getId());
        }
        Criteria criteria = new Criteria();
        criteria.addIn("entryGroupId", groupIds);
        QueryByCriteria query = QueryFactory.newQuery((Class)this.getEntryClass(), (Criteria)criteria);
        return this.getPersistenceBrokerTemplate().getCount((Query)query);
    }

    @Override
    public Iterator<Object[]> getConsolidatedEntriesByGroup(OriginEntryGroup group) {
        LOG.debug((Object)"getConsolidatedEntriesByGroup() started");
        Criteria criteria = new Criteria();
        criteria.addEqualTo("entryGroupId", (Object)group.getId());
        ReportQueryByCriteria query = QueryFactory.newReportQuery((Class)this.getEntryClass(), (Criteria)criteria);
        List<String> attributeList = this.buildConsolidationAttributeList();
        String[] attributes = attributeList.toArray(new String[attributeList.size()]);
        query.setAttributes(attributes);
        List<String> groupByList = this.buildGroupByList();
        String[] groupBy = groupByList.toArray(new String[groupByList.size()]);
        query.addGroupBy(groupBy);
        for (String attribute : groupByList) {
            query.addOrderByAscending(attribute);
        }
        return this.getPersistenceBrokerTemplate().getReportQueryIteratorByQuery((Query)query);
    }

    protected List<String> buildConsolidationAttributeList() {
        List<String> attributeList = this.buildGroupByList();
        attributeList.add("sum(transactionLedgerEntryAmount)");
        return attributeList;
    }

    protected List<String> buildGroupByList() {
        ArrayList<String> groupByList = new ArrayList<String>(LaborConstants.consolidationAttributesOfOriginEntry());
        groupByList.remove("transactionLedgerEntryAmount");
        return groupByList;
    }

    @Override
    public Collection<LaborOriginEntry> testingLaborGetAllEntries() {
        LOG.debug((Object)"testingGetAllEntries() started");
        Criteria criteria = new Criteria();
        QueryByCriteria qbc = QueryFactory.newQuery((Class)this.getEntryClass(), (Criteria)criteria);
        qbc.addOrderByAscending("entryGroupId");
        return this.getPersistenceBrokerTemplate().getCollectionByQuery((Query)qbc);
    }

    @Override
    public Iterator<LaborOriginEntry> getLaborEntriesByGroup(OriginEntryGroup oeg, int sort) {
        LOG.debug((Object)"getEntriesByGroup() started");
        Criteria criteria = new Criteria();
        criteria.addEqualTo("entryGroupId", (Object)oeg.getId());
        QueryByCriteria qbc = QueryFactory.newQuery((Class)this.getEntryClass(), (Criteria)criteria);
        if (sort == 1) {
            qbc.addOrderByAscending("financialDocumentTypeCode");
            qbc.addOrderByAscending("financialSystemOriginationCode");
            qbc.addOrderByAscending("documentNumber");
            qbc.addOrderByAscending("chartOfAccountsCode");
            qbc.addOrderByAscending("accountNumber");
            qbc.addOrderByAscending("subAccountNumber");
            qbc.addOrderByAscending("financialBalanceTypeCode");
            qbc.addOrderByAscending("financialDocumentReversalDate");
            qbc.addOrderByAscending("universityFiscalPeriodCode");
            qbc.addOrderByAscending("universityFiscalYear");
            qbc.addOrderByAscending("financialObjectCode");
            qbc.addOrderByAscending("financialSubObjectCode");
            qbc.addOrderByAscending("financialBalanceTypeCode");
            qbc.addOrderByAscending("financialObjectTypeCode");
            qbc.addOrderByAscending("universityFiscalPeriodCode");
            qbc.addOrderByAscending("financialDocumentTypeCode");
            qbc.addOrderByAscending("financialSystemOriginationCode");
            qbc.addOrderByAscending("documentNumber");
            qbc.addOrderByAscending("transactionLedgerEntrySequenceNumber");
            qbc.addOrderByAscending("transactionLedgerEntryDescription");
            qbc.addOrderByAscending("transactionLedgerEntryAmount");
            qbc.addOrderByAscending("transactionDebitCreditCode");
        } else if (sort == 3) {
            qbc.addOrderByAscending("financialDocumentTypeCode");
            qbc.addOrderByAscending("financialSystemOriginationCode");
            qbc.addOrderByAscending("documentNumber");
            qbc.addOrderByAscending("transactionDebitCreditCode");
            qbc.addOrderByAscending("chartOfAccountsCode");
            qbc.addOrderByAscending("accountNumber");
            qbc.addOrderByAscending("financialObjectCode");
        } else if (sort == 4) {
            qbc.addOrderByAscending("universityFiscalYear");
            qbc.addOrderByAscending("chartOfAccountsCode");
            qbc.addOrderByAscending("accountNumber");
            qbc.addOrderByAscending("financialObjectCode");
            qbc.addOrderByAscending("financialObjectTypeCode");
            qbc.addOrderByAscending("financialBalanceTypeCode");
            qbc.addOrderByAscending("universityFiscalPeriodCode");
            qbc.addOrderByAscending("financialDocumentTypeCode");
            qbc.addOrderByAscending("financialSystemOriginationCode");
            qbc.addOrderByAscending("documentNumber");
            qbc.addOrderByAscending("transactionLedgerEntryDescription");
        } else {
            qbc.addOrderByAscending("chartOfAccountsCode");
            qbc.addOrderByAscending("accountNumber");
            qbc.addOrderByAscending("subAccountNumber");
            qbc.addOrderByAscending("financialObjectCode");
            qbc.addOrderByAscending("financialObjectTypeCode");
            qbc.addOrderByAscending("universityFiscalPeriodCode");
            qbc.addOrderByAscending("financialDocumentTypeCode");
            qbc.addOrderByAscending("financialSystemOriginationCode");
            qbc.addOrderByAscending("documentNumber");
            qbc.addOrderByAscending("transactionLedgerEntryDescription");
        }
        return this.getPersistenceBrokerTemplate().getIteratorByQuery((Query)qbc);
    }

    @Override
    public Collection getMatchingEntriesByCollection(Map searchCriteria) {
        LOG.debug((Object)"getMatchingEntries() started");
        Criteria criteria = new Criteria();
        for (String element : searchCriteria.keySet()) {
            criteria.addEqualTo(element, searchCriteria.get(element));
        }
        QueryByCriteria qbc = QueryFactory.newQuery((Class)this.getEntryClass(), (Criteria)criteria);
        qbc.addOrderByAscending("entryGroupId");
        return this.getPersistenceBrokerTemplate().getCollectionByQuery((Query)qbc);
    }

    @Deprecated
    public void saveOriginEntry(LaborOriginEntry entry) {
        LOG.debug((Object)"saveOriginEntry() started");
        if (entry != null && entry.getTransactionLedgerEntryDescription() != null && entry.getTransactionLedgerEntryDescription().length() > 40) {
            entry.setTransactionLedgerEntryDescription(entry.getTransactionLedgerEntryDescription().substring(0, 40));
        }
        this.getPersistenceBrokerTemplate().store((Object)entry);
    }

    public Iterator getSummaryByGroupId(Collection groupIdList) {
        LOG.debug((Object)"getSummaryByGroupId() started");
        if (groupIdList == null || groupIdList.size() <= 0) {
            return null;
        }
        ArrayList<Integer> ids = new ArrayList<Integer>();
        for (OriginEntryGroup element : groupIdList) {
            ids.add(element.getId());
        }
        Criteria criteria = new Criteria();
        criteria.addIn("entryGroupId", ids);
        ReportQueryByCriteria query = QueryFactory.newReportQuery((Class)this.getEntryClass(), (Criteria)criteria);
        String[] attributeList = new String[]{"universityFiscalYear", "universityFiscalPeriodCode", "financialBalanceTypeCode", "financialSystemOriginationCode", "transactionDebitCreditCode", "sum(transactionLedgerEntryAmount)", "count(*)"};
        String[] groupList = new String[]{"universityFiscalYear", "universityFiscalPeriodCode", "financialBalanceTypeCode", "financialSystemOriginationCode", "transactionDebitCreditCode"};
        query.setAttributes(attributeList);
        query.addGroupBy(groupList);
        for (int i = 0; i < groupList.length; ++i) {
            query.addOrderByAscending(groupList[i]);
        }
        return this.getPersistenceBrokerTemplate().getReportQueryIteratorByQuery((Query)query);
    }

    @Override
    public Collection<LaborOriginEntry> getEntryCollectionByGroup(OriginEntryGroup group) {
        LOG.debug((Object)"getEntriesByGroups() started");
        Criteria criteria = new Criteria();
        criteria.addEqualTo("entryGroupId", (Object)group.getId());
        QueryByCriteria query = QueryFactory.newQuery((Class)this.getEntryClass(), (Criteria)criteria);
        return this.getPersistenceBrokerTemplate().getCollectionByQuery((Query)query);
    }

    @Override
    public Collection getLaborBackupGroups(Date groupDate) {
        LOG.debug((Object)"getGroupsToBackup() started");
        Criteria criteria = new Criteria();
        criteria.addEqualTo(SOURCE_CODE, (Object)"LBAK");
        criteria.addEqualTo(SCRUB, (Object)Boolean.TRUE);
        criteria.addEqualTo(PROCESS, (Object)Boolean.TRUE);
        criteria.addEqualTo(VALID, (Object)Boolean.TRUE);
        QueryByCriteria qbc = QueryFactory.newQuery(OriginEntryGroup.class, (Criteria)criteria);
        return this.getPersistenceBrokerTemplate().getCollectionByQuery((Query)qbc);
    }

    @Override
    public Collection getLaborGroupsToBackup(Date groupDate) {
        LOG.debug((Object)"getLaborGroupsToBackup() started");
        Criteria criteria = new Criteria();
        criteria.addLessOrEqualThan((Object)DATE, (Object)groupDate);
        criteria.addEqualTo(SCRUB, (Object)Boolean.TRUE);
        criteria.addEqualTo(PROCESS, (Object)Boolean.TRUE);
        criteria.addEqualTo(VALID, (Object)Boolean.TRUE);
        QueryByCriteria qbc = QueryFactory.newQuery(OriginEntryGroup.class, (Criteria)criteria);
        return this.getPersistenceBrokerTemplate().getCollectionByQuery((Query)qbc);
    }
}

