/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ld.dataaccess.impl;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.apache.ojb.broker.query.Criteria;
import org.apache.ojb.broker.query.Query;
import org.apache.ojb.broker.query.QueryFactory;
import org.apache.ojb.broker.query.ReportQueryByCriteria;
import org.kuali.kfs.gl.OJBUtility;
import org.kuali.kfs.module.ld.businessobject.AccountStatusBaseFunds;
import org.kuali.kfs.module.ld.dataaccess.LaborBaseFundsDao;
import org.kuali.kfs.module.ld.util.ConsolidationUtil;
import org.kuali.kfs.sys.ObjectUtil;
import org.kuali.rice.core.framework.persistence.ojb.dao.PlatformAwareDaoBaseOjb;

public class LaborBaseFundsDaoOjb
extends PlatformAwareDaoBaseOjb
implements LaborBaseFundsDao {
    private static Logger LOG = Logger.getLogger(LaborBaseFundsDaoOjb.class);

    @Override
    public List<AccountStatusBaseFunds> findLaborBaseFunds(Map fieldValues, boolean isConsolidated) {
        LOG.debug((Object)"Start findLaborBaseFunds()");
        Iterator<Object[]> queryResults = this.findLaborBaseFundsRawData(fieldValues, isConsolidated);
        ArrayList<AccountStatusBaseFunds> BaseFundsCollection = new ArrayList<AccountStatusBaseFunds>();
        while (queryResults != null && queryResults.hasNext()) {
            BaseFundsCollection.add(this.marshalAccountStatusBaseFunds(queryResults.next()));
        }
        return BaseFundsCollection;
    }

    protected Iterator<Object[]> findLaborBaseFundsRawData(Map fieldValues, boolean isConsolidated) {
        Criteria criteria = OJBUtility.buildCriteriaFromMap((Map)fieldValues, (Object)((Object)new AccountStatusBaseFunds()));
        criteria.addEqualTo("financialBalanceTypeCode", (Object)"BB");
        criteria.addEqualToField("laborObject.universityFiscalYear", "universityFiscalYear");
        criteria.addEqualToField("laborObject.chartOfAccountsCode", "chartOfAccountsCode");
        criteria.addEqualToField("laborObject.financialObjectCode", "financialObjectCode");
        criteria.addNotNull("laborObject.financialObjectFringeOrSalaryCode");
        ReportQueryByCriteria query = QueryFactory.newReportQuery(AccountStatusBaseFunds.class, (Criteria)criteria);
        List<String> groupByList = this.getGroupByList(isConsolidated);
        String[] groupBy = groupByList.toArray(new String[groupByList.size()]);
        query.addGroupBy(groupBy);
        List<String> getAttributeList = this.getAttributeListForBaseFunds(isConsolidated, false);
        String[] attributes = getAttributeList.toArray(new String[getAttributeList.size()]);
        query.setAttributes(attributes);
        return this.getPersistenceBrokerTemplate().getReportQueryIteratorByQuery((Query)query);
    }

    protected AccountStatusBaseFunds marshalAccountStatusBaseFunds(Object[] queryResult) {
        AccountStatusBaseFunds baseFunds = new AccountStatusBaseFunds();
        List<String> keyFields = this.getAttributeListForBaseFunds(false, true);
        ObjectUtil.buildObject((Object)((Object)baseFunds), (Object[])queryResult, keyFields);
        return baseFunds;
    }

    protected List<String> getGroupByList(boolean isConsolidated) {
        ArrayList<String> groupByList = new ArrayList<String>();
        groupByList.add("universityFiscalYear");
        groupByList.add("chartOfAccountsCode");
        groupByList.add("accountNumber");
        groupByList.add("financialObjectCode");
        if (!isConsolidated) {
            groupByList.add("subAccountNumber");
            groupByList.add("financialSubObjectCode");
        }
        return groupByList;
    }

    protected List<String> getAttributeList(boolean isConsolidated) {
        List<String> attributeList = this.getGroupByList(isConsolidated);
        if (isConsolidated) {
            attributeList.add("'*ALL*'");
            attributeList.add("'*ALL*'");
        }
        return attributeList;
    }

    protected List<String> getAttributeListForBaseFunds(boolean isConsolidated, boolean isAttributeNameNeeded) {
        List<String> attributeList = this.getAttributeList(isConsolidated);
        if (!isAttributeNameNeeded) {
            attributeList.add(ConsolidationUtil.sum("accountLineAnnualBalanceAmount"));
            attributeList.add(ConsolidationUtil.sum("financialBeginningBalanceLineAmount"));
            attributeList.add(ConsolidationUtil.sum("contractsGrantsBeginningBalanceAmount"));
        } else {
            attributeList.add("accountLineAnnualBalanceAmount");
            attributeList.add("financialBeginningBalanceLineAmount");
            attributeList.add("contractsGrantsBeginningBalanceAmount");
        }
        return attributeList;
    }
}

