/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ld.document.validation.impl;

import java.util.List;
import org.kuali.kfs.coa.businessobject.Account;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.module.ld.document.LaborExpenseTransferDocumentBase;
import org.kuali.kfs.sys.businessobject.AccountingLine;
import org.kuali.kfs.sys.document.validation.GenericValidation;
import org.kuali.kfs.sys.document.validation.event.AttributedDocumentEvent;

public class BenefitExpenseTransferSameAccountValidation
extends GenericValidation {
    private Document documentForValidation;
    private AccountingLine accountingLineForValidation;

    public boolean validate(AttributedDocumentEvent event) {
        boolean result = true;
        Document documentForValidation = this.getDocumentForValidation();
        AccountingLine accountingLine = this.getAccountingLineForValidation();
        boolean isTargetLine = accountingLine.isTargetAccountingLine();
        if (!isTargetLine && !this.hasSameAccount(documentForValidation, accountingLine)) {
            GlobalVariables.getMessageMap().putError("targetAccountingLines", "error.labor.accountNotSame", new String[0]);
            result = false;
        }
        return result;
    }

    public boolean hasSameAccount(Document document, AccountingLine accountingLine) {
        LaborExpenseTransferDocumentBase expenseTransferDocument = (LaborExpenseTransferDocumentBase)document;
        List sourceAccountingLines = expenseTransferDocument.getSourceAccountingLines();
        accountingLine.refreshReferenceObject("account");
        Account cachedAccount = accountingLine.getAccount();
        for (AccountingLine sourceAccountingLine : sourceAccountingLines) {
            Account account = sourceAccountingLine.getAccount();
            account.setChartOfAccountsCode(sourceAccountingLine.getChartOfAccountsCode());
            account.setAccountNumber(sourceAccountingLine.getAccountNumber());
            if (account.equals((Object)cachedAccount)) continue;
            return false;
        }
        return true;
    }

    public void setDocumentForValidation(Document documentForValidation) {
        this.documentForValidation = documentForValidation;
    }

    public Document getDocumentForValidation() {
        return this.documentForValidation;
    }

    public AccountingLine getAccountingLineForValidation() {
        return this.accountingLineForValidation;
    }

    public void setAccountingLineForValidation(AccountingLine accountingLineForValidation) {
        this.accountingLineForValidation = accountingLineForValidation;
    }
}

