/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ld.util;

import java.util.ArrayList;
import java.util.List;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.ld.LaborConstants;
import org.kuali.kfs.module.ld.businessobject.LaborOriginEntry;
import org.kuali.kfs.sys.ObjectUtil;
import org.kuali.rice.core.api.util.type.AbstractKualiDecimal;
import org.kuali.rice.core.api.util.type.KualiDecimal;

public class LaborLedgerUnitOfWork {
    private LaborOriginEntry workingEntry;
    private List<String> keyFields;
    private int numOfMember;

    public LaborLedgerUnitOfWork() {
        this(null);
    }

    public LaborLedgerUnitOfWork(LaborOriginEntry laborOriginEntry) {
        this.resetLaborLedgerUnitOfWork(laborOriginEntry);
    }

    public void resetLaborLedgerUnitOfWork(LaborOriginEntry laborOriginEntry) {
        this.resetLaborLedgerUnitOfWork(laborOriginEntry, null);
    }

    public void resetLaborLedgerUnitOfWork(LaborOriginEntry laborOriginEntry, List<String> keyFields) {
        this.workingEntry = new LaborOriginEntry();
        this.setKeyFields(keyFields);
        if (laborOriginEntry != null) {
            ObjectUtil.buildObject((Object)this.workingEntry, (Object)laborOriginEntry, this.getKeyFields());
            boolean creditIndicator = "C".equals(laborOriginEntry.getTransactionDebitCreditCode());
            KualiDecimal entryAmount = laborOriginEntry.getTransactionLedgerEntryAmount();
            KualiDecimal unitAmount = creditIndicator ? (KualiDecimal)entryAmount.negated() : entryAmount;
            this.workingEntry.setTransactionLedgerEntryAmount(unitAmount);
            this.workingEntry.setTransactionDebitCreditCode(laborOriginEntry.getTransactionDebitCreditCode());
            this.numOfMember = 1;
        }
    }

    public boolean addEntryIntoUnit(LaborOriginEntry laborOriginEntry) {
        if (this.hasSameKey(laborOriginEntry)) {
            KualiDecimal unitAmount = this.workingEntry.getTransactionLedgerEntryAmount();
            KualiDecimal entryAmount = laborOriginEntry.getTransactionLedgerEntryAmount();
            boolean creditIndicator = "C".equals(laborOriginEntry.getTransactionDebitCreditCode());
            unitAmount = creditIndicator ? (KualiDecimal)unitAmount.subtract((AbstractKualiDecimal)entryAmount) : (KualiDecimal)unitAmount.add((AbstractKualiDecimal)entryAmount);
            this.workingEntry.setTransactionLedgerEntryAmount(unitAmount);
            ++this.numOfMember;
            return true;
        }
        return false;
    }

    public boolean canContain(LaborOriginEntry laborOriginEntry) {
        return this.hasSameKey(laborOriginEntry);
    }

    public boolean hasSameKey(LaborOriginEntry laborOriginEntry) {
        if (ObjectUtils.isNull((Object)laborOriginEntry)) {
            return false;
        }
        return ObjectUtil.equals((Object)this.workingEntry, (Object)laborOriginEntry, this.getKeyFields());
    }

    public String toString() {
        ArrayList<String> printablekeyFields = new ArrayList<String>(this.getKeyFields());
        printablekeyFields.add("transactionLedgerEntryAmount");
        return ObjectUtil.buildPropertyMap((Object)this.workingEntry, printablekeyFields).toString();
    }

    public LaborOriginEntry getWorkingEntry() {
        return this.workingEntry;
    }

    public void setWorkingEntry(LaborOriginEntry workingEntry) {
        this.workingEntry = workingEntry;
    }

    public List<String> getKeyFields() {
        return this.keyFields;
    }

    public void setKeyFields(List<String> keyFields) {
        this.keyFields = keyFields != null ? keyFields : this.getDefaultKeyFields();
    }

    public int getNumOfMember() {
        return this.numOfMember;
    }

    public void setNumOfMember(int numOfMember) {
        this.numOfMember = numOfMember;
    }

    protected List<String> getDefaultKeyFields() {
        ArrayList<String> defaultKeyFields = new ArrayList<String>(LaborConstants.consolidationAttributesOfOriginEntry());
        defaultKeyFields.remove("transactionLedgerEntryAmount");
        defaultKeyFields.remove("transactionDebitCreditCode");
        return defaultKeyFields;
    }
}

