/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ld.businessobject;

import java.util.HashSet;
import org.kuali.kfs.integration.ld.LaborModuleService;
import org.kuali.kfs.sys.businessobject.AccountingLine;
import org.kuali.kfs.sys.businessobject.AccountingLineOverride;
import org.kuali.kfs.sys.businessobject.SourceAccountingLine;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.document.AccountingDocument;

public class LaborAccountingLineOverride {
    public static void populateFromInput(AccountingLine line) {
        HashSet<Integer> overrideInputComponents = new HashSet<Integer>();
        if (line.getAccountExpiredOverride()) {
            overrideInputComponents.add(AccountingLineOverride.COMPONENT.EXPIRED_ACCOUNT);
        }
        if (line.isObjectBudgetOverride()) {
            overrideInputComponents.add(AccountingLineOverride.COMPONENT.NON_BUDGETED_OBJECT);
        }
        if (line.getNonFringeAccountOverride()) {
            overrideInputComponents.add(AccountingLineOverride.COMPONENT.NON_FRINGE_ACCOUNT_USED);
        }
        Integer[] inputComponentArray = overrideInputComponents.toArray(new Integer[overrideInputComponents.size()]);
        line.setOverrideCode(AccountingLineOverride.valueOf((Integer[])inputComponentArray).getCode());
    }

    public static void processForOutput(AccountingDocument document, AccountingLine line) {
        AccountingLineOverride fromCurrentCode = AccountingLineOverride.valueOf((String)line.getOverrideCode());
        AccountingLineOverride needed = LaborAccountingLineOverride.determineNeededOverrides(document, line);
        line.setAccountExpiredOverrideNeeded(needed.hasComponent(AccountingLineOverride.COMPONENT.EXPIRED_ACCOUNT));
        if (line.getAccountExpiredOverrideNeeded()) {
            if (line instanceof SourceAccountingLine) {
                line.setAccountExpiredOverride(true);
            } else {
                line.setAccountExpiredOverride(fromCurrentCode.hasComponent(AccountingLineOverride.COMPONENT.EXPIRED_ACCOUNT));
            }
        }
        line.setObjectBudgetOverride(fromCurrentCode.hasComponent(AccountingLineOverride.COMPONENT.NON_BUDGETED_OBJECT));
        line.setObjectBudgetOverrideNeeded(needed.hasComponent(AccountingLineOverride.COMPONENT.NON_BUDGETED_OBJECT));
        line.setNonFringeAccountOverride(fromCurrentCode.hasComponent(AccountingLineOverride.COMPONENT.NON_FRINGE_ACCOUNT_USED));
        line.setNonFringeAccountOverrideNeeded(needed.hasComponent(AccountingLineOverride.COMPONENT.NON_FRINGE_ACCOUNT_USED));
    }

    @Deprecated
    public static void processForOutput(AccountingLine line) {
        AccountingLineOverride fromCurrentCode = AccountingLineOverride.valueOf((String)line.getOverrideCode());
        AccountingLineOverride needed = LaborAccountingLineOverride.determineNeededOverrides(line);
        line.setAccountExpiredOverrideNeeded(needed.hasComponent(AccountingLineOverride.COMPONENT.EXPIRED_ACCOUNT));
        if (line.getAccountExpiredOverrideNeeded()) {
            if (line instanceof SourceAccountingLine) {
                line.setAccountExpiredOverride(true);
            } else {
                line.setAccountExpiredOverride(fromCurrentCode.hasComponent(AccountingLineOverride.COMPONENT.EXPIRED_ACCOUNT));
            }
        }
        line.setObjectBudgetOverride(fromCurrentCode.hasComponent(AccountingLineOverride.COMPONENT.NON_BUDGETED_OBJECT));
        line.setObjectBudgetOverrideNeeded(needed.hasComponent(AccountingLineOverride.COMPONENT.NON_BUDGETED_OBJECT));
        line.setNonFringeAccountOverride(fromCurrentCode.hasComponent(AccountingLineOverride.COMPONENT.NON_FRINGE_ACCOUNT_USED));
        line.setNonFringeAccountOverrideNeeded(needed.hasComponent(AccountingLineOverride.COMPONENT.NON_FRINGE_ACCOUNT_USED));
    }

    public static AccountingLineOverride determineNeededOverrides(AccountingDocument document, AccountingLine line) {
        LaborModuleService laborModuleService = (LaborModuleService)SpringContext.getBean(LaborModuleService.class);
        return laborModuleService.determineNeededOverrides(document, line);
    }

    @Deprecated
    public static AccountingLineOverride determineNeededOverrides(AccountingLine line) {
        LaborModuleService laborModuleService = (LaborModuleService)SpringContext.getBean(LaborModuleService.class);
        return laborModuleService.determineNeededOverrides(line);
    }
}

