/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ld.service.impl;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.kuali.kfs.module.ld.batch.service.LaborAccountingCycleCachingService;
import org.kuali.kfs.module.ld.businessobject.LedgerEntry;
import org.kuali.kfs.module.ld.dataaccess.LaborLedgerEntryDao;
import org.kuali.kfs.module.ld.service.LaborLedgerEntryService;
import org.springframework.transaction.annotation.Transactional;

@Transactional
public class LaborLedgerEntryServiceImpl
implements LaborLedgerEntryService {
    private LaborLedgerEntryDao laborLedgerEntryDao;
    private LaborAccountingCycleCachingService laborAccountingCycleCachingService;

    @Override
    public void save(LedgerEntry ledgerEntry) {
        this.laborAccountingCycleCachingService.insertLedgerEntry(ledgerEntry);
    }

    @Override
    public Integer getMaxSequenceNumber(LedgerEntry ledgerEntry) {
        return this.laborAccountingCycleCachingService.getMaxLaborSequenceNumber(ledgerEntry);
    }

    @Override
    public Iterator<LedgerEntry> find(Map<String, String> fieldValues) {
        return this.laborLedgerEntryDao.find(fieldValues);
    }

    @Override
    public List<String> findEmployeesWithPayType(Map<Integer, Set<String>> payPeriods, List<String> balanceTypes, Map<String, Set<String>> earnCodePayGroupMap) {
        return this.laborLedgerEntryDao.findEmployeesWithPayType(payPeriods, balanceTypes, earnCodePayGroupMap);
    }

    @Override
    public boolean isEmployeeWithPayType(String emplid, Map<Integer, Set<String>> payPeriods, List<String> balanceTypes, Map<String, Set<String>> earnCodePayGroupMap) {
        return this.laborLedgerEntryDao.isEmployeeWithPayType(emplid, payPeriods, balanceTypes, earnCodePayGroupMap);
    }

    @Override
    public void deleteLedgerEntriesPriorToYear(Integer fiscalYear, String chartOfAccountsCode) {
        this.laborLedgerEntryDao.deleteLedgerEntriesPriorToYear(fiscalYear, chartOfAccountsCode);
    }

    public void setLaborLedgerEntryDao(LaborLedgerEntryDao laborLedgerEntryDao) {
        this.laborLedgerEntryDao = laborLedgerEntryDao;
    }

    public void setLaborAccountingCycleCachingService(LaborAccountingCycleCachingService laborAccountingCycleCachingService) {
        this.laborAccountingCycleCachingService = laborAccountingCycleCachingService;
    }
}

